/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;

public class MaskedSwitch
extends Group {
    private boolean[] mask;
    private Node[] renderedChild;
    private int numRenderedChild;

    public MaskedSwitch() {
        this.mask = new boolean[0];
        this.renderedChild = new Node[1];
    }

    public MaskedSwitch(boolean[] blArray) {
        this.mask = blArray;
    }

    protected void recomputeBounds() {
        if (this.mask.length == 0) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        int n = Math.min(this.mask.length, this.childList.length);
        BoundingVolume boundingVolume = null;
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (this.childList[i] == null || (boundingVolume = this.childList[i].getBounds()) instanceof BoundingVoid) continue;
            boundingVolume.getExtents(this.wkVec1, this.wkVec2);
            if (this.wkVec1[0] < f) {
                f = this.wkVec1[0];
            }
            if (this.wkVec1[1] < f2) {
                f2 = this.wkVec1[1];
            }
            if (this.wkVec1[2] < f3) {
                f3 = this.wkVec1[2];
            }
            if (this.wkVec2[0] > f4) {
                f4 = this.wkVec2[0];
            }
            if (this.wkVec2[1] > f5) {
                f5 = this.wkVec2[1];
            }
            if (!(this.wkVec2[2] > f6)) continue;
            f6 = this.wkVec2[2];
        }
        if (boundingVolume == null) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        boundingVolume.getExtents(this.wkVec1, this.wkVec2);
        if (this.bounds == null || this.bounds instanceof BoundingVoid) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f4, f5, f6);
    }

    public void setChild(Node node, int n) throws InvalidWriteTimingException {
        super.setChild(node, n);
        if (n < this.mask.length - 1 && this.mask[n]) {
            this.rebuildRenderedChild();
        }
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < this.mask.length - 1 && this.mask[n]) {
            this.rebuildRenderedChild();
        }
        super.removeChild(n);
    }

    public Node[] getRenderableChild() {
        return this.renderedChild;
    }

    public int numRenderableChildren() {
        return this.numRenderedChild;
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        super.removeAllChildren();
        this.numRenderedChild = 0;
        if (this.renderedChild.length > 1) {
            this.renderedChild = new Node[1];
        }
        this.renderedChild[0] = null;
    }

    public void setMask(boolean[] blArray) {
        this.mask = blArray;
        this.rebuildRenderedChild();
    }

    private void rebuildRenderedChild() {
        int n;
        int n2 = this.mask.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!this.mask[n]) continue;
            ++n3;
        }
        n2 = Math.min(n2, this.childList.length);
        if (n3 == 0) {
            this.renderedChild = new Node[1];
            this.renderedChild[0] = null;
            return;
        }
        if (this.renderedChild.length != n3) {
            this.renderedChild = new Node[n3];
        }
        this.numRenderedChild = Math.min(n3, n2);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.mask[i] || this.childList[i] == null) continue;
            this.renderedChild[n++] = this.childList[i];
        }
    }
}

