/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.texture;

import org.j3d.renderer.aviatrix3d.texture.AVTextureCache;
import org.j3d.renderer.aviatrix3d.texture.FixedTextureCache;
import org.j3d.renderer.aviatrix3d.texture.LRUTextureCache;
import org.j3d.renderer.aviatrix3d.texture.WeakRefTextureCache;
import org.j3d.texture.CacheAlreadySetException;
import org.j3d.texture.TextureCacheFactory;
import org.j3d.util.IntHashMap;

public class AVTextureCacheFactory
implements TextureCacheFactory {
    private static final int NO_CACHE_SET = -1;
    private static final int DEFAULT_CACHE_ID = 1;
    private static IntHashMap cacheMap = new IntHashMap();
    private static int defaultCacheType = -1;

    private AVTextureCacheFactory() {
    }

    public static void setDefaultCacheType(int n) throws CacheAlreadySetException {
        if (defaultCacheType != -1) {
            throw new CacheAlreadySetException();
        }
        defaultCacheType = n;
    }

    public static AVTextureCache getCache() {
        if (defaultCacheType == -1) {
            String string = System.getProperty("org.j3d.texture.DefaultCacheType");
            defaultCacheType = string == null ? 1 : (string.equals("fixed") ? 1 : (string.equals("lru") ? 2 : (string.equals("weakref") ? 3 : 1)));
        }
        return AVTextureCacheFactory.getCache(defaultCacheType);
    }

    public static AVTextureCache getCache(int n) {
        AVTextureCache aVTextureCache = (AVTextureCache)cacheMap.get(n);
        if (aVTextureCache == null) {
            switch (n) {
                case 1: {
                    aVTextureCache = new FixedTextureCache();
                    cacheMap.put(1, (Object)aVTextureCache);
                    break;
                }
                case 2: {
                    aVTextureCache = new LRUTextureCache();
                    cacheMap.put(2, (Object)aVTextureCache);
                    break;
                }
                case 3: {
                    aVTextureCache = new WeakRefTextureCache();
                    cacheMap.put(3, (Object)aVTextureCache);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid cache type");
                }
            }
        }
        return aVTextureCache;
    }

    public static void registerCacheType(int n, AVTextureCache aVTextureCache) {
        if (n <= 10) {
            throw new IllegalArgumentException("Invalid cacheType value");
        }
        cacheMap.put(n, (Object)aVTextureCache);
    }
}

