/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.util;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.renderer.aviatrix3d.util.SceneGraphTraversalObserver;
import org.j3d.renderer.aviatrix3d.util.SceneGraphTraverser;

public class ScenePrinter
implements SceneGraphTraversalObserver {
    private SceneGraphTraverser sgt = new SceneGraphTraverser();
    private boolean printBounds;
    private boolean printPickMask;
    private boolean printChildCount;
    private boolean printDashes;
    private boolean printHashCode;
    private boolean useShortNames;
    private boolean printMatrix;
    private Matrix4f matrix;

    public ScenePrinter() {
        this.sgt.setObserver(this);
        this.printPickMask = false;
        this.printBounds = false;
        this.printChildCount = false;
        this.printDashes = false;
        this.useShortNames = false;
        this.printHashCode = false;
        this.printMatrix = false;
    }

    public void observedNode(SceneGraphObject sceneGraphObject, SceneGraphObject sceneGraphObject2, boolean bl, int n) {
        if (sceneGraphObject == null) {
            System.out.println("ROOT");
        }
        this.indent(n, true);
        if (sceneGraphObject2 == null) {
            System.out.print("NULL child");
        } else {
            String string = sceneGraphObject2.getClass().getName();
            if (this.useShortNames) {
                int n2 = string.lastIndexOf(".");
                string = string.substring(n2 + 1);
            }
            System.out.print(string);
            if (this.printHashCode) {
                System.out.print(" 0x");
                System.out.print(Integer.toHexString(sceneGraphObject2.hashCode()));
            }
            if (this.printPickMask && sceneGraphObject2 instanceof PickableObject) {
                System.out.print(" 0x");
                System.out.print(Integer.toHexString(((PickableObject)((Object)sceneGraphObject2)).getPickMask()));
            }
            if (this.printChildCount && sceneGraphObject2 instanceof Group) {
                Group group = (Group)sceneGraphObject2;
                System.out.print(" childCount: " + group.numChildren());
            }
            if (this.printBounds && sceneGraphObject2 instanceof Node) {
                Node node = (Node)sceneGraphObject2;
                BoundingVolume boundingVolume = node.getBounds();
                if (boundingVolume instanceof BoundingVoid) {
                    System.out.print(" Bounds: VOID");
                } else {
                    System.out.print(" Bounds: " + boundingVolume);
                }
            }
            if (bl) {
                System.out.println(" (copy) ");
            } else {
                System.out.println();
            }
            if (this.printMatrix && sceneGraphObject2 instanceof TransformGroup) {
                this.printMatrix((TransformGroup)sceneGraphObject2, n);
            }
        }
    }

    public void dumpGraph(Group group) {
        this.sgt.traverseGraph(group);
    }

    public void enableBoundsPrinting(boolean bl) {
        this.printBounds = bl;
    }

    public boolean isBoundsPrintingEnabled() {
        return this.printBounds;
    }

    public void enableHashCodePrinting(boolean bl) {
        this.printHashCode = bl;
    }

    public boolean isHashCodePrintingEnabled() {
        return this.printHashCode;
    }

    public void enablePickMaskPrinting(boolean bl) {
        this.printPickMask = bl;
    }

    public boolean isPickMaskPrintingEnabled() {
        return this.printPickMask;
    }

    public void enableChildCountPrinting(boolean bl) {
        this.printChildCount = bl;
    }

    public boolean isChildCountPrintingEnabled() {
        return this.printChildCount;
    }

    public void enableDashPrinting(boolean bl) {
        this.printDashes = bl;
    }

    public boolean isDashPrintingEnabled() {
        return this.printDashes;
    }

    public void printShortNames(boolean bl) {
        this.useShortNames = bl;
    }

    public boolean isShortNamesEnabled() {
        return this.useShortNames;
    }

    public void enableTransformMatrixPrinting(boolean bl) {
        this.printMatrix = bl;
        if (bl) {
            this.matrix = new Matrix4f();
        }
    }

    public boolean isTransformMatrixPrintingEnabled() {
        return this.printMatrix;
    }

    private void printMatrix(TransformGroup transformGroup, int n) {
        transformGroup.getTransform(this.matrix);
        this.indent(n, false);
        System.out.print("| [");
        System.out.print(this.matrix.m00);
        System.out.print(' ');
        System.out.print(this.matrix.m01);
        System.out.print(' ');
        System.out.print(this.matrix.m02);
        System.out.print(' ');
        System.out.print(this.matrix.m03);
        System.out.println(" ]");
        this.indent(n, false);
        System.out.print("| [");
        System.out.print(this.matrix.m10);
        System.out.print(' ');
        System.out.print(this.matrix.m11);
        System.out.print(' ');
        System.out.print(this.matrix.m12);
        System.out.print(' ');
        System.out.print(this.matrix.m13);
        System.out.println(" ]");
        this.indent(n, false);
        System.out.print("| [");
        System.out.print(this.matrix.m20);
        System.out.print(' ');
        System.out.print(this.matrix.m21);
        System.out.print(' ');
        System.out.print(this.matrix.m22);
        System.out.print(' ');
        System.out.print(this.matrix.m23);
        System.out.println(" ]");
        this.indent(n, false);
        System.out.print("| [");
        System.out.print(this.matrix.m30);
        System.out.print(' ');
        System.out.print(this.matrix.m31);
        System.out.print(' ');
        System.out.print(this.matrix.m32);
        System.out.print(' ');
        System.out.print(this.matrix.m33);
        System.out.println(" ]");
    }

    private void indent(int n, boolean bl) {
        if (this.printDashes) {
            for (int i = 0; i < n; ++i) {
                System.out.print("|");
            }
            if (bl) {
                System.out.print("+");
            } else {
                System.out.print('|');
            }
        } else {
            for (int i = 0; i < n + 1; ++i) {
                System.out.print(' ');
            }
        }
    }
}

