/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.polhemus;

import org.j3d.device.input.polhemus.SerialPortDevice;

public abstract class Polhemus
extends SerialPortDevice {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final String toBinaryCommand = "f";
    public static final String toASCIICommand = "F";
    public static final String toContinuousCommand = "C";
    public static final String toNonContinuousCommand = "c";
    public static final String retrieveStatusCommand = "S";
    public static final String getRecordCommand = "P";
    public static final String systemResetCommand = "W";
    public static final String performBoresightCommand = "B1\r";
    public static final String activeStationStateCommand = "l\r";
    public static final int RECEIVER1 = 1;
    public static final int RECEIVER2 = 2;
    public static final int RECEIVER3 = 3;
    public static final int RECEIVER4 = 4;
    public float[][] mPositionData = new float[4][3];
    public float[][] mRotationData = new float[4][3];
    private int mWaitTime = 0;
    private int mUpdateFlag = 0;
    private int mnReciver = 0;

    public Polhemus(String string, int n) {
        super(string, n, 8, 1, 0);
        this.setDeviceDataWaitTimeFromBaudRate(n);
        this.initialize();
    }

    public Polhemus(int n, int n2) {
        super(n, n2, 8, 1, 0);
        this.setDeviceDataWaitTimeFromBaudRate(n2);
        this.initialize();
    }

    public abstract int readActiveReceivers();

    public abstract void setReceiverOutputFormat();

    public abstract int getDeviceDataLength();

    public abstract int getDevicePositionDataOffset();

    public abstract int getDeviceRotationDataOffset();

    public void setDeviceDataWaitTimeFromBaudRate(int n) {
        if (115200 <= n) {
            this.setDeviceDataWaitTime(10);
            return;
        }
        if (38400 <= n) {
            this.setDeviceDataWaitTime(20);
            return;
        }
        if (19200 <= n) {
            this.setDeviceDataWaitTime(50);
            return;
        }
        this.setDeviceDataWaitTime(100);
    }

    public void setDeviceDataWaitTime(int n) {
        this.mWaitTime = n;
    }

    public int getDeviceDataWaitTime() {
        return this.mWaitTime;
    }

    public void initialize() {
        int n = this.readActiveReceivers();
        this.setActiveReceivers(n);
        this.setReceiverOutputFormat();
        this.write(toASCIICommand);
        this.write(toNonContinuousCommand);
        for (int i = 0; i < 4; ++i) {
            this.initData(this.mPositionData[i]);
            this.initData(this.mRotationData[i]);
        }
        this.setReceiverUpdateFlag(0);
    }

    private void setActiveReceivers(int n) {
        this.mnReciver = n;
    }

    public int getActiveReceivers() {
        return this.mnReciver;
    }

    public void getPosition(int n, float[] fArray) {
        int n2 = 1 << n - 1 + 4;
        this.updateData(n2);
        this.copyData(this.mPositionData[n - 1], fArray);
    }

    public float[] getPosition(int n) {
        float[] fArray = new float[3];
        this.getPosition(n, fArray);
        return fArray;
    }

    public void getOrientation(int n, float[] fArray) {
        int n2 = 1 << n - 1;
        this.updateData(n2);
        this.copyData(this.mRotationData[n - 1], fArray);
    }

    public float[] getOrientation(int n) {
        float[] fArray = new float[3];
        this.getOrientation(n, fArray);
        return fArray;
    }

    private void readData() {
        int n = this.getDeviceDataWaitTime();
        int n2 = this.getDeviceDataLength();
        int n3 = this.getDevicePositionDataOffset();
        int n4 = this.getDeviceRotationDataOffset();
        for (int i = 0; i < this.getActiveReceivers(); ++i) {
            String string;
            int n5;
            this.write(getRecordCommand);
            this.waitTime(n);
            byte[] byArray = this.read(n2).getBytes();
            if (byArray.length != n2) continue;
            for (n5 = 0; n5 < 3; ++n5) {
                string = new String(byArray, n3 + 7 * n5, 7);
                this.mPositionData[i][n5] = Float.parseFloat(string);
            }
            for (n5 = 0; n5 < 3; ++n5) {
                string = new String(byArray, n4 + 7 * n5, 7);
                this.mRotationData[i][n5] = Float.parseFloat(string);
            }
        }
        this.setReceiverUpdateFlag(255);
    }

    private void setReceiverUpdateFlag(int n) {
        this.mUpdateFlag = n;
    }

    private int getReceiverUpdateFlag() {
        return this.mUpdateFlag;
    }

    private void initData(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 0.0f;
        }
    }

    private void copyData(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i];
        }
    }

    private void updateData(int n) {
        int n2 = this.getReceiverUpdateFlag();
        if ((n & n2) == 0) {
            this.readData();
        }
        int n3 = this.getReceiverUpdateFlag();
        this.setReceiverUpdateFlag(n3 &= ~n);
    }
}

