/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import org.j3d.device.input.spaceball.Spaceball4000CallbackInterface;
import org.j3d.device.input.spaceball.SpaceballPacket;

public class Spaceball4000Packet
extends SpaceballPacket {
    public static final int ECLIPSE_REGISTER_ERROR_CODE = 1;
    public static final int EEPROM_CHECKSUM_INCORRECT_ERROR_CODE = 2;
    public static final int ECLIPSE_TIMED_OUT_ERROR_CODE = 4;
    public static final int TRANSMIT_TIMEOUT_ERROR_CODE = 8;
    public static final int RECEIVE_QUEUE_OVERFLOW_ERROR_CODE = 16;
    public static final int RECEIVE_ERROR_ERROR_CODE = 32;
    public static final int PACKET_TOO_LONG_ERROR_CODE = 256;
    public static final int PACKET_IGNORED_ERROR_CODE = 512;
    public static final int COMMAND_UNRECOGNIZED_ERROR_CODE = 1024;
    public static final byte EMIT_SINGLE_BEEP = 83;
    public static final byte ENABLE_BALL_DATA = 77;
    public static final byte DISABLE_BALL_DATA = 45;
    public static final byte GET_DEVICE_DESCRIPTOR = 34;
    public static final byte GET_REZERO_BALL = 90;
    public static final byte ADVANCED_BUTTON_DATA = 46;
    public static final byte CUBIC_SENSITIVITY_ENABLE_DISABLE = 89;
    public static final byte ENABLE_DISABLE_AUTO_REZERO = 65;
    public static final byte CHANGE_AUTOMATIC_ZERO_PARAMETERS = 65;
    public static final byte AUTO_REZERO_RESPONSE = 97;
    public static final byte GET_DEVICE_INFORMATION = 104;
    public static final byte GET_DEVICE_INFORMATION_RESPONSE = 72;
    public static final int LEFT = 76;
    public static final int RIGHT = 82;
    public static final byte CUBIC_SENSITIVITY_ENABLED = 67;
    public static final byte STANDARD_SENSITIVITY_ENABLED = 83;
    private static final byte AUTO_REZERO_ENABLED = 69;
    private static final byte AUTO_REZERO_DISABLED = 68;
    private static final int DESCRIPTOR_DATA_PACKET_LENGTH = 34;
    private static final int[] ERROR_CODES = new int[]{1, 2, 4, 8, 16, 32, 256, 512, 1024};
    private static final String[] ERROR_CODE_STRINGS = new String[]{"Eclipse Register Error", "Eeprom checksum incorrect", "Eclipse timed Out", "Transmit timeout", "Receive queue overflow", "Receive error", "Packet too long", "Packet Ignored", "Command unrecognized"};
    private static final int[] ADVANCED_BUTTON_MASK = new int[]{1, 2, 4, 8, 16, 32, 128, 256, 512, 1024, 2048, 4096};
    private static final int LEFT_HANDEDNESS_DESCRIMINATOR = 8192;

    public static int createCubicSensitivityEnableDisablePacket(byte[] byArray, int n, boolean bl) {
        byArray[n] = 89;
        byArray[n + 1] = (byte)(bl ? 67 : 83);
        byArray[n + 2] = 13;
        return 3;
    }

    public static int createEnableDisableAutoRezeroPacket(byte[] byArray, int n, boolean bl) {
        byArray[n] = 65;
        byArray[n + 1] = (byte)(bl ? 69 : 68);
        byArray[n + 2] = 13;
        return 3;
    }

    public static int createChangeAutomaticZeroParametersPacket(byte[] byArray, int n, int n2, int n3) {
        int n4;
        for (int i = 1; i < 7; ++i) {
            byArray[n + i] = 48;
        }
        String string = Integer.toHexString(n2);
        int n5 = string.length();
        String string2 = Integer.toHexString(n3);
        int n6 = string2.length();
        byArray[n] = 65;
        for (n4 = 0; n4 < n5; ++n4) {
            byArray[n + 5 - n5 + n4] = (byte)string.charAt(n4);
        }
        for (n4 = 0; n4 < n6; ++n4) {
            byArray[n + 7 - n6 + n4] = (byte)string2.charAt(n4);
        }
        byArray[n + 7] = 13;
        return 8;
    }

    public static void decodeButtonEvent(int[] nArray, byte[] byArray, Spaceball4000CallbackInterface spaceball4000CallbackInterface, int n) {
        int n2 = Spaceball4000Packet.makeWord(byArray[n + 1], byArray[n + 2]);
        Spaceball4000Packet.decodeButtonData(n2, nArray, ADVANCED_BUTTON_MASK);
        int n3 = (n2 & 0x2000) == 0 ? 76 : 82;
        spaceball4000CallbackInterface.setHandedness(n3);
    }

    public static void doCallBacks(byte[] byArray, Spaceball4000CallbackInterface spaceball4000CallbackInterface, int n, int n2, int n3) {
        switch (n3) {
            case 45: 
            case 77: 
            case 83: 
            case 90: {
                spaceball4000CallbackInterface.processRequestResponse(n3);
                break;
            }
            case 97: {
                boolean bl = byArray[n + 6] == 69;
                String string = new String(byArray, n, n2 - 1);
                int n4 = Integer.parseInt(string.substring(0, 4), 16);
                int n5 = Integer.parseInt(string.substring(4, 6), 16);
                spaceball4000CallbackInterface.processAutoRezeroResponse(n4, n5, bl);
                break;
            }
            case 89: {
                spaceball4000CallbackInterface.processSensitivityResponse(byArray[n]);
                break;
            }
            case 34: {
                String string = new String(byArray, n, n2);
                int n6 = Integer.parseInt(string.substring(0, 1));
                if (n6 == 2 && n2 + 1 == 34) {
                    Spaceball4000Packet.decodeDeviceDescriptor(spaceball4000CallbackInterface, string);
                }
                spaceball4000CallbackInterface.processDeviceInfoResponse(n3, n6, string);
                break;
            }
            case 64: {
                String string = new String(byArray, n, n2);
                int n7 = Integer.parseInt(string.substring(0, 1));
                spaceball4000CallbackInterface.processDeviceInfoResponse(n3, n7, string);
                break;
            }
            case 72: {
                String string = new String(byArray, n, n2);
                spaceball4000CallbackInterface.processDeviceInfoResponse(n3, 1, string);
                break;
            }
            case 37: {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                spaceball4000CallbackInterface.processEchoResponse(byArray2);
                break;
            }
            case 69: {
                Spaceball4000Packet.decodeErrorPacket(spaceball4000CallbackInterface, Spaceball4000Packet.makeWord(byArray[n], byArray[n + 1]));
                break;
            }
            default: {
                spaceball4000CallbackInterface.processError(1024, "Spaceball (TM) 4000 device sent unknown packet.");
            }
        }
    }

    private static void decodeErrorPacket(Spaceball4000CallbackInterface spaceball4000CallbackInterface, int n) {
        for (int i = 0; i < ERROR_CODES.length; ++i) {
            if ((n & ERROR_CODES[i]) <= 0) continue;
            spaceball4000CallbackInterface.processError(ERROR_CODES[i], "Spaceball (TM) 4000: " + ERROR_CODE_STRINGS[i]);
        }
    }

    private static void decodeDeviceDescriptor(Spaceball4000CallbackInterface spaceball4000CallbackInterface, String string) {
        int n = Integer.parseInt(string.substring(4, 6));
        char c = string.charAt(7);
        boolean bl = string.charAt(18) == '1';
        byte by = (byte)string.charAt(24);
        int n2 = Integer.parseInt(string.substring(26, 30));
        int n3 = Integer.parseInt(string.substring(31, 33));
        spaceball4000CallbackInterface.setHandedness(c);
        spaceball4000CallbackInterface.setNumOfButtons(n);
        spaceball4000CallbackInterface.processAutoRezeroResponse(n2, n3, bl);
        spaceball4000CallbackInterface.processSensitivityResponse(by);
    }
}

