/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.util.Random;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.j3d.geom.SeidelMonotoneChain;
import org.j3d.geom.SeidelNode;
import org.j3d.geom.SeidelSegment;
import org.j3d.geom.SeidelTrapezoid;
import org.j3d.geom.SeidelVertexChain;

class SeidelTriangulator {
    private static final double LOG_2_BASE = 1.0 / Math.log(2.0);
    private static final float EPSILON = 1.0E-6f;
    private SeidelSegment[] segments;
    private SeidelNode[] queryList;
    private SeidelTrapezoid[] trapezoidList;
    private int lastQuery;
    private int lastTrapezoid;
    private int choiceIndex;
    private Random randomiser = new Random();
    private int[] permute;
    private SeidelMonotoneChain[] monotoneChain;
    private SeidelVertexChain[] vertexChain;
    private int lastMonotone;
    private int lastVertex;
    private int[] monotonePosition;
    private boolean[] visited;
    private int[] reflexChain;

    SeidelTriangulator() {
    }

    void triangulatePolygon(int n, int[] nArray, float[] fArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5 = 1;
        for (n4 = 0; n4 < n; ++n4) {
            n5 += nArray[n4];
        }
        if (this.segments == null || this.segments.length < n5) {
            n3 = n5 * 4;
            n2 = n5 * 8;
            SeidelSegment[] seidelSegmentArray = new SeidelSegment[n5];
            SeidelTrapezoid[] seidelTrapezoidArray = new SeidelTrapezoid[n3];
            SeidelNode[] seidelNodeArray = new SeidelNode[n2];
            SeidelVertexChain[] seidelVertexChainArray = new SeidelVertexChain[n5];
            SeidelMonotoneChain[] seidelMonotoneChainArray = new SeidelMonotoneChain[n3];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (this.segments != null) {
                n6 = this.segments.length;
                n7 = this.trapezoidList.length;
                n8 = this.queryList.length;
                n10 = this.monotoneChain.length;
                n9 = this.vertexChain.length;
                System.arraycopy(this.segments, 0, seidelSegmentArray, 0, n6);
                System.arraycopy(this.trapezoidList, 0, seidelTrapezoidArray, 0, n7);
                System.arraycopy(this.queryList, 0, seidelNodeArray, 0, n8);
                System.arraycopy(this.monotoneChain, 0, seidelMonotoneChainArray, 0, n10);
                System.arraycopy(this.vertexChain, 0, seidelVertexChainArray, 0, n9);
            }
            for (n4 = n6; n4 < n5; ++n4) {
                seidelSegmentArray[n4] = new SeidelSegment();
            }
            for (n4 = n7; n4 < n3; ++n4) {
                seidelTrapezoidArray[n4] = new SeidelTrapezoid();
            }
            for (n4 = n8; n4 < n2; ++n4) {
                seidelNodeArray[n4] = new SeidelNode();
            }
            for (n4 = n9; n4 < n5; ++n4) {
                seidelVertexChainArray[n4] = new SeidelVertexChain();
            }
            for (n4 = n10; n4 < n3; ++n4) {
                seidelMonotoneChainArray[n4] = new SeidelMonotoneChain();
            }
            for (n4 = 0; n4 < n6; ++n4) {
                seidelSegmentArray[n4].clear();
            }
            for (n4 = 0; n4 < n7; ++n4) {
                seidelTrapezoidArray[n4].clear();
            }
            for (n4 = 0; n4 < n8; ++n4) {
                seidelNodeArray[n4].clear();
            }
            for (n4 = 0; n4 < n10; ++n4) {
                seidelMonotoneChainArray[n4].clear();
            }
            for (n4 = 0; n4 < n9; ++n4) {
                seidelVertexChainArray[n4].clear();
            }
            this.segments = seidelSegmentArray;
            this.trapezoidList = seidelTrapezoidArray;
            this.queryList = seidelNodeArray;
            this.monotoneChain = seidelMonotoneChainArray;
            this.vertexChain = seidelVertexChainArray;
            this.permute = new int[n5];
            this.visited = new boolean[n3];
            this.monotonePosition = new int[n5];
        } else {
            for (n4 = 0; n4 < this.segments.length; ++n4) {
                this.segments[n4].clear();
            }
            for (n4 = 0; n4 < this.trapezoidList.length; ++n4) {
                this.trapezoidList[n4].clear();
            }
            for (n4 = 0; n4 < this.queryList.length; ++n4) {
                this.queryList[n4].clear();
            }
        }
        n4 = 1;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            int n11 = n4;
            int n12 = n11 + n2 - 1;
            int n13 = 0;
            while (n13 < n2) {
                this.segments[n4].v0.x = fArray[n4 * 2];
                this.segments[n4].v0.y = fArray[n4 * 2 + 1];
                if (n4 == n12) {
                    this.segments[n4].next = n11;
                    this.segments[n4].prev = n4 - 1;
                    this.segments[n4 - 1].v1.set((Tuple2f)this.segments[n4].v0);
                } else if (n4 == n11) {
                    this.segments[n4].next = n4 + 1;
                    this.segments[n4].prev = n12;
                    this.segments[n12].v1.set((Tuple2f)this.segments[n4].v0);
                } else {
                    this.segments[n4].prev = n4 - 1;
                    this.segments[n4].next = n4 + 1;
                    this.segments[n4 - 1].v1.set((Tuple2f)this.segments[n4].v0);
                }
                this.segments[n4].isInserted = false;
                ++n13;
                ++n4;
            }
        }
        System.out.println("init");
        this.initialise(n4 - 1);
        System.out.println("construct traps");
        this.constructTrapezoids(n4 - 1);
        System.out.println("monotonate traps");
        n3 = this.monotonateTrapezoids(n4 - 1);
        System.out.println("triangulate");
        this.triangulateMonotonePolygons(n4 - 1, n3, nArray2);
    }

    private void initialise(int n) {
        int n2;
        for (int i = 1; i <= n; ++i) {
            this.segments[i].isInserted = false;
        }
        int[] nArray = new int[n + 1];
        this.choiceIndex = 1;
        this.randomiser.setSeed(System.currentTimeMillis());
        for (n2 = 0; n2 <= n; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 1; n2 <= n; ++n2) {
            int n3 = this.randomiser.nextInt(32768) % (n + 1 - n2) + 1;
            this.permute[n2] = nArray[n2 - 1 + n3];
            if (n3 == 1) continue;
            nArray[n2 - 1 + n3] = nArray[n2];
        }
    }

    private void constructTrapezoids(int n) {
        int n2;
        int n3;
        int n4 = this.initQueryStructure(this.chooseSegment());
        System.out.println("1 nseg " + n);
        for (n3 = 1; n3 <= n; ++n3) {
            this.segments[n3].root0 = this.segments[n3].root1 = n4;
        }
        System.out.println(2);
        n3 = this.logStarN(n);
        System.out.println("3 logStar " + n3);
        for (n2 = 1; n2 <= n3; ++n2) {
            int n5;
            System.out.println("a " + n2);
            for (n5 = this.nRatio(n, n2 - 1) + 1; n5 <= this.nRatio(n, n2); ++n5) {
                System.out.println("a1 " + n5);
                this.addSegment(this.chooseSegment());
            }
            System.out.println("b " + n2);
            for (n5 = 1; n5 <= n; ++n5) {
                this.findNewRoots(n5);
            }
        }
        System.out.println(4);
        for (n2 = this.nRatio(n, n3) + 1; n2 <= n; ++n2) {
            this.addSegment(this.chooseSegment());
        }
        System.out.println(5);
    }

    private int monotonateTrapezoids(int n) {
        int n2;
        for (n2 = 0; n2 < this.vertexChain.length; ++n2) {
            this.vertexChain[n2].clear();
        }
        for (n2 = 0; n2 < this.visited.length; ++n2) {
            this.visited[n2] = false;
        }
        for (n2 = 0; n2 < this.monotoneChain.length; ++n2) {
            this.monotoneChain[n2].clear();
        }
        for (n2 = 0; n2 < this.monotonePosition.length; ++n2) {
            this.monotonePosition[n2] = 0;
        }
        for (n2 = 0; n2 < this.trapezoidList.length && !this.insidePolygon(this.trapezoidList[n2]); ++n2) {
        }
        int n3 = n2;
        for (n2 = 1; n2 <= n; ++n2) {
            this.monotoneChain[n2].prev = this.segments[n2].prev;
            this.monotoneChain[n2].next = this.segments[n2].next;
            this.monotoneChain[n2].vnum = n2;
            this.vertexChain[n2].point = this.segments[n2].v0;
            this.vertexChain[n2].nextVertex[0] = this.segments[n2].next;
            this.vertexChain[n2].vertexPosition[0] = n2;
            this.vertexChain[n2].nextFree = 1;
        }
        this.lastVertex = n;
        this.lastMonotone = 0;
        this.monotonePosition[0] = 1;
        if (this.trapezoidList[n3].u0 > 0) {
            this.traversePolygon(0, n3, this.trapezoidList[n3].u0, true);
        } else if (this.trapezoidList[n3].d0 > 0) {
            this.traversePolygon(0, n3, this.trapezoidList[n3].d0, false);
        }
        return this.newMonotone();
    }

    private int initQueryStructure(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        SeidelSegment seidelSegment = this.segments[n];
        this.lastQuery = 1;
        this.lastTrapezoid = 1;
        for (n8 = 0; n8 < this.trapezoidList.length; ++n8) {
            this.trapezoidList[n8].clear();
        }
        for (n8 = 0; n8 < this.queryList.length; ++n8) {
            this.queryList[n8].clear();
        }
        n8 = this.newNode();
        this.queryList[n8].nodeType = 2;
        this.max(this.queryList[n8].yVal, seidelSegment.v0, seidelSegment.v1);
        int n9 = n8;
        this.queryList[n8].rightChild = n7 = this.newNode();
        this.queryList[n7].nodeType = 3;
        this.queryList[n7].parent = n8;
        this.queryList[n8].leftChild = n6 = this.newNode();
        this.queryList[n6].nodeType = 2;
        this.min(this.queryList[n6].yVal, seidelSegment.v0, seidelSegment.v1);
        this.queryList[n6].parent = n8;
        this.queryList[n6].leftChild = n5 = this.newNode();
        this.queryList[n5].nodeType = 3;
        this.queryList[n5].parent = n6;
        this.queryList[n6].rightChild = n4 = this.newNode();
        this.queryList[n4].nodeType = 1;
        this.queryList[n4].segmentIndex = n;
        this.queryList[n4].parent = n6;
        this.queryList[n4].leftChild = n3 = this.newNode();
        this.queryList[n3].nodeType = 3;
        this.queryList[n3].parent = n4;
        this.queryList[n4].rightChild = n2 = this.newNode();
        this.queryList[n2].nodeType = 3;
        this.queryList[n2].parent = n4;
        int n10 = this.newTrapezoid();
        int n11 = this.newTrapezoid();
        int n12 = this.newTrapezoid();
        int n13 = this.newTrapezoid();
        this.trapezoidList[n10].hi = this.queryList[n8].yVal;
        this.trapezoidList[n11].hi = this.queryList[n8].yVal;
        this.trapezoidList[n13].lo = this.queryList[n8].yVal;
        this.trapezoidList[n10].lo = this.queryList[n6].yVal;
        this.trapezoidList[n11].lo = this.queryList[n6].yVal;
        this.trapezoidList[n12].hi = this.queryList[n6].yVal;
        this.trapezoidList[n13].hi.y = Float.POSITIVE_INFINITY;
        this.trapezoidList[n13].hi.x = Float.POSITIVE_INFINITY;
        this.trapezoidList[n12].lo.y = Float.NEGATIVE_INFINITY;
        this.trapezoidList[n12].lo.x = Float.NEGATIVE_INFINITY;
        this.trapezoidList[n10].rightSegment = n;
        this.trapezoidList[n11].leftSegment = n;
        this.trapezoidList[n10].u0 = this.trapezoidList[n11].u0 = n13;
        this.trapezoidList[n10].d0 = this.trapezoidList[n11].d0 = n12;
        this.trapezoidList[n13].d0 = this.trapezoidList[n12].u0 = n10;
        this.trapezoidList[n13].d1 = this.trapezoidList[n12].u1 = n11;
        this.trapezoidList[n10].sink = n3;
        this.trapezoidList[n11].sink = n2;
        this.trapezoidList[n12].sink = n5;
        this.trapezoidList[n13].sink = n7;
        this.trapezoidList[n10].valid = true;
        this.trapezoidList[n11].valid = true;
        this.trapezoidList[n12].valid = true;
        this.trapezoidList[n13].valid = true;
        this.queryList[n7].trapezoidIndex = n13;
        this.queryList[n5].trapezoidIndex = n12;
        this.queryList[n3].trapezoidIndex = n10;
        this.queryList[n2].trapezoidIndex = n11;
        seidelSegment.isInserted = true;
        return n9;
    }

    private void addSegment(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        SeidelSegment seidelSegment = this.segments[n];
        SeidelSegment seidelSegment2 = this.segments[n];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.greaterThan(seidelSegment.v1, seidelSegment.v0)) {
            Point2f point2f = seidelSegment.v0;
            seidelSegment.v0 = seidelSegment.v1;
            seidelSegment.v1 = point2f;
            n8 = seidelSegment.root0;
            seidelSegment.root0 = seidelSegment.root1;
            seidelSegment.root1 = n8;
            bl2 = true;
        }
        if (bl2 ? !this.inserted(n, false) : !this.inserted(n, true)) {
            n8 = this.locateEndpoint(seidelSegment.v0, seidelSegment.v1, seidelSegment.root0);
            n7 = this.newTrapezoid();
            this.trapezoidList[n7].valid = true;
            this.trapezoidList[n7] = this.trapezoidList[n8];
            this.trapezoidList[n8].lo.y = this.trapezoidList[n7].hi.y = seidelSegment.v0.y;
            this.trapezoidList[n8].lo.x = this.trapezoidList[n7].hi.x = seidelSegment.v0.x;
            this.trapezoidList[n8].d0 = n7;
            this.trapezoidList[n8].d1 = 0;
            this.trapezoidList[n7].u0 = n8;
            this.trapezoidList[n7].u1 = 0;
            int n13 = this.trapezoidList[n7].d0;
            if (n13 > 0 && this.trapezoidList[n13].u0 == n8) {
                this.trapezoidList[n13].u0 = n7;
            }
            if ((n13 = this.trapezoidList[n7].d0) > 0 && this.trapezoidList[n13].u1 == n8) {
                this.trapezoidList[n13].u1 = n7;
            }
            if ((n13 = this.trapezoidList[n7].d1) > 0 && this.trapezoidList[n13].u0 == n8) {
                this.trapezoidList[n13].u0 = n7;
            }
            if ((n13 = this.trapezoidList[n7].d1) > 0 && this.trapezoidList[n13].u1 == n8) {
                this.trapezoidList[n13].u1 = n7;
            }
            n6 = this.newNode();
            n5 = this.newNode();
            n4 = this.trapezoidList[n8].sink;
            this.queryList[n4].nodeType = 2;
            this.queryList[n4].yVal = seidelSegment.v0;
            this.queryList[n4].segmentIndex = n;
            this.queryList[n4].leftChild = n5;
            this.queryList[n4].rightChild = n6;
            this.queryList[n6].nodeType = 3;
            this.queryList[n6].trapezoidIndex = n8;
            this.queryList[n6].parent = n4;
            this.queryList[n5].nodeType = 3;
            this.queryList[n5].trapezoidIndex = n7;
            this.queryList[n5].parent = n4;
            this.trapezoidList[n8].sink = n6;
            this.trapezoidList[n7].sink = n5;
            n3 = n7;
        } else {
            n3 = this.locateEndpoint(seidelSegment.v0, seidelSegment.v1, seidelSegment.root0);
        }
        if (bl2 ? !this.inserted(n, true) : !this.inserted(n, false)) {
            n8 = this.locateEndpoint(seidelSegment.v1, seidelSegment.v0, seidelSegment.root1);
            n7 = this.newTrapezoid();
            this.trapezoidList[n7].valid = true;
            this.trapezoidList[n7] = this.trapezoidList[n8];
            this.trapezoidList[n8].lo.y = this.trapezoidList[n7].hi.y = seidelSegment.v1.y;
            this.trapezoidList[n8].lo.x = this.trapezoidList[n7].hi.x = seidelSegment.v1.x;
            this.trapezoidList[n8].d0 = n7;
            this.trapezoidList[n8].d1 = 0;
            this.trapezoidList[n7].u0 = n8;
            this.trapezoidList[n7].u1 = 0;
            int n14 = this.trapezoidList[n7].d0;
            if (n14 > 0 && this.trapezoidList[n14].u0 == n8) {
                this.trapezoidList[n14].u0 = n7;
            }
            if ((n14 = this.trapezoidList[n7].d0) > 0 && this.trapezoidList[n14].u1 == n8) {
                this.trapezoidList[n14].u1 = n7;
            }
            if ((n14 = this.trapezoidList[n7].d1) > 0 && this.trapezoidList[n14].u0 == n8) {
                this.trapezoidList[n14].u0 = n7;
            }
            if ((n14 = this.trapezoidList[n7].d1) > 0 && this.trapezoidList[n14].u1 == n8) {
                this.trapezoidList[n14].u1 = n7;
            }
            n6 = this.newNode();
            n5 = this.newNode();
            n4 = this.trapezoidList[n8].sink;
            this.queryList[n4].nodeType = 2;
            this.queryList[n4].yVal = seidelSegment.v1;
            this.queryList[n4].segmentIndex = n;
            this.queryList[n4].leftChild = n5;
            this.queryList[n4].rightChild = n6;
            this.queryList[n6].nodeType = 3;
            this.queryList[n6].trapezoidIndex = n8;
            this.queryList[n6].parent = n4;
            this.queryList[n5].nodeType = 3;
            this.queryList[n5].trapezoidIndex = n7;
            this.queryList[n5].parent = n4;
            this.trapezoidList[n8].sink = n6;
            this.trapezoidList[n7].sink = n5;
            n2 = n8;
        } else {
            n2 = this.locateEndpoint(seidelSegment.v1, seidelSegment.v0, seidelSegment.root1);
            bl = true;
        }
        System.out.println("addSeg " + n3);
        int n15 = n3;
        while (n15 > 0 && this.greaterThanOrEqualTo(this.trapezoidList[n15].lo, this.trapezoidList[n2].lo)) {
            int n16;
            int n17;
            int n18 = this.trapezoidList[n15].sink;
            n8 = this.newNode();
            n7 = this.newNode();
            this.queryList[n18].nodeType = 1;
            this.queryList[n18].segmentIndex = n;
            this.queryList[n18].leftChild = n8;
            this.queryList[n18].rightChild = n7;
            this.queryList[n8].nodeType = 3;
            this.queryList[n8].trapezoidIndex = n15;
            this.queryList[n8].parent = n18;
            int n19 = this.newTrapezoid();
            this.queryList[n7].nodeType = 3;
            this.queryList[n7].trapezoidIndex = n19;
            this.trapezoidList[n19].valid = true;
            this.queryList[n7].parent = n18;
            if (n15 == n3) {
                n9 = n19;
            }
            if (this.trapezoidList[n15].lo.epsilonEquals((Tuple2f)this.trapezoidList[n2].lo, 1.0E-6f)) {
                n10 = n19;
            }
            this.trapezoidList[n19] = this.trapezoidList[n15];
            this.trapezoidList[n15].sink = n8;
            this.trapezoidList[n19].sink = n7;
            n6 = n15;
            n5 = n19;
            if (this.trapezoidList[n15].d0 <= 0 && this.trapezoidList[n15].d1 <= 0) {
                System.err.println("add_segment: error\n");
                break;
            }
            if (this.trapezoidList[n15].d0 > 0 && this.trapezoidList[n15].d1 <= 0) {
                if (this.trapezoidList[n15].u0 > 0 && this.trapezoidList[n15].u1 > 0) {
                    if (this.trapezoidList[n15].usave > 0) {
                        if (this.trapezoidList[n15].mergeSideLeft) {
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                            this.trapezoidList[this.trapezoidList[n19].u1].d0 = n19;
                        } else {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = this.trapezoidList[n15].u0;
                            this.trapezoidList[n15].u0 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n15].u1].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                        }
                        this.trapezoidList[n19].usave = 0;
                        this.trapezoidList[n15].usave = 0;
                    } else {
                        this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                        this.trapezoidList[n19].u1 = -1;
                        this.trapezoidList[n15].u1 = -1;
                        this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                    }
                } else {
                    n4 = this.trapezoidList[n15].u0;
                    n17 = this.trapezoidList[n4].d0;
                    if (n17 > 0 && (n16 = this.trapezoidList[n4].d1) > 0) {
                        if (this.trapezoidList[n17].rightSegment > 0 && !this.isLeftOf(this.trapezoidList[n17].rightSegment, seidelSegment.v1)) {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n15].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n19].u0].d1 = n19;
                        } else {
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        }
                    } else {
                        this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        this.trapezoidList[this.trapezoidList[n15].u0].d1 = n19;
                    }
                }
                if (this.equalsEpsilon(this.trapezoidList[n15].lo.y, this.trapezoidList[n2].lo.y) && this.equalsEpsilon(this.trapezoidList[n15].lo.x, this.trapezoidList[n2].lo.x) && bl) {
                    int n20 = n4 = bl2 ? this.segments[n].prev : this.segments[n].next;
                    if (n4 > 0 && this.isLeftOf(n4, seidelSegment.v0)) {
                        this.trapezoidList[this.trapezoidList[n15].d0].u0 = n15;
                        this.trapezoidList[n19].d1 = -1;
                        this.trapezoidList[n19].d0 = -1;
                    } else {
                        this.trapezoidList[this.trapezoidList[n19].d0].u1 = n19;
                        this.trapezoidList[n15].d1 = -1;
                        this.trapezoidList[n15].d0 = -1;
                    }
                } else {
                    if (this.trapezoidList[this.trapezoidList[n15].d0].u0 > 0 && this.trapezoidList[this.trapezoidList[n15].d0].u1 > 0) {
                        if (this.trapezoidList[this.trapezoidList[n15].d0].u0 == n15) {
                            this.trapezoidList[this.trapezoidList[n15].d0].usave = this.trapezoidList[this.trapezoidList[n15].d0].u1;
                            this.trapezoidList[this.trapezoidList[n15].d0].mergeSideLeft = true;
                        } else {
                            this.trapezoidList[this.trapezoidList[n15].d0].usave = this.trapezoidList[this.trapezoidList[n15].d0].u0;
                            this.trapezoidList[this.trapezoidList[n15].d0].mergeSideLeft = false;
                        }
                    }
                    this.trapezoidList[this.trapezoidList[n15].d0].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d0].u1 = n19;
                }
                n15 = this.trapezoidList[n15].d0;
            } else if (this.trapezoidList[n15].d0 <= 0 && this.trapezoidList[n15].d1 > 0) {
                if (this.trapezoidList[n15].u0 > 0 && this.trapezoidList[n15].u1 > 0) {
                    if (this.trapezoidList[n15].usave > 0) {
                        if (this.trapezoidList[n15].mergeSideLeft) {
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                            this.trapezoidList[this.trapezoidList[n19].u1].d0 = n19;
                        } else {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = this.trapezoidList[n15].u0;
                            this.trapezoidList[n15].u0 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n15].u1].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                        }
                        this.trapezoidList[n19].usave = 0;
                        this.trapezoidList[n15].usave = 0;
                    } else {
                        this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                        this.trapezoidList[n19].u1 = -1;
                        this.trapezoidList[n15].u1 = -1;
                        this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                    }
                } else {
                    n4 = this.trapezoidList[n15].u0;
                    n17 = this.trapezoidList[n4].d0;
                    if (n17 > 0 && (n16 = this.trapezoidList[n4].d1) > 0) {
                        if (this.trapezoidList[n17].rightSegment > 0 && !this.isLeftOf(this.trapezoidList[n17].rightSegment, seidelSegment.v1)) {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n15].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n19].u0].d1 = n19;
                        } else {
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        }
                    } else {
                        this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        this.trapezoidList[this.trapezoidList[n15].u0].d1 = n19;
                    }
                }
                if (this.equalsEpsilon(this.trapezoidList[n15].lo.y, this.trapezoidList[n2].lo.y) && this.equalsEpsilon(this.trapezoidList[n15].lo.x, this.trapezoidList[n2].lo.x) && bl) {
                    int n21 = n4 = bl2 ? this.segments[n].prev : this.segments[n].next;
                    if (n4 > 0 && this.isLeftOf(n4, seidelSegment.v0)) {
                        this.trapezoidList[this.trapezoidList[n15].d1].u0 = n15;
                        this.trapezoidList[n19].d1 = -1;
                        this.trapezoidList[n19].d0 = -1;
                    } else {
                        this.trapezoidList[this.trapezoidList[n19].d1].u1 = n19;
                        this.trapezoidList[n15].d1 = -1;
                        this.trapezoidList[n15].d0 = -1;
                    }
                } else {
                    if (this.trapezoidList[this.trapezoidList[n15].d1].u0 > 0 && this.trapezoidList[this.trapezoidList[n15].d1].u1 > 0) {
                        if (this.trapezoidList[this.trapezoidList[n15].d1].u0 == n15) {
                            this.trapezoidList[this.trapezoidList[n15].d1].usave = this.trapezoidList[this.trapezoidList[n15].d1].u1;
                            this.trapezoidList[this.trapezoidList[n15].d1].mergeSideLeft = true;
                        } else {
                            this.trapezoidList[this.trapezoidList[n15].d1].usave = this.trapezoidList[this.trapezoidList[n15].d1].u0;
                            this.trapezoidList[this.trapezoidList[n15].d1].mergeSideLeft = false;
                        }
                    }
                    this.trapezoidList[this.trapezoidList[n15].d1].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d1].u1 = n19;
                }
                n15 = this.trapezoidList[n15].d1;
            } else {
                int n22;
                n4 = this.trapezoidList[this.trapezoidList[n15].d0].rightSegment;
                n17 = 0;
                n16 = 0;
                if (this.equalsEpsilon(this.trapezoidList[n15].lo.y, seidelSegment.v0.y)) {
                    if (this.trapezoidList[n15].lo.x > seidelSegment.v0.x) {
                        n17 = 1;
                    } else {
                        n16 = 1;
                    }
                } else {
                    Point2f point2f = new Point2f();
                    point2f.y = this.trapezoidList[n15].lo.y;
                    float f = this.trapezoidList[n15].lo.y;
                    float f2 = (f - seidelSegment.v0.y) / (seidelSegment.v1.y - seidelSegment.v0.y);
                    point2f.x = seidelSegment.v0.x + f2 * (seidelSegment.v1.x - seidelSegment.v0.x);
                    if (this.lessThan(point2f, this.trapezoidList[n15].lo)) {
                        n17 = 1;
                    } else {
                        n16 = 1;
                    }
                }
                if (this.trapezoidList[n15].u0 > 0 && this.trapezoidList[n15].u1 > 0) {
                    if (this.trapezoidList[n15].usave > 0) {
                        if (this.trapezoidList[n15].mergeSideLeft) {
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                            this.trapezoidList[this.trapezoidList[n19].u1].d0 = n19;
                        } else {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                            this.trapezoidList[n15].u1 = this.trapezoidList[n15].u0;
                            this.trapezoidList[n15].u0 = this.trapezoidList[n15].usave;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n15].u1].d0 = n15;
                            this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                        }
                        this.trapezoidList[n19].usave = 0;
                        this.trapezoidList[n15].usave = 0;
                    } else {
                        this.trapezoidList[n19].u0 = this.trapezoidList[n15].u1;
                        this.trapezoidList[n19].u1 = -1;
                        this.trapezoidList[n15].u1 = -1;
                        this.trapezoidList[this.trapezoidList[n19].u0].d0 = n19;
                    }
                } else {
                    int n23;
                    int n24 = this.trapezoidList[n15].u0;
                    int n25 = this.trapezoidList[n24].d0;
                    if (n25 > 0 && (n23 = this.trapezoidList[n24].d1) > 0) {
                        if (this.trapezoidList[n25].rightSegment > 0 && !this.isLeftOf(this.trapezoidList[n25].rightSegment, seidelSegment.v1)) {
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n15].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n19].u0].d1 = n19;
                        } else {
                            this.trapezoidList[n15].u1 = -1;
                            this.trapezoidList[n19].u1 = -1;
                            this.trapezoidList[n19].u0 = -1;
                            this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        }
                    } else {
                        this.trapezoidList[this.trapezoidList[n15].u0].d0 = n15;
                        this.trapezoidList[this.trapezoidList[n15].u0].d1 = n19;
                    }
                }
                if (this.equalsEpsilon(this.trapezoidList[n15].lo.y, this.trapezoidList[n2].lo.y) && this.equalsEpsilon(this.trapezoidList[n15].lo.x, this.trapezoidList[n2].lo.x) && bl) {
                    this.trapezoidList[this.trapezoidList[n15].d0].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d0].u1 = -1;
                    this.trapezoidList[this.trapezoidList[n15].d1].u0 = n19;
                    this.trapezoidList[this.trapezoidList[n15].d1].u1 = -1;
                    this.trapezoidList[n19].d0 = this.trapezoidList[n15].d1;
                    this.trapezoidList[n19].d1 = -1;
                    n22 = this.trapezoidList[n15].d1 = -1;
                } else if (n17 != 0) {
                    this.trapezoidList[this.trapezoidList[n15].d0].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d0].u1 = n19;
                    this.trapezoidList[this.trapezoidList[n15].d1].u0 = n19;
                    this.trapezoidList[this.trapezoidList[n15].d1].u1 = -1;
                    this.trapezoidList[n15].d1 = -1;
                    n22 = this.trapezoidList[n15].d0;
                } else {
                    this.trapezoidList[this.trapezoidList[n15].d0].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d0].u1 = -1;
                    this.trapezoidList[this.trapezoidList[n15].d1].u0 = n15;
                    this.trapezoidList[this.trapezoidList[n15].d1].u1 = n19;
                    this.trapezoidList[n19].d0 = this.trapezoidList[n15].d1;
                    this.trapezoidList[n19].d1 = -1;
                    n22 = this.trapezoidList[n15].d1;
                }
                n15 = n22;
            }
            this.trapezoidList[n6].rightSegment = this.trapezoidList[n5].leftSegment = n;
        }
        n11 = n3;
        n12 = n2;
        this.mergeTrapezoids(n, n11, n12, true);
        this.mergeTrapezoids(n, n9, n10, false);
        this.segments[n].isInserted = true;
    }

    private void mergeTrapezoids(int n, int n2, int n3, boolean bl) {
        int n4 = n2;
        while (n4 > 0 && this.greaterThanOrEqualTo(this.trapezoidList[n4].lo, this.trapezoidList[n3].lo)) {
            boolean bl2;
            int n5;
            if (bl) {
                n5 = this.trapezoidList[n4].d0;
                bl2 = n5 > 0 && this.trapezoidList[n5].rightSegment == n || (n5 = this.trapezoidList[n4].d1) > 0 && this.trapezoidList[n5].rightSegment == n;
            } else {
                n5 = this.trapezoidList[n4].d0;
                boolean bl3 = bl2 = n5 > 0 && this.trapezoidList[n5].leftSegment == n || (n5 = this.trapezoidList[n4].d1) > 0 && this.trapezoidList[n5].leftSegment == n;
            }
            if (bl2) {
                if (this.trapezoidList[n4].leftSegment == this.trapezoidList[n5].leftSegment && this.trapezoidList[n4].rightSegment == this.trapezoidList[n5].rightSegment) {
                    int n6 = this.queryList[this.trapezoidList[n5].sink].parent;
                    if (this.queryList[n6].leftChild == this.trapezoidList[n5].sink) {
                        this.queryList[n6].leftChild = this.trapezoidList[n4].sink;
                    } else {
                        this.queryList[n6].rightChild = this.trapezoidList[n4].sink;
                    }
                    this.trapezoidList[n4].d0 = this.trapezoidList[n5].d0;
                    if (this.trapezoidList[n4].d0 > 0) {
                        if (this.trapezoidList[this.trapezoidList[n4].d0].u0 == n5) {
                            this.trapezoidList[this.trapezoidList[n4].d0].u0 = n4;
                        } else if (this.trapezoidList[this.trapezoidList[n4].d0].u1 == n5) {
                            this.trapezoidList[this.trapezoidList[n4].d0].u1 = n4;
                        }
                    }
                    if ((this.trapezoidList[n4].d1 = this.trapezoidList[n5].d1) > 0) {
                        if (this.trapezoidList[this.trapezoidList[n4].d1].u0 == n5) {
                            this.trapezoidList[this.trapezoidList[n4].d1].u0 = n4;
                        } else if (this.trapezoidList[this.trapezoidList[n4].d1].u1 == n5) {
                            this.trapezoidList[this.trapezoidList[n4].d1].u1 = n4;
                        }
                    }
                    this.trapezoidList[n4].lo = this.trapezoidList[n5].lo;
                    this.trapezoidList[n5].valid = false;
                    continue;
                }
                n4 = n5;
                continue;
            }
            n4 = n5;
        }
    }

    private void findNewRoots(int n) {
        SeidelSegment seidelSegment = this.segments[n];
        if (seidelSegment.isInserted) {
            return;
        }
        seidelSegment.root0 = this.locateEndpoint(seidelSegment.v0, seidelSegment.v1, seidelSegment.root0);
        seidelSegment.root0 = this.trapezoidList[seidelSegment.root0].sink;
        seidelSegment.root1 = this.locateEndpoint(seidelSegment.v1, seidelSegment.v0, seidelSegment.root1);
        seidelSegment.root1 = this.trapezoidList[seidelSegment.root1].sink;
    }

    private int locateEndpoint(Point2f point2f, Point2f point2f2, int n) {
        SeidelNode seidelNode = this.queryList[n];
        int n2 = 0;
        switch (seidelNode.nodeType) {
            case 3: {
                n2 = seidelNode.trapezoidIndex;
                break;
            }
            case 2: {
                if (this.greaterThan(point2f, seidelNode.yVal)) {
                    n2 = this.locateEndpoint(point2f, point2f2, seidelNode.rightChild);
                    break;
                }
                if (point2f.epsilonEquals((Tuple2f)seidelNode.yVal, 1.0E-6f)) {
                    if (this.greaterThan(point2f2, seidelNode.yVal)) {
                        n2 = this.locateEndpoint(point2f, point2f2, seidelNode.rightChild);
                        break;
                    }
                    n2 = this.locateEndpoint(point2f, point2f2, seidelNode.leftChild);
                    break;
                }
                n2 = this.locateEndpoint(point2f, point2f2, seidelNode.leftChild);
                break;
            }
            case 1: {
                if (point2f.epsilonEquals((Tuple2f)this.segments[seidelNode.segmentIndex].v0, 1.0E-6f) || point2f.epsilonEquals((Tuple2f)this.segments[seidelNode.segmentIndex].v1, 1.0E-6f)) {
                    if (this.equalsEpsilon(point2f.y, point2f2.y)) {
                        if (point2f2.x < point2f.x) {
                            n2 = this.locateEndpoint(point2f, point2f2, seidelNode.leftChild);
                            break;
                        }
                        n2 = this.locateEndpoint(point2f, point2f2, seidelNode.rightChild);
                        break;
                    }
                    if (this.isLeftOf(seidelNode.segmentIndex, point2f2)) {
                        n2 = this.locateEndpoint(point2f, point2f2, seidelNode.leftChild);
                        break;
                    }
                    n2 = this.locateEndpoint(point2f, point2f2, seidelNode.rightChild);
                    break;
                }
                n2 = this.isLeftOf(seidelNode.segmentIndex, point2f) ? this.locateEndpoint(point2f, point2f2, seidelNode.leftChild) : this.locateEndpoint(point2f, point2f2, seidelNode.rightChild);
            }
        }
        return n2;
    }

    private void traversePolygon(int n, int n2, int n3, boolean bl) {
        SeidelTrapezoid seidelTrapezoid = this.trapezoidList[n2];
        if (n2 <= 0 || this.visited[n2]) {
            return;
        }
        this.visited[n2] = true;
        if (seidelTrapezoid.u0 <= 0 && seidelTrapezoid.u1 <= 0) {
            if (seidelTrapezoid.d0 > 0 && seidelTrapezoid.d1 > 0) {
                int n4 = this.trapezoidList[seidelTrapezoid.d1].leftSegment;
                int n5 = seidelTrapezoid.leftSegment;
                if (n3 == seidelTrapezoid.d1) {
                    int n6 = this.makeNewMonotonePoly(n, n5, n4);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n6, seidelTrapezoid.d0, n2, true);
                } else {
                    int n7 = this.makeNewMonotonePoly(n, n4, n5);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n7, seidelTrapezoid.d1, n2, true);
                }
            } else {
                this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
            }
        } else if (seidelTrapezoid.d0 <= 0 && seidelTrapezoid.d1 <= 0) {
            if (seidelTrapezoid.u0 > 0 && seidelTrapezoid.u1 > 0) {
                int n8 = seidelTrapezoid.rightSegment;
                int n9 = this.trapezoidList[seidelTrapezoid.u0].rightSegment;
                if (n3 == seidelTrapezoid.u1) {
                    int n10 = this.makeNewMonotonePoly(n, n9, n8);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n10, seidelTrapezoid.u0, n2, false);
                } else {
                    int n11 = this.makeNewMonotonePoly(n, n8, n9);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n11, seidelTrapezoid.u1, n2, false);
                }
            } else {
                this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
            }
        } else if (seidelTrapezoid.u0 > 0 && seidelTrapezoid.u1 > 0) {
            if (seidelTrapezoid.d0 > 0 && seidelTrapezoid.d1 > 0) {
                int n12 = this.trapezoidList[seidelTrapezoid.d1].leftSegment;
                int n13 = this.trapezoidList[seidelTrapezoid.u0].rightSegment;
                if (!bl && seidelTrapezoid.d1 == n3 || bl && seidelTrapezoid.u1 == n3) {
                    int n14 = this.makeNewMonotonePoly(n, n13, n12);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n14, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n14, seidelTrapezoid.d0, n2, true);
                } else {
                    int n15 = this.makeNewMonotonePoly(n, n12, n13);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n15, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n15, seidelTrapezoid.d1, n2, true);
                }
            } else if (seidelTrapezoid.lo.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.leftSegment].v1, 1.0E-6f)) {
                int n16 = this.trapezoidList[seidelTrapezoid.u0].rightSegment;
                int n17 = this.segments[seidelTrapezoid.leftSegment].next;
                if (bl && seidelTrapezoid.u0 == n3) {
                    int n18 = this.makeNewMonotonePoly(n, n17, n16);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n18, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n18, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n18, seidelTrapezoid.d1, n2, true);
                } else {
                    int n19 = this.makeNewMonotonePoly(n, n16, n17);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n19, seidelTrapezoid.u0, n2, false);
                }
            } else {
                int n20 = seidelTrapezoid.rightSegment;
                int n21 = this.trapezoidList[seidelTrapezoid.u0].rightSegment;
                if (bl && seidelTrapezoid.u1 == n3) {
                    int n22 = this.makeNewMonotonePoly(n, n21, n20);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n22, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n22, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n22, seidelTrapezoid.u0, n2, false);
                } else {
                    int n23 = this.makeNewMonotonePoly(n, n20, n21);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n23, seidelTrapezoid.u1, n2, false);
                }
            }
        } else if (seidelTrapezoid.u0 > 0 || seidelTrapezoid.u1 > 0) {
            if (seidelTrapezoid.d0 > 0 && seidelTrapezoid.d1 > 0) {
                if (seidelTrapezoid.hi.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.leftSegment].v0, 1.0E-6f)) {
                    int n24 = this.trapezoidList[seidelTrapezoid.d1].leftSegment;
                    int n25 = seidelTrapezoid.leftSegment;
                    if (bl || seidelTrapezoid.d0 != n3) {
                        int n26 = this.makeNewMonotonePoly(n, n25, n24);
                        this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                        this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                        this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                        this.traversePolygon(n26, seidelTrapezoid.d0, n2, true);
                    } else {
                        int n27 = this.makeNewMonotonePoly(n, n24, n25);
                        this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                        this.traversePolygon(n27, seidelTrapezoid.u0, n2, false);
                        this.traversePolygon(n27, seidelTrapezoid.u1, n2, false);
                        this.traversePolygon(n27, seidelTrapezoid.d1, n2, true);
                    }
                } else {
                    int n28 = this.trapezoidList[seidelTrapezoid.d1].leftSegment;
                    int n29 = this.segments[seidelTrapezoid.rightSegment].next;
                    if (!bl && seidelTrapezoid.d1 == n3) {
                        int n30 = this.makeNewMonotonePoly(n, n29, n28);
                        this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                        this.traversePolygon(n30, seidelTrapezoid.u1, n2, false);
                        this.traversePolygon(n30, seidelTrapezoid.u0, n2, false);
                        this.traversePolygon(n30, seidelTrapezoid.d0, n2, true);
                    } else {
                        int n31 = this.makeNewMonotonePoly(n, n28, n29);
                        this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                        this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                        this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                        this.traversePolygon(n31, seidelTrapezoid.d1, n2, true);
                    }
                }
            } else if (seidelTrapezoid.hi.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.leftSegment].v0, 1.0E-6f) && seidelTrapezoid.lo.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.rightSegment].v0, 1.0E-6f)) {
                int n32 = seidelTrapezoid.rightSegment;
                int n33 = seidelTrapezoid.leftSegment;
                if (bl) {
                    int n34 = this.makeNewMonotonePoly(n, n33, n32);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n34, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n34, seidelTrapezoid.d0, n2, true);
                } else {
                    int n35 = this.makeNewMonotonePoly(n, n32, n33);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n35, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n35, seidelTrapezoid.u1, n2, false);
                }
            } else if (seidelTrapezoid.hi.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.rightSegment].v1, 1.0E-6f) && seidelTrapezoid.lo.epsilonEquals((Tuple2f)this.segments[seidelTrapezoid.leftSegment].v1, 1.0E-6f)) {
                int n36 = this.segments[seidelTrapezoid.rightSegment].next;
                int n37 = this.segments[seidelTrapezoid.leftSegment].next;
                if (bl) {
                    int n38 = this.makeNewMonotonePoly(n, n37, n36);
                    this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                    this.traversePolygon(n38, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n38, seidelTrapezoid.d0, n2, true);
                } else {
                    int n39 = this.makeNewMonotonePoly(n, n36, n37);
                    this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
                    this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                    this.traversePolygon(n39, seidelTrapezoid.u0, n2, false);
                    this.traversePolygon(n39, seidelTrapezoid.u1, n2, false);
                }
            } else {
                this.traversePolygon(n, seidelTrapezoid.u0, n2, false);
                this.traversePolygon(n, seidelTrapezoid.d0, n2, true);
                this.traversePolygon(n, seidelTrapezoid.u1, n2, false);
                this.traversePolygon(n, seidelTrapezoid.d1, n2, true);
            }
        }
    }

    private void triangulateMonotonePolygons(int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            boolean bl = false;
            int n5 = 1;
            int n6 = this.monotoneChain[this.monotonePosition[i]].vnum;
            Point2f point2f = this.vertexChain[n6].point;
            Point2f point2f2 = this.vertexChain[n6].point;
            int n7 = this.monotonePosition[i];
            int n8 = this.monotonePosition[i];
            this.monotoneChain[this.monotonePosition[i]].marked = true;
            int n9 = this.monotoneChain[this.monotonePosition[i]].next;
            while ((n4 = this.monotoneChain[n9].vnum) != n6) {
                if (this.monotoneChain[n9].marked) {
                    bl = true;
                    break;
                }
                this.monotoneChain[n9].marked = true;
                if (this.greaterThan(this.vertexChain[n4].point, point2f)) {
                    point2f = this.vertexChain[n4].point;
                    n7 = n9;
                }
                if (this.lessThan(this.vertexChain[n4].point, point2f2)) {
                    point2f2 = this.vertexChain[n4].point;
                    n8 = n9;
                }
                n9 = this.monotoneChain[n9].next;
                ++n5;
            }
            if (bl) continue;
            if (n5 == 3) {
                nArray[n3] = this.monotoneChain[n9].vnum;
                nArray[n3 + 1] = this.monotoneChain[this.monotoneChain[n9].next].vnum;
                nArray[n3 + 2] = this.monotoneChain[this.monotoneChain[n9].prev].vnum;
                n3 += 3;
                continue;
            }
            n4 = this.monotoneChain[this.monotoneChain[n7].next].vnum;
            n3 = this.vertexChain[n4].point.epsilonEquals((Tuple2f)point2f2, 1.0E-6f) ? this.triangulateSinglePolygon(n, n7, false, nArray, n3) : this.triangulateSinglePolygon(n, n7, true, nArray, n3);
        }
    }

    private int triangulateSinglePolygon(int n, int n2, boolean bl, int[] nArray, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3;
        int n8 = 0;
        if (bl) {
            this.reflexChain[0] = this.monotoneChain[n2].vnum;
            this.reflexChain[1] = this.monotoneChain[this.monotoneChain[n2].next].vnum;
            n8 = 1;
            n6 = this.monotoneChain[this.monotoneChain[n2].next].next;
            n5 = this.monotoneChain[n6].vnum;
            n4 = this.monotoneChain[this.monotoneChain[n2].prev].vnum;
            if (n4 == 0) {
                n4 = n;
            }
        } else {
            int n9 = this.monotoneChain[n2].next;
            this.reflexChain[0] = this.monotoneChain[n9].vnum;
            n9 = this.monotoneChain[n9].next;
            this.reflexChain[1] = this.monotoneChain[n9].vnum;
            n8 = 1;
            n6 = this.monotoneChain[n9].next;
            n5 = this.monotoneChain[n6].vnum;
            n4 = this.monotoneChain[n2].vnum;
        }
        while (n5 != n4 || n8 > 1) {
            if (n8 > 0) {
                if (this.tripleCross(this.vertexChain[n5].point, this.vertexChain[this.reflexChain[n8 - 1]].point, this.vertexChain[this.reflexChain[n8]].point) > 0.0f) {
                    nArray[n7] = this.reflexChain[n8 - 1];
                    nArray[n7 + 1] = this.reflexChain[n8];
                    nArray[n7 + 2] = n5;
                    n7 += 3;
                    --n8;
                    continue;
                }
                this.reflexChain[++n8] = n5;
                n6 = this.monotoneChain[n6].next;
                n5 = this.monotoneChain[n6].vnum;
                continue;
            }
            this.reflexChain[++n8] = n5;
            n6 = this.monotoneChain[n6].next;
            n5 = this.monotoneChain[n6].vnum;
        }
        nArray[n7] = this.reflexChain[n8 - 1];
        nArray[n7 + 1] = this.reflexChain[n8];
        nArray[n7 + 2] = n5;
        --n8;
        return n7 += 3;
    }

    private int makeNewMonotonePoly(int n, int n2, int n3) {
        int n4 = this.newMonotone();
        SeidelVertexChain seidelVertexChain = this.vertexChain[n2];
        SeidelVertexChain seidelVertexChain2 = this.vertexChain[n3];
        int n5 = this.getVertexPosition(n2, n3);
        int n6 = this.getVertexPosition(n3, n2);
        int n7 = seidelVertexChain.vertexPosition[n5];
        int n8 = seidelVertexChain2.vertexPosition[n6];
        int n9 = this.newChainElement();
        int n10 = this.newChainElement();
        this.monotoneChain[n9].vnum = n2;
        this.monotoneChain[n10].vnum = n3;
        this.monotoneChain[n9].next = this.monotoneChain[n7].next;
        this.monotoneChain[this.monotoneChain[n7].next].prev = n9;
        this.monotoneChain[n9].prev = n10;
        this.monotoneChain[n10].next = n9;
        this.monotoneChain[n10].prev = this.monotoneChain[n8].prev;
        this.monotoneChain[this.monotoneChain[n8].prev].next = n10;
        this.monotoneChain[n7].next = n8;
        this.monotoneChain[n8].prev = n7;
        int n11 = seidelVertexChain.nextFree++;
        int n12 = seidelVertexChain2.nextFree++;
        seidelVertexChain.nextVertex[n5] = n3;
        seidelVertexChain.vertexPosition[n11] = n9;
        seidelVertexChain.nextVertex[n11] = this.monotoneChain[this.monotoneChain[n9].next].vnum;
        seidelVertexChain2.vertexPosition[n12] = n10;
        seidelVertexChain2.nextVertex[n12] = n2;
        this.monotonePosition[n] = n7;
        this.monotonePosition[n4] = n9;
        return n4;
    }

    private int getVertexPosition(int n, int n2) {
        SeidelVertexChain seidelVertexChain = this.vertexChain[n];
        SeidelVertexChain seidelVertexChain2 = this.vertexChain[n2];
        double d = -4.0;
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            double d2;
            if (seidelVertexChain.nextVertex[i] <= 0 || !((d2 = this.getAngle(seidelVertexChain.point, this.vertexChain[seidelVertexChain.nextVertex[i]].point, seidelVertexChain2.point)) > d)) continue;
            d = d2;
            n3 = i;
        }
        return n3;
    }

    private int newNode() {
        if (this.lastQuery < this.queryList.length) {
            return this.lastQuery++;
        }
        System.err.println("newnode: Query-table overflow\n");
        return -1;
    }

    private int newTrapezoid() {
        if (this.lastTrapezoid < this.trapezoidList.length) {
            this.trapezoidList[this.lastTrapezoid].leftSegment = -1;
            this.trapezoidList[this.lastTrapezoid].rightSegment = -1;
            this.trapezoidList[this.lastTrapezoid].valid = true;
            return this.lastTrapezoid++;
        }
        System.err.println("newtrap: Trapezoid-table overflow\n");
        return -1;
    }

    private int newMonotone() {
        return ++this.lastMonotone;
    }

    private int newChainElement() {
        return ++this.lastVertex;
    }

    private int chooseSegment() {
        return this.permute[this.choiceIndex++];
    }

    private boolean insidePolygon(SeidelTrapezoid seidelTrapezoid) {
        if (!seidelTrapezoid.valid || seidelTrapezoid.leftSegment <= 0 || seidelTrapezoid.rightSegment <= 0) {
            return false;
        }
        if (seidelTrapezoid.u0 <= 0 && seidelTrapezoid.u1 <= 0 || seidelTrapezoid.d0 <= 0 && seidelTrapezoid.d1 <= 0) {
            int n = seidelTrapezoid.rightSegment;
            return this.greaterThan(this.segments[n].v1, this.segments[n].v0);
        }
        return false;
    }

    private double getAngle(Point2f point2f, Point2f point2f2, Point2f point2f3) {
        float f = point2f2.x - point2f.x;
        float f2 = point2f2.y - point2f.y;
        float f3 = point2f3.x - point2f.x;
        float f4 = point2f3.y - point2f.y;
        double d = Math.sqrt(f * f + f2 * f2);
        double d2 = Math.sqrt(f3 * f3 + f4 * f4);
        if (f * f4 - f3 * f2 >= 0.0f) {
            return (double)(f * f3 + f4 * f2) / (d * d2);
        }
        return (double)(-1.0f * (f * f3 + f4 * f2)) / d / d2 - 2.0;
    }

    private int max(Point2f point2f, Point2f point2f2, Point2f point2f3) {
        if (point2f2.y > point2f3.y + 1.0E-6f) {
            point2f.set((Tuple2f)point2f2);
        } else if (this.equalsEpsilon(point2f2.y, point2f3.y)) {
            if (point2f2.x > point2f3.x + 1.0E-6f) {
                point2f.set((Tuple2f)point2f2);
            } else {
                point2f.set((Tuple2f)point2f3);
            }
        } else {
            point2f.set((Tuple2f)point2f3);
        }
        return 0;
    }

    private int min(Point2f point2f, Point2f point2f2, Point2f point2f3) {
        if (point2f2.y < point2f3.y - 1.0E-6f) {
            point2f.set((Tuple2f)point2f2);
        } else if (this.equalsEpsilon(point2f2.y, point2f3.y)) {
            if (point2f2.x < point2f3.x) {
                point2f.set((Tuple2f)point2f2);
            } else {
                point2f.set((Tuple2f)point2f3);
            }
        } else {
            point2f.set((Tuple2f)point2f3);
        }
        return 0;
    }

    private boolean greaterThan(Point2f point2f, Point2f point2f2) {
        if (point2f.y > point2f2.y + 1.0E-6f) {
            return true;
        }
        if (point2f.y < point2f2.y - 1.0E-6f) {
            return false;
        }
        return point2f.x > point2f2.x;
    }

    private boolean lessThan(Point2f point2f, Point2f point2f2) {
        if (point2f.y < point2f2.y - 1.0E-6f) {
            return true;
        }
        if (point2f.y > point2f2.y + 1.0E-6f) {
            return false;
        }
        return point2f.x < point2f2.x;
    }

    private boolean greaterThanOrEqualTo(Point2f point2f, Point2f point2f2) {
        if (point2f.y > point2f2.y + 1.0E-6f) {
            return true;
        }
        if (point2f.y < point2f2.y - 1.0E-6f) {
            return false;
        }
        return point2f.x >= point2f2.x;
    }

    private boolean isLeftOf(int n, Point2f point2f) {
        SeidelSegment seidelSegment = this.segments[n];
        float f = this.greaterThan(seidelSegment.v1, seidelSegment.v0) ? (this.equalsEpsilon(seidelSegment.v1.y, point2f.y) ? (point2f.x < seidelSegment.v1.x ? 1.0f : -1.0f) : (this.equalsEpsilon(seidelSegment.v0.y, point2f.y) ? (point2f.x < seidelSegment.v0.x ? 1.0f : -1.0f) : this.tripleCross(seidelSegment.v0, seidelSegment.v1, point2f))) : (this.equalsEpsilon(seidelSegment.v1.y, point2f.y) ? (point2f.x < seidelSegment.v1.x ? 1.0f : -1.0f) : (this.equalsEpsilon(seidelSegment.v0.y, point2f.y) ? (point2f.x < seidelSegment.v0.x ? 1.0f : -1.0f) : this.tripleCross(seidelSegment.v1, seidelSegment.v0, point2f)));
        return f > 0.0f;
    }

    private float tripleCross(Point2f point2f, Point2f point2f2, Point2f point2f3) {
        return (point2f2.x - point2f.x) * (point2f3.y - point2f.y) - (point2f2.y - point2f.y) * (point2f3.x - point2f.x);
    }

    private boolean inserted(int n, boolean bl) {
        if (bl) {
            return this.segments[this.segments[n].prev].isInserted;
        }
        return this.segments[this.segments[n].next].isInserted;
    }

    private int logStarN(int n) {
        double d = n;
        int n2 = 0;
        while (d >= 1.0) {
            d = Math.log(d) * LOG_2_BASE;
            ++n2;
        }
        return n2 - 1;
    }

    private int nRatio(int n, int n2) {
        double d = n;
        for (int i = 0; i < n2; ++i) {
            d = Math.log(d) * LOG_2_BASE;
        }
        return (int)Math.ceil((double)n / d);
    }

    private boolean equalsEpsilon(float f, float f2) {
        return Math.abs(f - f2) <= 1.0E-6f;
    }
}

