/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public abstract class Particle {
    protected int cycleAge = 0;
    protected long wallClockBirth;
    protected long wallClockLife;
    protected int particleLife;
    protected float surfaceArea = 0.0f;
    protected float energy = 0.0f;
    protected float mass = 0.0f;
    protected Vector3f resultantForce = new Vector3f();
    protected Vector3f velocity = new Vector3f();
    protected Point3f position = new Point3f();
    protected float[] boundingBox;
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;
    protected float width = 0.2f;
    protected float height = 0.2f;
    protected float depth = 0.2f;

    public void getPosition(float[] fArray) {
        fArray[0] = this.position.x;
        fArray[1] = this.position.y;
        fArray[2] = this.position.z;
    }

    public void setPosition(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.red;
        fArray[1] = this.green;
        fArray[2] = this.blue;
        fArray[3] = this.alpha;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public float[] getBounds() {
        if (this.boundingBox == null) {
            this.boundingBox = new float[6];
        }
        this.boundingBox[0] = this.position.x - this.width;
        this.boundingBox[1] = this.position.y - this.height;
        this.boundingBox[2] = this.position.z - this.depth;
        this.boundingBox[0] = this.position.x + this.width;
        this.boundingBox[1] = this.position.y + this.height;
        this.boundingBox[2] = this.position.z + this.depth;
        return this.boundingBox;
    }

    public void incAge() {
        ++this.cycleAge;
    }

    public final int getCycleAge() {
        return this.cycleAge;
    }

    public void setCycleAge(int n) {
        this.cycleAge = n;
    }

    public final int getCycleTime() {
        return this.particleLife;
    }

    public final long getBirthTime() {
        return this.wallClockBirth;
    }

    public void setCycleTime(int n) {
        this.particleLife = n;
        this.wallClockLife = this.wallClockBirth + (long)n;
    }

    public final float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public Vector3f getResultantForce() {
        return this.resultantForce;
    }

    public void setResultantForce(Vector3f vector3f) {
        this.resultantForce.set((Tuple3f)vector3f);
    }

    public final float getSurfaceArea() {
        return this.surfaceArea;
    }

    public void setSurfaceArea(float f) {
        this.surfaceArea = f;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3f vector3f) {
        this.velocity.set((Tuple3f)vector3f);
    }

    public void setDepth(float f) {
        this.depth = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getDepth() {
        return this.depth;
    }
}

