/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.terrain.roam;

import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.renderer.java3d.terrain.AppearanceGenerator;
import org.j3d.renderer.java3d.terrain.J3DLandscape;
import org.j3d.renderer.java3d.terrain.roam.Patch;
import org.j3d.renderer.java3d.texture.TextureCreateUtils;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.TiledTerrainData;
import org.j3d.terrain.roam.ROAMPatch;
import org.j3d.terrain.roam.ROAMSplitMergeLandscape;
import org.j3d.util.frustum.ViewFrustum;

public class J3DSplitMergeLandscape
extends ROAMSplitMergeLandscape
implements J3DLandscape {
    private AppearanceGenerator appearanceGenerator;
    private Vector3f tmpPosition;
    private Vector3f tmpOrientation;
    private Matrix3f tmpMatrix;
    private BranchGroup rootGroup;
    private TextureCreateUtils texUtils;

    public J3DSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        super(viewFrustum, terrainData);
        this.init();
    }

    public J3DSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, int n) {
        super(viewFrustum, terrainData, n);
        this.init();
    }

    public J3DSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, AppearanceGenerator appearanceGenerator) {
        super(viewFrustum, terrainData);
        this.init();
        this.appearanceGenerator = appearanceGenerator;
    }

    public J3DSplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData, int n, AppearanceGenerator appearanceGenerator) {
        super(viewFrustum, terrainData, n);
        this.init();
        this.appearanceGenerator = appearanceGenerator;
    }

    public void transitionEnded(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public void viewerPositionUpdated(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public void setView(Transform3D transform3D) {
        transform3D.get(this.tmpMatrix, this.tmpPosition);
        this.tmpOrientation.set(0.0f, 0.0f, -1.0f);
        this.tmpMatrix.transform((Tuple3f)this.tmpOrientation);
        this.setView((Tuple3f)this.tmpPosition, this.tmpOrientation);
    }

    public void setAppearanceGenerator(AppearanceGenerator appearanceGenerator) {
        this.appearanceGenerator = appearanceGenerator;
    }

    public AppearanceGenerator getAppearanceGenerator() {
        return this.appearanceGenerator;
    }

    public BranchGroup getSceneGraphObject() {
        return this.rootGroup;
    }

    protected ROAMPatch createPatch(int n, int n2, int n3, int n4) {
        AppearanceGenerator appearanceGenerator = this.getAppearanceGenerator();
        Appearance appearance = null;
        Patch patch = null;
        if (appearanceGenerator != null) {
            TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
            BufferedImage bufferedImage = tiledTerrainData.getTexture(n3, n4);
            Texture2D texture2D = this.texUtils.createTexture2D(bufferedImage);
            appearance = appearanceGenerator.createAppearance();
            appearance.setCapability(3);
            appearance.setTexture((Texture)texture2D);
        }
        patch = new Patch(this.terrainData, this.patchSize, appearance, this.landscapeView, n, n2);
        return patch;
    }

    protected void updatePatch(ROAMPatch rOAMPatch, int n, int n2) {
        Patch patch = (Patch)rOAMPatch;
        TiledTerrainData tiledTerrainData = (TiledTerrainData)this.terrainData;
        BufferedImage bufferedImage = tiledTerrainData.getTexture(n, n2);
        Texture2D texture2D = this.texUtils.createTexture2D(bufferedImage);
        Appearance appearance = patch.getAppearance();
        appearance.setTexture((Texture)texture2D);
    }

    protected void addPatch(ROAMPatch rOAMPatch) {
        Patch patch = (Patch)rOAMPatch;
        this.rootGroup.addChild(patch.getSceneGraphObject());
    }

    private void init() {
        this.tmpPosition = new Vector3f();
        this.tmpOrientation = new Vector3f();
        this.tmpMatrix = new Matrix3f();
        this.rootGroup = new BranchGroup();
        this.texUtils = new TextureCreateUtils();
    }
}

