/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jzy3d.maths.graphs.IGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGraph<V, E>
implements IGraph<V, E> {
    protected List<V> vertices = new ArrayList<V>();
    protected List<E> edges = new ArrayList();
    protected Map<E, V> edgeStart = new HashMap<E, V>();
    protected Map<E, V> edgeStop = new HashMap<E, V>();

    @Override
    public void addVertex(V vertex) {
        this.vertices.add(vertex);
    }

    @Override
    public V getVertex(int i) {
        return this.vertices.get(i);
    }

    @Override
    public List<V> getVertices() {
        return this.vertices;
    }

    @Override
    public void addEdge(E edge, V v1, V v2) {
        this.edges.add(edge);
        this.edgeStart.put(edge, v1);
        this.edgeStop.put(edge, v2);
    }

    @Override
    public List<E> getEdges() {
        return this.edges;
    }

    @Override
    public V getEdgeStartVertex(E e) {
        return this.edgeStart.get(e);
    }

    @Override
    public V getEdgeStopVertex(E e) {
        return this.edgeStop.get(e);
    }

    @Override
    public V getRandomVertex() {
        int id = (int)(Math.random() * (double)this.vertices.size());
        return this.getVertex(id);
    }
}

