/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.rendering;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.jzy3d.plot2d.rendering.Canvas;

public class CanvasSWT
implements Canvas {
    private GC target;
    private Color bgColor = new Color((Device)Display.getDefault(), 255, 255, 255);
    private Color fgColor = new Color((Device)Display.getDefault(), 0, 0, 0);
    private Color current;
    private static Color WHITE = new Color((Device)Display.getDefault(), 255, 255, 255);
    private static Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final int PIXEL_WITH = 1;

    public CanvasSWT(GC graphic) {
        this.target = graphic;
    }

    public void dispose() {
        if (this.bgColor != null) {
            this.bgColor.dispose();
        }
        if (this.fgColor != null) {
            this.fgColor.dispose();
        }
    }

    public void drawString(int x, int y, String text) {
        this.target.setBackground(this.bgColor);
        this.target.setForeground(this.fgColor);
        this.target.setFont(new Font((Device)Display.getDefault(), "Arial", 8, 0));
        this.target.drawString(text, x, y);
    }

    public void drawRect(org.jzy3d.colors.Color color, int x, int y, int width, int height, boolean border) {
        if (color != null) {
            if (this.current != null) {
                this.current.dispose();
            }
            this.current = CanvasSWT.swt(color);
            this.target.setBackground(this.current);
            this.target.fillRectangle(x, y, width, height);
        }
        if (border) {
            this.target.setForeground(this.fgColor);
            this.target.drawRectangle(x, y, width, height);
        }
        this.bgColor.dispose();
    }

    public void drawRect(org.jzy3d.colors.Color color, int x, int y, int width, int height) {
        this.drawRect(color, x, y, width, height, true);
    }

    public void drawDot(org.jzy3d.colors.Color color, int x, int y) {
        if (this.current != null) {
            this.current.dispose();
        }
        this.current = CanvasSWT.swt(color);
        this.target.setBackground(this.current);
        this.target.setForeground(this.current);
        this.target.drawRectangle(x - 0, y - 0, 1, 1);
    }

    public void drawOval(org.jzy3d.colors.Color color, int x, int y, int width, int height) {
        if (this.current != null) {
            this.current.dispose();
        }
        this.current = CanvasSWT.swt(color);
        this.target.setBackground(this.current);
        this.target.fillOval(x, y, width, height);
        this.target.setForeground(BLACK);
        this.target.drawOval(x, y, width, height);
    }

    public void drawBackground(org.jzy3d.colors.Color color, int width, int heigth) {
        if (this.bgColor != null) {
            this.bgColor.dispose();
        }
        this.bgColor = CanvasSWT.swt(color);
        this.target.setBackground(this.bgColor);
        this.target.setForeground(this.fgColor);
        this.target.fillRectangle(0, 0, width, heigth);
    }

    public static Color swt(org.jzy3d.colors.Color color) {
        return new Color((Device)Display.getDefault(), (int)(255.0f * color.r), (int)(255.0f * color.g), (int)(255.0f * color.b));
    }
}

