/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingGrid
extends OrthonormalGrid {
    protected double sqradius;
    protected static final int ENLARGE_STEP = 3;

    public RingGrid(double radius, int xysteps) {
        this(radius, xysteps, 0);
    }

    public RingGrid(double radius, int xysteps, int enlargeSteps) {
        super(new Range(-radius - (double)enlargeSteps * radius / (double)xysteps, radius + (double)enlargeSteps * radius / (double)xysteps), xysteps);
        this.sqradius = (radius + (double)enlargeSteps * radius / (double)xysteps) * (radius + (double)enlargeSteps * radius / (double)xysteps);
    }

    @Override
    public List<Coord3d> apply(Mapper mapper) {
        double xstep = this.xrange.getRange() / (double)this.xsteps;
        double ystep = this.yrange.getRange() / (double)this.ysteps;
        ArrayList<Coord3d> output = new ArrayList<Coord3d>((this.xsteps - 1) * (this.ysteps - 1));
        for (int xi = -(this.xsteps - 1) / 2; xi <= (this.xsteps - 1) / 2; ++xi) {
            for (int yi = -(this.ysteps - 1) / 2; yi <= (this.ysteps - 1) / 2; ++yi) {
                double xval = (double)xi * xstep;
                double yval = (double)yi * ystep;
                if (!(this.sqradius >= xval * xval + yval * yval)) continue;
                output.add(new Coord3d(xval, yval, mapper.f(xval, yval)));
            }
        }
        return output;
    }
}

