/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.delaunay.jdt;

import org.jzy3d.plot3d.builder.delaunay.jdt.Point_dt;

public class BoundingBox {
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;

    public BoundingBox() {
        this.setToNull();
    }

    public BoundingBox(BoundingBox other) {
        if (other.isNull()) {
            this.setToNull();
        } else {
            this.init(other.minx, other.maxx, other.miny, other.maxy);
        }
    }

    public BoundingBox(double minx, double maxx, double miny, double maxy) {
        this.init(minx, maxx, miny, maxy);
    }

    public BoundingBox(Point_dt lowerLeft, Point_dt upperRight) {
        this.init(lowerLeft.x, upperRight.x, lowerLeft.y, upperRight.y);
    }

    private void init(double x1, double x2, double y1, double y2) {
        if (x1 < x2) {
            this.minx = x1;
            this.maxx = x2;
        } else {
            this.minx = x2;
            this.maxx = x1;
        }
        if (y1 < y2) {
            this.miny = y1;
            this.maxy = y2;
        } else {
            this.miny = y2;
            this.maxy = y1;
        }
    }

    private void setToNull() {
        this.minx = 0.0;
        this.maxx = -1.0;
        this.miny = 0.0;
        this.maxy = -1.0;
    }

    public boolean isNull() {
        return this.maxx < this.minx;
    }

    public boolean contains(BoundingBox other) {
        return !this.isNull() && !other.isNull() && other.minx >= this.minx && other.maxy <= this.maxx && other.miny >= this.miny && other.maxy <= this.maxy;
    }

    public BoundingBox unionWith(BoundingBox other) {
        if (other.isNull()) {
            return new BoundingBox(this);
        }
        if (this.isNull()) {
            return new BoundingBox(other);
        }
        return new BoundingBox(Math.min(this.minx, other.minx), Math.max(this.maxx, other.maxx), Math.min(this.miny, other.miny), Math.max(this.maxy, other.maxy));
    }

    public double minX() {
        return this.minx;
    }

    public double minY() {
        return this.miny;
    }

    public double maxX() {
        return this.maxx;
    }

    public double maxY() {
        return this.maxy;
    }

    public double getWidth() {
        return this.maxx - this.minx;
    }

    public double getHeight() {
        return this.maxy - this.miny;
    }

    public Point_dt getMinPoint() {
        return new Point_dt(this.minx, this.miny);
    }

    public Point_dt getMaxPoint() {
        return new Point_dt(this.maxx, this.maxy);
    }
}

