/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.view.Camera;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileableComposite
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    private int dlID = -1;
    private boolean resetDL = false;
    protected ColorMapper mapper;
    protected Color color;
    protected boolean detailedToString = false;
    protected List<AbstractDrawable> components = new ArrayList<AbstractDrawable>();

    public void recompile() {
        this.resetDL = true;
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.resetDL) {
            this.reset(gl);
        }
        if (this.dlID == -1) {
            this.compile(gl, glu, cam);
        }
        this.execute(gl, glu, cam);
    }

    protected void compile(GL2 gl, GLU glu, Camera cam) {
        this.reset(gl);
        this.nullifyChildrenTransforms();
        this.dlID = gl.glGenLists(1);
        gl.glNewList(this.dlID, 4864);
        this.drawComponents(gl, glu, cam);
        gl.glEndList();
    }

    protected void execute(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glCallList(this.dlID);
    }

    protected void reset(GL2 gl) {
        if (this.dlID != -1) {
            if (gl.glIsList(this.dlID)) {
                gl.glDeleteLists(this.dlID, 1);
            }
            this.dlID = -1;
        }
        this.resetDL = false;
    }

    protected void nullifyChildrenTransforms() {
        for (AbstractDrawable c : this.components) {
            if (c == null) continue;
            c.setTransform(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawComponents(GL2 gl, GLU glu, Camera cam) {
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable s : this.components) {
                s.draw(gl, glu, cam);
            }
        }
    }

    public void add(List<? extends AbstractDrawable> drawables) {
        this.components.addAll(drawables);
        this.recompile();
    }

    public void clear() {
        this.components.clear();
        this.recompile();
    }

    public void add(AbstractDrawable drawable) {
        this.components.add(drawable);
        this.recompile();
    }

    public void remove(AbstractDrawable drawable) {
        this.components.remove(drawable);
        this.recompile();
    }

    public AbstractDrawable get(int p) {
        return this.components.get(p);
    }

    public List<AbstractDrawable> getDrawables() {
        return this.components;
    }

    public int size() {
        return this.components.size();
    }

    @Override
    public BoundingBox3d getBounds() {
        BoundingBox3d box = new BoundingBox3d();
        for (AbstractDrawable c : this.components) {
            if (c == null || c.getBounds() == null) continue;
            box.add(c.getBounds());
        }
        return box;
    }

    @Override
    public void setWireframeColor(Color color) {
        super.setWireframeColor(color);
        if (this.components != null) {
            for (AbstractDrawable c : this.components) {
                if (c == null || !(c instanceof AbstractWireframeable)) continue;
                ((AbstractWireframeable)c).setWireframeColor(color);
            }
        }
        this.recompile();
    }

    @Override
    public void setWireframeDisplayed(boolean status) {
        super.setWireframeDisplayed(status);
        if (this.components != null) {
            for (AbstractDrawable c : this.components) {
                if (c == null || !(c instanceof AbstractWireframeable)) continue;
                ((AbstractWireframeable)c).setWireframeDisplayed(status);
            }
        }
        this.recompile();
    }

    @Override
    public void setWireframeWidth(float width) {
        super.setWireframeWidth(width);
        if (this.components != null) {
            for (AbstractDrawable c : this.components) {
                if (c == null || !(c instanceof AbstractWireframeable)) continue;
                ((AbstractWireframeable)c).setWireframeWidth(width);
            }
        }
        this.recompile();
    }

    @Override
    public void setFaceDisplayed(boolean status) {
        super.setFaceDisplayed(status);
        if (this.components != null) {
            for (AbstractDrawable c : this.components) {
                if (c == null || !(c instanceof AbstractWireframeable)) continue;
                ((AbstractWireframeable)c).setFaceDisplayed(status);
            }
        }
        this.recompile();
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        if (this.components != null) {
            for (AbstractDrawable d : this.components) {
                if (d instanceof IMultiColorable) {
                    ((IMultiColorable)((Object)d)).setColorMapper(mapper);
                    continue;
                }
                if (!(d instanceof ISingleColorable)) continue;
                ((ISingleColorable)((Object)d)).setColor(mapper.getColor(d.getBarycentre()));
            }
            this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
        }
        this.recompile();
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.components != null) {
            for (AbstractDrawable d : this.components) {
                if (!(d instanceof ISingleColorable)) continue;
                ((ISingleColorable)((Object)d)).setColor(color);
            }
            this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
        }
        this.recompile();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int depth) {
        String output = Utils.blanks(depth) + "(Composite3d) #elements:" + this.components.size() + " | isDisplayed=" + this.isDisplayed();
        if (this.detailedToString) {
            int k = 0;
            for (AbstractDrawable c : this.components) {
                if (c != null) {
                    if (c instanceof AbstractComposite) {
                        output = output + "\n" + ((AbstractComposite)c).toString(depth + 1);
                        continue;
                    }
                    output = output + "\n" + Utils.blanks(depth + 1) + " Composite element[" + k++ + "]:" + c.toString();
                    continue;
                }
                output = output + Utils.blanks(depth + 1) + "(null)\n";
            }
        }
        return output;
    }

    public boolean isDetailedToString() {
        return this.detailedToString;
    }

    public void setDetailedToString(boolean detailedToString) {
        this.detailedToString = detailedToString;
    }
}

