/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.view.Camera;

public class Point
extends AbstractDrawable
implements ISingleColorable {
    public Coord3d xyz;
    public Color rgb;
    public float width;

    public Point() {
        this(Coord3d.ORIGIN, Color.WHITE, 1.0f);
    }

    public Point(Coord3d xyz) {
        this(xyz, Color.WHITE, 1.0f);
    }

    public Point(Coord3d xyz, Color rgb) {
        this(xyz, rgb, 1.0f);
    }

    public Point(Coord3d xyz, Color rgb, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(xyz);
        this.setWidth(width);
        this.setColor(rgb);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glPointSize(this.width);
        gl.glBegin(0);
        gl.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        gl.glVertex3f(this.xyz.x, this.xyz.y, this.xyz.z);
        gl.glEnd();
    }

    public void setData(Coord3d xyz) {
        this.xyz = xyz;
        this.updateBounds();
    }

    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this);
    }

    public void setColor(Color color) {
        this.rgb = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.rgb;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public double getDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    public double getShortestDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    public double getLongestDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(Point) coord=" + this.xyz + ", color=" + this.rgb;
    }
}

