/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.view.Camera;

public class Tube
extends AbstractWireframeable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private float radiusBottom;
    private float radiusTop;
    private float height;
    private int slices;
    private int stacks;
    private Color color;

    public Tube() {
        this.bbox = new BoundingBox3d();
        this.setPosition(Coord3d.ORIGIN);
        this.setVolume(10.0f, 10.0f, 30.0f);
        this.setSlicing(15, 15);
        this.setColor(Color.BLACK);
    }

    public Tube(Coord3d position, float radius, float height, int hslicing, int vslicing, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radius, radius, height);
        this.setSlicing(hslicing, vslicing);
        this.setColor(color);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glTranslatef(this.x, this.y, this.z);
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (this.facestatus) {
            if (this.wfstatus) {
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
            }
            gl.glPolygonMode(1032, 6914);
            gl.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
            glu.gluCylinder(qobj, (double)this.radiusBottom, (double)this.radiusTop, (double)this.height, this.slices, this.stacks);
            if (this.wfstatus) {
                gl.glDisable(32823);
            }
        }
        if (this.wfstatus) {
            gl.glPolygonMode(1032, 6913);
            gl.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            glu.gluCylinder(qobj, (double)this.radiusBottom, (double)this.radiusTop, (double)this.height, this.slices, this.stacks);
        }
    }

    public void setData(Coord3d position, float radiusBottom, float radiusTop, float height, int slices, int stacks) {
        this.setPosition(position);
        this.setVolume(radiusBottom, radiusTop, height);
        this.setSlicing(slices, stacks);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.bbox.reset();
        this.bbox.add(this.x + Math.max(this.radiusBottom, this.radiusTop), this.y + Math.max(this.radiusBottom, this.radiusTop), this.z + this.height);
        this.bbox.add(this.x - Math.max(this.radiusBottom, this.radiusTop), this.y - Math.max(this.radiusBottom, this.radiusTop), this.z - this.height);
    }

    public void setVolume(float radiusBottom, float radiusTop, float height) {
        this.radiusBottom = radiusBottom;
        this.radiusTop = radiusTop;
        this.height = height;
        this.bbox.reset();
        this.bbox.add(this.x + Math.max(radiusBottom, radiusTop), this.y + Math.max(radiusBottom, radiusTop), this.z);
        this.bbox.add(this.x - Math.max(radiusBottom, radiusTop), this.y - Math.max(radiusBottom, radiusTop), this.z);
        this.bbox.add(this.x + Math.max(radiusBottom, radiusTop), this.y + Math.max(radiusBottom, radiusTop), this.z + height);
        this.bbox.add(this.x - Math.max(radiusBottom, radiusTop), this.y - Math.max(radiusBottom, radiusTop), this.z + height);
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.stacks = horizontalWires;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    public Color getColor() {
        return this.color;
    }
}

