/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.graphs;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.graphs.IGraph;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.graphs.IDrawableGraph2d;
import org.jzy3d.plot3d.primitives.graphs.layout.DefaultGraphFormatter;
import org.jzy3d.plot3d.primitives.graphs.layout.IGraphFormatter;
import org.jzy3d.plot3d.primitives.graphs.layout.IGraphLayout2d;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrawableGraph2d<V, E>
extends AbstractDrawable
implements IDrawableGraph2d<V, E> {
    protected Map<V, Boolean> highlights = new HashMap<V, Boolean>();
    protected IGraph<V, E> graph;
    protected IGraphFormatter<V, E> formatter;
    protected IGraphLayout2d<V> layout;
    protected Coord2d labelScreenOffset;
    protected Coord3d labelSceneOffset;
    protected static float Z = 0.0f;
    protected TextBitmapRenderer txt = new TextBitmapRenderer();

    public AbstractDrawableGraph2d() {
        this.formatter = new DefaultGraphFormatter();
    }

    @Override
    public IGraphFormatter<V, E> getGraphFormatter() {
        return this.formatter;
    }

    @Override
    public IGraphLayout2d<V> getGraphLayout() {
        return this.layout;
    }

    @Override
    public IGraph<V, E> getGraphModel() {
        return this.graph;
    }

    @Override
    public void setGraphFormatter(IGraphFormatter<V, E> formatter) {
        this.formatter = formatter;
    }

    @Override
    public void setGraphLayout(IGraphLayout2d<V> layout) {
        this.layout = layout;
        this.bbox.reset();
        for (Coord2d c : layout.values()) {
            this.bbox.add(c.x, c.y, Z);
        }
    }

    @Override
    public void setGraphModel(IGraph<V, E> graph, PickingSupport picking) {
        this.setGraphModel(graph);
    }

    @Override
    public void setGraphModel(IGraph<V, E> graph) {
        this.graph = graph;
        for (V v : graph.getVertices()) {
            this.highlights.put((Boolean)v, false);
        }
    }

    @Override
    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.layout == null) {
            throw new RuntimeException("missing vertex mapping");
        }
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glEnable(2832);
        gl.glHint(3153, 4354);
        if (this.formatter.areEdgesDisplayed()) {
            this.drawEdges(gl, glu, cam);
        }
        if (this.formatter.areVerticesDisplayed()) {
            this.drawVertices(gl, glu, cam);
        }
        if (this.formatter.areVertexLabelsDisplayed()) {
            this.drawVertexLabels(gl, glu, cam);
        }
    }

    protected abstract void drawVertices(GL2 var1, GLU var2, Camera var3);

    protected abstract void drawVertexLabels(GL2 var1, GLU var2, Camera var3);

    protected abstract void drawEdges(GL2 var1, GLU var2, Camera var3);

    public Coord2d getLabelScreenOffset() {
        return this.labelScreenOffset;
    }

    public void setLabelScreenOffset(Coord2d labelOffset) {
        this.labelScreenOffset = labelOffset;
    }

    public Coord3d getLabelSceneOffset() {
        return this.labelSceneOffset;
    }

    public void setLabelSceneOffset(Coord3d labelSceneOffset) {
        this.labelSceneOffset = labelSceneOffset;
    }

    @Override
    public boolean isEdgeHighlighted(E e) {
        return false;
    }

    @Override
    public boolean isVertexHighlighted(V v) {
        return this.highlights.get(v);
    }

    @Override
    public void setVertexHighlighted(V v, boolean nodeDisplayed) {
        this.highlights.put((Boolean)v, nodeDisplayed);
    }

    @Override
    public void clearHighlighted() {
        for (Boolean h : this.highlights.values()) {
            Boolean bl = true;
        }
    }
}

