/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class CanvasNewt
extends Panel
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    protected GLWindow window;
    protected NewtCanvasAWT canvas;
    private static final long serialVersionUID = 8578690050666237742L;

    public CanvasNewt(Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        this.window = GLWindow.create((GLCapabilitiesImmutable)glci);
        this.canvas = new NewtCanvasAWT((Window)this.window);
        this.view = scene.newView(this, quality);
        this.renderer = JzyFactories.renderer3d.getInstance(this.view, false, false);
        this.window.addGLEventListener((GLEventListener)this.renderer);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.window.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator((GLAutoDrawable)this.window);
            this.getAnimator().start();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
    }

    public void dispose() {
        this.window.destroy();
        this.canvas.destroy();
        if (this.renderer != null) {
            this.renderer.dispose((GLAutoDrawable)this.window);
        }
        this.renderer = null;
        this.view = null;
    }

    public void display() {
        this.window.display();
    }

    public void forceRepaint() {
        this.display();
    }

    public GLAnimatorControl getAnimator() {
        return this.window.getAnimator();
    }

    public BufferedImage screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    public View getView() {
        return this.view;
    }

    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }
}

