/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.scene;

import java.util.List;
import java.util.Vector;
import org.jzy3d.factories.JzyFactories;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.lights.LightSet;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene {
    protected Vector<View> views;
    protected Graph graph;
    protected LightSet lightSet;

    public Scene() {
        this(false);
    }

    public Scene(boolean graphsort) {
        this.graph = new Graph(this, JzyFactories.ordering.getInstance(), graphsort);
        this.lightSet = new LightSet();
        this.views = new Vector();
    }

    public Scene(Graph graph) {
        this.graph = graph;
        this.lightSet = new LightSet();
        this.views = new Vector();
    }

    public void dispose() {
        this.graph.dispose();
        for (View v : this.views) {
            v.dispose();
        }
        this.views.clear();
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setLightSet(LightSet lightSet) {
        this.lightSet = lightSet;
    }

    public LightSet getLightSet() {
        return this.lightSet;
    }

    public void add(List<AbstractDrawable> drawables) {
        this.graph.add(drawables);
    }

    public void add(AbstractDrawable drawable) {
        this.graph.add(drawable);
    }

    public void add(AbstractDrawable drawable, boolean updateViews) {
        this.graph.add(drawable, updateViews);
    }

    public void remove(AbstractDrawable drawable, boolean updateViews) {
        this.graph.remove(drawable, updateViews);
    }

    public void remove(AbstractDrawable drawable) {
        this.graph.remove(drawable);
    }

    public void add(Light drawable) {
        this.lightSet.add(drawable);
    }

    public void remove(Light drawable) {
        this.lightSet.remove(drawable);
    }

    public View newView(ICanvas canvas, Quality quality) {
        View view = new View(this, canvas, quality);
        this.views.add(view);
        return view;
    }

    public void clearView(View view) {
        this.views.remove(view);
        view.dispose();
    }

    public String toString() {
        return this.graph.toString();
    }
}

