/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import java.awt.Rectangle;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.plot3d.rendering.view.ViewPort;

abstract class AbstractViewport {
    protected ViewPort lastViewPort;
    private static final float AREA_LEFT = -100.0f;
    private static final float AREA_RIGHT = 100.0f;
    private static final float AREA_TOP = 100.0f;
    private static final float AREA_DOWN = -100.0f;
    private static final float GRID_STEPS = 10.0f;
    private static final float OFFSET = 0.1f;
    protected int screenLeft = 0;
    protected int screenRight = 0;
    protected int screenXOffset = 0;
    protected int screenYOffset = 0;
    protected int screenWidth = 0;
    protected int screenHeight = 0;
    protected int screenSquaredDim = 0;
    protected boolean screenGridDisplayed = false;
    protected boolean stretchToFill = false;
    protected float ratioWidth;
    protected float ratioHeight;

    AbstractViewport() {
    }

    public void setStretchToFill(boolean status) {
        this.stretchToFill = status;
    }

    public boolean getStretchToFill() {
        return this.stretchToFill;
    }

    public void setViewPort(int width, int height) {
        this.setViewPort(width, height, 0.0f, 1.0f);
    }

    public void setViewPort(int width, int height, float left, float right) {
        if (left >= right) {
            throw new IllegalArgumentException("left must be inferior to right");
        }
        this.screenWidth = (int)((right - left) * (float)width);
        this.screenHeight = height;
        this.screenLeft = (int)(left * (float)width);
        this.screenRight = this.screenLeft + this.screenWidth;
    }

    public void setViewPort(ViewPort viewport) {
        this.screenWidth = viewport.getWidth();
        this.screenHeight = viewport.getHeight();
        this.screenLeft = viewport.getX();
        this.screenRight = viewport.getY();
    }

    public ViewPort getLastViewPort() {
        return this.lastViewPort;
    }

    protected void applyViewPort(GL2 gl, GLU glu) {
        if (this.stretchToFill) {
            this.screenXOffset = this.screenLeft;
            this.screenYOffset = 0;
            gl.glViewport(this.screenXOffset, this.screenYOffset, this.screenWidth, this.screenHeight);
            this.lastViewPort = new ViewPort(this.screenWidth, this.screenHeight, this.screenXOffset, this.screenYOffset);
        } else {
            this.screenSquaredDim = Math.min(this.screenWidth, this.screenHeight);
            this.screenXOffset = this.screenLeft + this.screenWidth / 2 - this.screenSquaredDim / 2;
            this.screenYOffset = this.screenHeight / 2 - this.screenSquaredDim / 2;
            gl.glViewport(this.screenXOffset, this.screenYOffset, this.screenSquaredDim, this.screenSquaredDim);
            this.lastViewPort = new ViewPort(this.screenSquaredDim, this.screenSquaredDim, this.screenXOffset, this.screenYOffset);
        }
        if (this.screenGridDisplayed) {
            this.renderSubScreenGrid(gl, glu);
        }
    }

    public Rectangle getRectangle() {
        if (this.stretchToFill) {
            return new Rectangle(this.screenXOffset, this.screenYOffset, this.screenWidth, this.screenHeight);
        }
        return new Rectangle(this.screenXOffset, this.screenYOffset, this.screenSquaredDim, this.screenSquaredDim);
    }

    public void setScreenGridDisplayed(boolean status) {
        this.screenGridDisplayed = status;
    }

    private void renderSubScreenGrid(GL2 gl, GLU glu) {
        if (this.screenWidth <= 0) {
            return;
        }
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        if (this.stretchToFill) {
            int screenXoffset = this.screenLeft;
            int screenYoffset = 0;
            gl.glViewport(screenXoffset, screenYoffset, this.screenWidth, this.screenHeight);
        } else {
            int dimension = Math.min(this.screenWidth, this.screenHeight);
            int screenXoffset = this.screenLeft + this.screenWidth / 2 - dimension / 2;
            int screenYoffset = this.screenHeight / 2 - dimension / 2;
            gl.glViewport(screenXoffset, screenYoffset, dimension, dimension);
        }
        gl.glOrtho(-100.0, 100.0, -100.0, 100.0, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor3f(1.0f, 0.5f, 0.5f);
        gl.glLineWidth(1.0f);
        float step = 20.0f;
        for (float i = -100.0f; i <= 100.0f; i += step) {
            float x = i;
            if (x == -100.0f) {
                x += 0.1f;
            }
            gl.glBegin(1);
            gl.glVertex3f(x, -100.0f, 1.0f);
            gl.glVertex3f(x, 100.0f, 1.0f);
            gl.glEnd();
        }
        step = 20.0f;
        for (float j = -100.0f; j <= 100.0f; j += step) {
            float y = j;
            if (y == 100.0f) {
                y -= 0.1f;
            }
            gl.glBegin(1);
            gl.glVertex3f(-100.0f, y, 1.0f);
            gl.glVertex3f(100.0f, y, 1.0f);
            gl.glEnd();
        }
        gl.glPopMatrix();
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
    }
}

