/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jzy3d.chart.Chart;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.maths.PolygonArray;
import org.jzy3d.maths.Statistics;

public class OverlayUtils {
    public void drawSelection(Graphics2D g2d, IntegerCoord2d in, int width, int height) {
    }

    public static void drawCanvasAndViewportDiagonalComparison(Chart chart, Graphics2D g2d) {
        int wmax = chart.getCanvas().getRendererWidth();
        int hmax = chart.getCanvas().getRendererHeight();
        OverlayUtils.drawDiagonal(g2d, Color.RED, wmax, hmax, true);
        Rectangle r = chart.getView().getSceneViewportRectangle();
        OverlayUtils.drawDiagonal(g2d, Color.BLUE, r.width, r.height, false);
        System.out.println(" BUT viewport.dim (" + r.width + "," + r.height + ")");
        OverlayUtils.drawChartBorder(g2d, Color.GREEN, chart);
    }

    public static void drawPixel(Graphics2D g2d, Color c, int x, int y, int width) {
        g2d.setColor(c);
        if (width >= 2) {
            g2d.fillRect(x - width / 2, y - width / 2, width, width);
        } else {
            g2d.fillRect(x, y, 1, 1);
        }
    }

    public static void drawPixel(Graphics2D g2d, Color c, int x, int y) {
        OverlayUtils.drawPixel(g2d, c, x, y, 1);
    }

    public static void drawText(Graphics2D g2d, Color c, int x, int y, String txt) {
        g2d.setColor(c);
        g2d.drawString(txt, x, y);
    }

    public static void drawChartBorder(Graphics2D g2d, Color c, Chart chart) {
        g2d.setColor(c);
        g2d.drawRect(1, 1, chart.getCanvas().getRendererWidth() - 2, chart.getCanvas().getRendererHeight() - 2);
    }

    public static void drawDiagonal(Graphics2D g2d, Color c, int wmax, int hmax, boolean sysout) {
        int dmax = Math.max(wmax, hmax);
        for (int i = 0; i < dmax; ++i) {
            float r = (float)i / (float)dmax;
            int wcur = (int)(r * (float)wmax);
            int hcur = (int)(r * (float)hmax);
            OverlayUtils.drawPixel(g2d, c, wcur, hcur);
            if (!sysout) continue;
            if (i == 0) {
                System.out.print(" diagonal from (" + wcur + "," + hcur + ")");
                continue;
            }
            if (i != dmax - 1) continue;
            System.out.print(" to (" + wcur + "," + hcur + ")");
        }
    }

    protected IntegerCoord2d canvasToViewport(MouseEvent e, Rectangle viewport) {
        if (viewport.x <= e.getX() && e.getX() <= viewport.x + viewport.width && viewport.y <= e.getY() && e.getY() <= viewport.y + viewport.height) {
            IntegerCoord2d translation = new IntegerCoord2d(e.getX() - viewport.x, e.getY() - viewport.y);
            return translation;
        }
        return new IntegerCoord2d(-1, -1);
    }

    protected IntegerCoord2d canvasToViewport(IntegerCoord2d c, Rectangle viewport) {
        return this.canvasToViewport(viewport, c);
    }

    protected IntegerCoord2d canvasToViewport(Rectangle viewport, IntegerCoord2d c) {
        if (viewport.x <= c.x && c.x <= viewport.x + viewport.width && viewport.y <= c.y && c.y <= viewport.y + viewport.height) {
            IntegerCoord2d translation = new IntegerCoord2d(c.x - viewport.x, c.y - viewport.y);
            return translation;
        }
        return new IntegerCoord2d(-1, -1);
    }

    protected PolygonArray canvasToViewport(PolygonArray p, Rectangle viewport) {
        int len = p.length();
        float[] x = new float[len];
        float[] y = new float[len];
        for (int i = 0; i < len; ++i) {
            x[i] = p.x[i] - (float)viewport.x;
        }
        for (int j = 0; j < len; ++j) {
            y[j] = p.y[j] - (float)viewport.y;
        }
        return new PolygonArray(x, y, p.z);
    }

    protected IntegerCoord2d viewportToCanvas(Chart chart, IntegerCoord2d input, Rectangle viewport) {
        int canvasWidth = chart.getCanvas().getRendererWidth();
        int canvasHeight = chart.getCanvas().getRendererHeight();
        IntegerCoord2d output = new IntegerCoord2d();
        output.x = (int)((float)input.x / (float)viewport.width * (float)canvasWidth);
        output.y = (int)((float)input.y / (float)viewport.height * (float)canvasHeight);
        return output;
    }

    protected void projectionStat(PolygonArray[][] array) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                float tmin;
                PolygonArray p = array[i][j];
                float tmax = Statistics.max(p.x);
                if (tmax > max) {
                    max = tmax;
                }
                if (!((tmin = Statistics.min(p.x)) < min)) continue;
                min = tmin;
            }
        }
        System.out.println("xmin=" + min + " xmax=" + max);
    }
}

