/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.controllers;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.chart.controllers.mouse.MouseUtilities;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.controllers.ViewCameraController;

public class ViewMouseController
extends ViewCameraController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected IScreenCanvas canvas;
    protected Coord2d prevMouse;
    protected CameraThreadController threadController;

    public ViewMouseController() {
    }

    public ViewMouseController(View view) {
        this.addTarget(view);
    }

    public void addMouseSource(IScreenCanvas canvas) {
        this.canvas = canvas;
        this.prevMouse = Coord2d.ORIGIN;
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
    }

    public void dispose() {
        this.canvas.removeMouseListener(this);
        this.canvas.removeMouseMotionListener(this);
        this.canvas.removeMouseWheelListener(this);
        if (this.threadController != null) {
            this.threadController.stop();
        }
    }

    public void addSlaveThreadController(CameraThreadController controller) {
        this.removeSlaveThreadController();
        this.threadController = controller;
    }

    public void removeSlaveThreadController() {
        if (this.threadController != null) {
            this.threadController.stop();
            this.threadController = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (MouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        this.prevMouse.x = e.getX();
        this.prevMouse.y = e.getY();
    }

    public void mouseDragged(MouseEvent e) {
        Coord2d mouse = new Coord2d(e.getX(), e.getY());
        if (MouseUtilities.isLeftDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse).div(100.0f);
            this.rotate(move);
        } else if (MouseUtilities.isRightDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse);
            if (move.y != 0.0f) {
                this.shift(move.y / 500.0f);
            }
        }
        this.prevMouse = mouse;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        float factor = 1.0f + (float)e.getWheelRotation() / 10.0f;
        this.zoom(factor);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

