/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.drawable;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.textures.BufferedImageTexture;

public class TextImageRenderer {
    protected static int OFFSET_CONSTANT = 13;
    protected String text;
    protected Font font;

    public TextImageRenderer(String txt, Font font) {
        this.text = txt;
        this.font = font;
    }

    public BufferedImageTexture getImage() {
        return this.getImage(1.0f);
    }

    public BufferedImageTexture getImage(float ratio) {
        IntegerCoord2d c = this.guessImageDimension(this.text);
        c.x += OFFSET_CONSTANT;
        BufferedImage img = new BufferedImage((int)((float)c.x * ratio), (int)((float)c.y * ratio), 2);
        Graphics g = img.getGraphics();
        g.setFont(this.font);
        g.drawString(this.text, 0, c.y - 1);
        return new BufferedImageTexture(img);
    }

    protected IntegerCoord2d guessImageDimension(String text) {
        BufferedImage img = new BufferedImage(100, 10, 2);
        Graphics g = img.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        return new IntegerCoord2d(fm.stringWidth(text), fm.getHeight());
    }
}

