/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.transform;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.transform.Transformer;

public class Transform {
    private List<Transformer> sequence = new ArrayList<Transformer>();

    public Transform() {
    }

    public Transform(Transformer transformer) {
        this.sequence.add(transformer);
    }

    public Transform(Transform transform) {
        for (Transformer next : transform.sequence) {
            this.sequence.add(next);
        }
    }

    public void add(Transformer next) {
        this.sequence.add(next);
    }

    public void add(Transform transform) {
        for (Transformer next : transform.sequence) {
            this.sequence.add(next);
        }
    }

    public void execute(GL2 gl) {
        this.execute(gl, true);
    }

    public void execute(GL2 gl, boolean loadIdentity) {
        if (loadIdentity) {
            gl.glLoadIdentity();
        }
        for (Transformer t : this.sequence) {
            t.execute(gl);
        }
    }

    public Coord3d compute(Coord3d input) {
        Coord3d output = input.clone();
        for (Transformer t : this.sequence) {
            output = t.compute(output);
        }
        return output;
    }

    public String toString() {
        String txt = "";
        for (Transformer t : this.sequence) {
            txt = txt + " * " + t.toString();
        }
        return txt;
    }
}

