/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa;

import Jama.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Arrays;
import psengine.PSEngine;
import psengine.PSLanguageExceptionList;
import psengine.PSSolver;
import psengine.PSStringList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.loader.helper.CheckJavaOSArch;
import pt.lsts.neptus.util.FileUtil;

public class EuropaUtils {
    private static final String modelDir = new File("conf/nddl").getAbsolutePath();

    public static String clearVarName(String varName) {
        return varName.replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static PSEngine createPlanner(String logDir) throws Exception {
        try {
            EuropaUtils.loadLibrary("System_o");
            final PSEngine europa = PSEngine.makeInstance();
            europa.start();
            europa.getConfig().setProperty("neptus.cfgPath", modelDir);
            europa.getConfig().setProperty("neptus.logDir", logDir);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    europa.shutdown();
                }
            });
            return europa;
        }
        catch (PSLanguageExceptionList e) {
            EuropaUtils.dumpNddlException(e);
            throw e;
        }
    }

    public static String getModel(String relativePath) {
        return FileUtil.getFileAsString((File)new File(modelDir + File.separator + relativePath));
    }

    public static void loadModel(PSEngine engine, String nddlFile) throws PSLanguageExceptionList {
        String nddlInclude = modelDir;
        if (nddlFile.contains("/")) {
            String[] folders = nddlFile.split("/");
            String folder = "";
            for (int i = 0; i < folders.length; ++i) {
                folder = folder + File.separator + folders[i];
                if (!new File(modelDir + folder).isDirectory()) continue;
                nddlInclude = nddlInclude + ":" + modelDir + folder;
            }
        }
        engine.getConfig().setProperty("nddl.includePath", nddlInclude);
        engine.executeScript("nddl", modelDir + File.separator + nddlFile, true);
    }

    public static void eval(PSEngine engine, String nddl) throws PSLanguageExceptionList {
        engine.executeScript("nddl", nddl, false);
    }

    public static void dumpNddlException(PSLanguageExceptionList e) {
        for (int i = 0; i < e.getExceptionCount(); ++i) {
            System.err.println(e.getException(i).getFileName() + " (" + e.getException(i).getLine() + "): " + e.getException(i).getMessage());
        }
    }

    public static PSSolver createSolver(PSEngine engine, int endHorizon) {
        String plannerConfig = modelDir + File.separator + "PlannerConfig.xml";
        PSSolver solver = engine.createSolver(plannerConfig);
        solver.configure(0, endHorizon);
        engine.getConfig().readFromXML(modelDir + File.separator + "NDDL.cfg", true);
        return solver;
    }

    public static boolean failed(PSSolver solver) {
        return solver.isExhausted() || solver.isTimedOut();
    }

    public static boolean complete(PSSolver solver) {
        return solver.getFlaws().size() == 0;
    }

    public static boolean succeeded(PSSolver solver) {
        return EuropaUtils.complete(solver) && !EuropaUtils.failed(solver);
    }

    public static boolean step(PSSolver solver) {
        if (EuropaUtils.failed(solver)) {
            return false;
        }
        solver.step();
        return !EuropaUtils.complete(solver) && !EuropaUtils.failed(solver);
    }

    public static String printFlaws(PSSolver solver) {
        String flaws = "";
        PSStringList fls = solver.getFlaws();
        for (int j = 0; j < fls.size(); ++j) {
            flaws = flaws + "  - " + fls.get(j) + "\n";
        }
        return flaws;
    }

    protected static String locateLibrary(String lib) throws Exception {
        String lookFor = System.mapLibraryName(lib);
        Vector<String> path = new Vector<String>();
        switch (CheckJavaOSArch.getOs()) {
            case "linux-x64": {
                path.add(new File("libJNI/europa/x64").getAbsolutePath());
                break;
            }
        }
        String ldPath = System.getenv("LD_LIBRARY_PATH");
        String europa = System.getenv("EUROPA_HOME");
        if (europa == null) {
            europa = System.getenv("PLASMA_HOME");
        }
        if (europa != null && new File(europa).isDirectory()) {
            path.add(europa + File.separator + "lib");
        }
        path.addAll(Arrays.asList((Object[])System.getProperty("java.library.path").split(File.pathSeparator)));
        if (ldPath != null) {
            path.addAll(Arrays.asList((Object[])ldPath.split(File.pathSeparator)));
        }
        for (String s : path) {
            File f = new File(s, lookFor);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        throw new FileNotFoundException("Library " + System.mapLibraryName(lib) + " was not found in " + StringUtils.join(path, (String)File.pathSeparator));
    }

    public static String loadLibrary(String lib) throws Exception {
        String library = EuropaUtils.locateLibrary(lib);
        NeptusLog.pub().info((Object)("native library loaded from " + library + "."));
        System.load(library);
        return library;
    }

    public static double[] findPolynomialFactors(double[] x, double[] y) throws RuntimeException {
        int n = x.length;
        double[][] data = new double[n][n];
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            double v = 1.0;
            for (int j = 0; j < n; ++j) {
                data[i][n - j - 1] = v;
                v *= x[i];
            }
            rhs[i] = y[i];
        }
        Matrix m = new Matrix(data);
        Matrix b = new Matrix(rhs, n);
        Matrix s = m.solve(b);
        return s.getRowPackedCopy();
    }

    public static String loadModule(PSEngine europa, String lib) throws Exception {
        String library = EuropaUtils.locateLibrary(lib);
        NeptusLog.pub().info((Object)("europa native extension library loaded from " + library + "."));
        europa.loadModule(library);
        return library;
    }

    public static void main(String[] args) {
        double[] x = new double[]{0.7, 1.1, 1.3};
        double[] y = new double[]{28449.0, 18104.0, 15319.0};
        double[] sol = EuropaUtils.findPolynomialFactors(x, y);
        for (int i = 0; i < sol.length; ++i) {
            System.out.println(sol[i]);
            System.out.println(sol[0] * 1.2 * 1.2 + sol[1] * 1.2 + sol[2] + " == " + y[i]);
        }
    }
}

