/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import psengine.PSEngine;
import psengine.PSEntity;
import psengine.PSLanguageExceptionList;
import psengine.PSObject;
import psengine.PSPlanDatabaseClient;
import psengine.PSSolver;
import psengine.PSToken;
import psengine.PSTokenList;
import psengine.PSVarValue;
import psengine.PSVariable;
import pt.lsts.neptus.plugins.europa.EuropaUtils;
import pt.lsts.neptus.plugins.europa.gui.PlanView;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanUtil;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class NeptusSolver {
    private PSEngine europa;
    private PSSolver solver;
    private PSPlanDatabaseClient planDb;
    private LinkedHashMap<String, PSObject> vehicleObjects = new LinkedHashMap();
    private LinkedHashMap<String, PSObject> planObjects = new LinkedHashMap();
    private File logDir = new File("log/europa/" + new SimpleDateFormat("YYYY-MM-dd_HHmmss").format(new Date()));
    BufferedWriter logWriter;

    public NeptusSolver() throws Exception {
        this.logDir.mkdirs();
        this.europa = EuropaUtils.createPlanner(this.logDir.getCanonicalPath());
        EuropaUtils.loadModule(this.europa, "Neptus");
        this.logWriter = new BufferedWriter(new FileWriter(new File(this.logDir, "NeptusSolver.log")));
        try {
            EuropaUtils.loadModel(this.europa, "neptus/auv_model.nddl");
        }
        catch (PSLanguageExceptionList list) {
            EuropaUtils.dumpNddlException(list);
            throw list;
        }
        FileUtil.saveToFile((String)new File(this.logDir, "auv_model.nddl").getAbsolutePath(), (String)EuropaUtils.getModel("neptus/auv_model.nddl"));
        this.planDb = this.europa.getPlanDatabaseClient();
    }

    public synchronized void log(String message) throws Exception {
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        this.logWriter.write(message);
        this.logWriter.flush();
    }

    public Collection<String> getVehicles() {
        return this.vehicleObjects.keySet();
    }

    public String resolveVehicleName(String mangledName) {
        for (Map.Entry<String, PSObject> entry : this.vehicleObjects.entrySet()) {
            if (!entry.getValue().getEntityName().equals(mangledName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String resolvePlanName(String mangledName) {
        for (Map.Entry<String, PSObject> entry : this.planObjects.entrySet()) {
            if (!entry.getValue().getEntityName().equals(mangledName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<PSToken> getPlan(String vehicle) throws Exception {
        PSObject vObj = this.vehicleObjects.get(vehicle);
        if (vObj == null) {
            throw new Exception("Unknown vehicle");
        }
        PSTokenList plan1 = vObj.getTokens();
        Vector<PSToken> plan = new Vector<PSToken>();
        for (int i = 0; i < plan1.size(); ++i) {
            plan.add(plan1.get(i));
        }
        Collections.sort(plan, new Comparator<PSToken>(){

            @Override
            public int compare(PSToken o1, PSToken o2) {
                return new Double(o1.getStart().getLowerBound()).compareTo(o2.getStart().getLowerBound());
            }
        });
        return plan;
    }

    public PSObject addVehicle(String name, LocationType position, double minSpeed, double nomSpeed, double maxSpeed, long minSpeedBattMillis, long nomSpeedBattMillis, long maxSpeedBattMillis) throws Exception {
        position.convertToAbsoluteLatLonDepth();
        double[] pol_factors = EuropaUtils.findPolynomialFactors(new double[]{minSpeed, nomSpeed, maxSpeed}, new double[]{(double)minSpeedBattMillis / 1000.0, (double)nomSpeedBattMillis / 1000.0, (double)maxSpeedBattMillis / 1000.0});
        for (int i = 0; i < pol_factors.length; ++i) {
            if (!(Math.abs(pol_factors[i]) < 1.0E-6)) continue;
            pol_factors[i] = 0.0;
        }
        String nddl = String.format("Auv v_%s = new Auv(%.2f, %.2f, %.2f, %.6f, %.6f, %.6f);", EuropaUtils.clearVarName(name), minSpeed, nomSpeed, maxSpeed, pol_factors[0], pol_factors[1], pol_factors[2]);
        this.eval(nddl + " /* lat=" + position.getLatitudeDegs() + ",lon=" + position.getLongitudeDegs() + ",depth=" + position.getDepth() + "*/");
        PSObject varVehicle = this.europa.getObjectByName("v_" + EuropaUtils.clearVarName(name));
        PSVariable varPosition = varVehicle.getMemberVariable(varVehicle.getEntityName() + ".position");
        this.vehicleObjects.put(name, varVehicle);
        PSObject vehiclePos = PSObject.asPSObject((PSEntity)varPosition.getSingletonValue().asObject());
        PSToken tok = this.planDb.createToken("Position.Pos", false, true);
        tok.getParameter("object").specifyValue(vehiclePos.asPSVarValue());
        tok.getStart().specifyValue(PSVarValue.getInstance((int)0));
        tok.getParameter("latitude").specifyValue(PSVarValue.getInstance((double)position.getLatitudeDegs()));
        tok.getParameter("longitude").specifyValue(PSVarValue.getInstance((double)position.getLongitudeDegs()));
        tok.getParameter("depth").specifyValue(PSVarValue.getInstance((double)position.getDepth()));
        return varVehicle;
    }

    public void eval(String nddl) throws Exception {
        EuropaUtils.eval(this.europa, nddl);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.logDir, "auv_model.nddl"), true));
        bw.write(nddl + "\n");
        bw.close();
    }

    public PSObject addTask(PlanType plan) throws Exception {
        String planName = plan.getId();
        Vector mans = PlanUtil.getLocationsAsSequence((PlanType)plan);
        if (mans.isEmpty()) {
            throw new Exception("Cannot compute plan locations");
        }
        double dist = PlanUtil.getPlanLength((PlanType)plan);
        LocationType startLoc = PlanUtil.getFirstLocation((PlanType)plan);
        LocationType endLoc = PlanUtil.getEndLocation((PlanType)plan);
        startLoc.convertToAbsoluteLatLonDepth();
        endLoc.convertToAbsoluteLatLonDepth();
        String nddl = String.format("DuneTask t_%s = new DuneTask(%.8f, %.8f, %.8f, %.8f, %.1f);", EuropaUtils.clearVarName(planName), startLoc.getLatitudeDegs(), startLoc.getLongitudeDegs(), endLoc.getLatitudeDegs(), endLoc.getLongitudeDegs(), dist);
        this.eval(nddl);
        System.out.println(nddl);
        PSObject varTask = this.europa.getObjectByName("t_" + EuropaUtils.clearVarName(planName));
        this.planObjects.put(planName, varTask);
        return varTask;
    }

    public PSToken addGoal(String vehicle, String planId, double speed) throws Exception {
        PSToken g_tok = this.planDb.createToken("Auv.Execute", true, false);
        g_tok.getParameter("object").specifyValue(this.vehicleObjects.get(vehicle).asPSVarValue());
        g_tok.getParameter("task").specifyValue(this.planObjects.get(planId).asPSVarValue());
        g_tok.getParameter("speed").specifyValue(PSVarValue.getInstance((double)speed));
        g_tok.getParameter("id").specifyValue(PSVarValue.getInstance((int)g_tok.getEntityKey()));
        return g_tok;
    }

    public void closeDomain() {
        this.planDb.close();
    }

    public void solve(int maxSteps) throws Exception {
        this.solver = EuropaUtils.createSolver(this.europa, 26100);
        while (this.solver.getStepCount() < maxSteps) {
            this.log("\n\n--STEP " + this.solver.getStepCount() + " DEPTH: " + this.solver.getDepth() + "--\n");
            this.log(EuropaUtils.printFlaws(this.solver));
            this.log("\n\n--PLAN (" + this.solver.getStepCount() + ")--\n");
            this.log(this.europa.planDatabaseToString());
            this.log("\n--PLAN END (" + this.solver.getStepCount() + ")--\n");
            if (EuropaUtils.step(this.solver)) continue;
            if (EuropaUtils.failed(this.solver)) {
                this.log("\n\n--Solver failed to find a plan--\n");
                throw new Exception("Solver failed to find a plan");
            }
            this.log("\n--Search finished--\n");
            return;
        }
        this.log("\n\n--Solver failed to find a plan in " + maxSteps + " steps--\n");
        throw new Exception("Solver could not find a plan in " + maxSteps + " steps");
    }

    public void resetSolver() {
        this.solver.reset();
    }

    public PSEngine getEuropa() {
        return this.europa;
    }

    public synchronized void shutdown() throws Exception {
        if (this.europa != null) {
            this.europa.shutdown();
        }
        this.europa = null;
        if (this.logWriter != null) {
            this.logWriter.close();
        }
        this.logWriter = null;
    }

    public static void main(String[] args) throws Exception {
        String oldPath = System.getProperty("java.library.path");
        System.setProperty("java.library.path", "." + File.pathSeparator + oldPath + File.pathSeparator + new File(".", "libJNI/europa/x64").getCanonicalPath());
        oldPath = System.getProperty("java.library.path");
        System.setProperty("java.library.path", oldPath + File.pathSeparator + "/opt/europa-2.6/lib");
        Locale.setDefault(Locale.Category.FORMAT, Locale.US);
        Locale.setDefault(Locale.US);
        MissionType mt = new MissionType("missions/APDL/missao-apdl.nmisz");
        LocationType loc1 = new LocationType((LocationType)mt.getHomeRef());
        LocationType loc2 = new LocationType(loc1).translatePosition(200.0, 180.0, 0.0);
        NeptusSolver solver = new NeptusSolver();
        String[] vehicles = new String[]{"lauv-xtreme-2", "lauv-xplore-1"};
        solver.addVehicle(vehicles[0], loc1, 0.7, 1.0, 1.3, 28800000L, 21600000L, 14400000L);
        solver.addVehicle(vehicles[1], loc2, 0.7, 1.0, 1.3, 28800000L, 21600000L, 14400000L);
        for (PlanType pt : mt.getIndividualPlansList().values()) {
            solver.addTask(pt);
        }
        solver.closeDomain();
        int count = 0;
        for (PlanType pt : mt.getIndividualPlansList().values()) {
            solver.addGoal(vehicles[count++ % 2], pt.getId(), Math.random() * 0.6 + 0.7);
        }
        solver.solve(1000);
        PlanView view = new PlanView(solver);
        JFrame frm = GuiUtils.testFrame((JComponent)view);
        frm.pack();
    }
}

