/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import psengine.PSToken;
import pt.lsts.neptus.plugins.europa.NeptusSolver;
import pt.lsts.neptus.plugins.europa.gui.PlanViewListener;
import pt.lsts.neptus.plugins.europa.gui.TimelineView;
import pt.lsts.neptus.plugins.europa.gui.TimelineViewListener;

public class PlanView
extends JPanel
implements TimelineViewListener {
    private static final long serialVersionUID = 25568315874216387L;
    private Vector<TimelineView> timelines = new Vector();
    private NeptusSolver solver;
    private HashSet<PlanViewListener> listeners = new HashSet();

    public PlanView(NeptusSolver solver) {
        this.setBackground(Color.white);
        this.setLayout((LayoutManager)new MigLayout(new LC().fillX().gridGap("5px", "0px")));
        for (String v : solver.getVehicles()) {
            try {
                TimelineView tl = new TimelineView(solver);
                tl.setPlan(solver.getPlan(v));
                this.add(new JLabel(v));
                this.add((Component)tl, new CC().growX().wrap());
                tl.addListener(this);
                this.timelines.add(tl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.endTimeChanged(null, 0L);
    }

    public TimelineView addTimeline(String name, Collection<PSToken> plan) {
        TimelineView view = new TimelineView(this.solver);
        view.setPlan(plan);
        this.timelines.add(view);
        return view;
    }

    @Override
    public void startTimeChanged(TimelineView source, long startTimeMillis) {
        long minStart = startTimeMillis;
        for (TimelineView v : this.timelines) {
            minStart = Math.min(v.getStartTime(), minStart);
        }
        for (TimelineView v : this.timelines) {
            v.setStartTime(minStart);
        }
    }

    @Override
    public void endTimeChanged(TimelineView source, long startTimeMillis) {
        long maxEnd = startTimeMillis;
        for (TimelineView v : this.timelines) {
            maxEnd = Math.max(v.computeEndTime(), maxEnd);
        }
        for (TimelineView v : this.timelines) {
            v.setEndTime(maxEnd);
        }
    }

    public void addListener(PlanViewListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PlanViewListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void tokenSelected(TimelineView source, TimelineView.PlanToken token) {
        for (TimelineView v : this.timelines) {
            if (v.equals(source)) continue;
            v.setSelectedToken(null);
        }
        for (PlanViewListener l : this.listeners) {
            l.tokenSelected(token);
        }
    }

    @Override
    public void planChanged() {
        for (TimelineView v : this.timelines) {
            v.reloadPlan();
        }
    }
}

