/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa.gui;

import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import psengine.PSToken;
import psengine.PSTokenList;
import psengine.PSVariable;

public class PlanVisualization
extends JPanel {
    private static final long serialVersionUID = 960157151397992518L;
    private Graph<PSToken, String> graph = new DirectedSparseGraph();
    private VisualizationViewer<PSToken, String> vv = null;

    public String getVertexLabel(PSToken tok) {
        String id = " (" + tok.getEntityKey();
        for (PSToken merged : this.asCollection(tok.getMerged())) {
            id = id + "," + merged.getEntityKey();
        }
        id = id + ")";
        String ret = tok.getFullTokenType() + id;
        for (int i = 0; i < tok.getParameters().size(); ++i) {
            PSVariable v = tok.getParameters().get(i);
            if (v.isSingleton()) {
                ret = ret + "<br> &nbsp;" + v.getEntityName() + " = " + v.getSingletonValue();
                continue;
            }
            String lower = "" + v.getLowerBound();
            String upper = "" + v.getUpperBound();
            if (v.getLowerBound() < -1.0E14) {
                lower = "-inf";
            }
            if (v.getUpperBound() > 1.0E14) {
                upper = "+inf";
            }
            ret = ret + "<br> &nbsp;" + v.getEntityName() + " = [" + lower + "," + upper + "]";
        }
        return ret;
    }

    private Collection<PSToken> asCollection(PSTokenList tokenList) {
        Vector<PSToken> col = new Vector<PSToken>();
        for (int i = 0; i < tokenList.size(); ++i) {
            col.add(tokenList.get(i));
        }
        return col;
    }

    private PSToken find(PSToken tok) {
        if (this.graph.containsVertex((Object)tok)) {
            return tok;
        }
        for (PSToken merged : this.asCollection(tok.getMerged())) {
            System.out.println(tok.getEntityKey() + " merged with " + merged.getEntityKey());
            if (!this.graph.containsVertex((Object)merged)) continue;
            return merged;
        }
        return null;
    }

    private boolean addToken(PSToken t) {
        PSToken existing = this.find(t);
        if (existing == null) {
            this.graph.addVertex((Object)t);
            existing = t;
        }
        for (PSToken slave : this.asCollection(t.getSlaves())) {
            this.addToken(slave);
            this.graph.addEdge((Object)("slave_" + Math.random() * 1000.0), (Object)this.find(slave), (Object)t);
        }
        return true;
    }

    public PlanVisualization(Collection<PSToken> plan) {
        PSToken prev = null;
        for (PSToken tok : plan) {
            this.addToken(tok);
            if (prev != null) {
                this.graph.addEdge((Object)("before_" + Math.random() * 1000.0), (Object)prev, (Object)tok);
            }
            prev = tok;
        }
        KKLayout layout = new KKLayout(this.graph);
        layout.setSize(new Dimension(300, 300));
        this.vv = new VisualizationViewer((Layout)layout);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        this.vv.addKeyListener(gm.getModeKeyListener());
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.vv.getRenderContext().setVertexLabelRenderer(new VertexLabelRenderer(){

            public <T> Component getVertexLabelRendererComponent(JComponent arg0, Object arg1, Font arg2, boolean arg3, T arg4) {
                if (arg4 instanceof PSToken) {
                    JLabel lbl = new JLabel("<html><pre>" + PlanVisualization.this.getVertexLabel((PSToken)arg4));
                    lbl.setOpaque(true);
                    lbl.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                    lbl.setBackground(new Color(160, 160, 192, 128));
                    lbl.setFont(new Font("Arial", 0, 8));
                    return lbl;
                }
                return new JLabel(arg4 + "");
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.vv, "Center");
    }
}

