/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import psengine.PSEngine;
import psengine.PSObject;
import psengine.PSToken;
import psengine.PSTokenState;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FuelLevel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.europa.NeptusSolver;
import pt.lsts.neptus.plugins.europa.gui.PlanTask;
import pt.lsts.neptus.plugins.europa.gui.PlanView;
import pt.lsts.neptus.plugins.europa.gui.PlanViewListener;
import pt.lsts.neptus.plugins.europa.gui.TimelineView;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;

public class SolverPanel
extends JPanel {
    private static final long serialVersionUID = -7352001540896377542L;
    private DefaultListModel<PlanTask> listModel = new DefaultListModel();
    private JList<PlanTask> tasks = new JList<PlanTask>(this.listModel);
    private JButton btnSolve;
    private JButton btnReset;
    private JComboBox<VehicleType> vehicles = new JComboBox();
    private JComboBox<PlanType> plans = new JComboBox();
    private JFormattedTextField speed = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)2));
    private JFormattedTextField idleTime = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)0));
    private ConsoleLayout console;
    private PlanView plan;
    private JPanel planViewHolder = new JPanel(new BorderLayout());
    private NeptusSolver solver;
    private Thread backgroundTask;

    public SolverPanel(ConsoleLayout console) {
        this.console = console;
        this.initialize();
        this.reset();
    }

    private Collection<VehicleType> getVehicles() {
        HashSet<VehicleType> ret = new HashSet<VehicleType>();
        for (ImcSystem sys : ImcSystemsHolder.lookupActiveSystemVehicles()) {
            ret.add(sys.getVehicle());
        }
        ret.add(VehiclesHolder.getVehicleById((String)this.console.getMainSystem()));
        return ret;
    }

    private Collection<PlanType> getPlans() {
        return this.console.getMission().getIndividualPlansList().values();
    }

    public void reset() {
        this.vehicles.removeAllItems();
        this.plans.removeAllItems();
        this.planViewHolder.removeAll();
        this.listModel.removeAllElements();
        for (VehicleType vt : this.getVehicles()) {
            this.vehicles.addItem(vt);
        }
        for (PlanType pt : this.getPlans()) {
            this.plans.addItem(pt);
        }
        if (this.solver != null) {
            try {
                this.solver.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.planViewHolder.removeAll();
        this.plan = null;
        this.planViewHolder.doLayout();
        this.btnSolve.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void solve() {
        if (this.solver != null) {
            PSEngine pSEngine = this.solver.getEuropa();
            synchronized (pSEngine) {
                this.solver.getEuropa().shutdown();
            }
        }
        if (this.plan != null) {
            this.planViewHolder.removeAll();
            this.planViewHolder.doLayout();
            this.planViewHolder.revalidate();
        }
        this.backgroundTask = new Thread("Europa solver"){

            @Override
            public void run() {
                Vector<PSToken> goals = new Vector<PSToken>();
                Vector<PSObject> planVehicles = new Vector<PSObject>();
                try {
                    int i;
                    SolverPanel.this.solver = new NeptusSolver();
                    for (i = 0; i < SolverPanel.this.vehicles.getItemCount(); ++i) {
                        String vehicle = ((VehicleType)SolverPanel.this.vehicles.getItemAt(i)).getId();
                        HomeReference loc = SolverPanel.this.console.getMission().getHomeRef();
                        double speed1 = 0.7;
                        double speed2 = 1.1;
                        double speed3 = 1.3;
                        long speed2Batt = 18000000L;
                        long speed1Batt = (long)((double)speed2Batt * (speed2 / speed1));
                        long speed3Batt = (long)((double)speed2Batt * (speed2 / speed3));
                        if (ImcMsgManager.getManager().getState(vehicle).isActive()) {
                            LinkedHashMap opModes;
                            EstimatedState pos = ImcMsgManager.getManager().getState(vehicle).lastEstimatedState();
                            loc = IMCUtils.getLocation((IMCMessage)pos);
                            FuelLevel fl = ImcMsgManager.getManager().getState(vehicle).lastFuelLevel();
                            if (fl != null && (opModes = fl.getOpmodes()) != null && opModes.containsKey("Motion")) {
                                speed2Batt = (long)(Double.parseDouble((String)opModes.get("Motion")) * 3600.0 * 1000.0);
                                speed1Batt = (long)((double)speed2Batt * (speed2 / speed1));
                                speed3Batt = (long)((double)speed2Batt * (speed2 / speed3));
                            }
                        }
                        planVehicles.add(SolverPanel.this.solver.addVehicle(((VehicleType)SolverPanel.this.vehicles.getItemAt(i)).getId(), (LocationType)loc, speed1, speed2, speed3, speed1Batt, speed2Batt, speed3Batt));
                    }
                    for (i = 0; i < SolverPanel.this.plans.getItemCount(); ++i) {
                        SolverPanel.this.solver.addTask((PlanType)SolverPanel.this.plans.getItemAt(i));
                    }
                    for (i = 0; i < SolverPanel.this.listModel.getSize(); ++i) {
                        PlanTask pt = (PlanTask)SolverPanel.this.listModel.get(i);
                        goals.add(SolverPanel.this.solver.addGoal(pt.vehicle.getId(), pt.plan.getId(), pt.speed));
                    }
                    try {
                        SolverPanel.this.solver.solve(1000);
                        System.out.println(SolverPanel.this.solver.getEuropa().planDatabaseToString());
                    }
                    catch (Exception e) {
                        GuiUtils.errorMessage((Component)SolverPanel.this, (String)I18n.text((String)"Mission Planner"), (String)I18n.textf((String)"The solver could not find a solution: %explanation", (Object[])new Object[]{e.getMessage()}));
                        SolverPanel.this.btnSolve.setEnabled(true);
                        return;
                    }
                    Vector<PSToken> rejectedTokens = new Vector<PSToken>();
                    String rejectionList = "";
                    for (PSToken goal : goals) {
                        if (goal.getTokenState() != PSTokenState.REJECTED) continue;
                        rejectedTokens.add(goal);
                        String vehicle = SolverPanel.this.solver.resolveVehicleName(goal.getParameter("object").getSingletonValue().asObject().getEntityName());
                        String task = SolverPanel.this.solver.resolvePlanName(goal.getParameter("task").getSingletonValue().asObject().getEntityName());
                        float speed = (float)goal.getParameter("speed").getLowerBound();
                        rejectionList = rejectionList + "\n\t - " + I18n.textf((String)"Execute %plan by %vehicle at %speed m/s", (Object[])new Object[]{task, vehicle, Float.valueOf(speed)});
                    }
                    if (!rejectedTokens.isEmpty()) {
                        GuiUtils.errorMessage((Component)SolverPanel.this, (String)I18n.text((String)"Mission Planner"), (String)("<html>" + I18n.text((String)"The following objectives were rejected by the solver: ") + rejectionList));
                    }
                    SolverPanel.this.plan = new PlanView(SolverPanel.this.solver);
                    SolverPanel.this.plan.setMinimumSize(new Dimension(10, 200));
                    SolverPanel.this.plan.endTimeChanged(null, 0L);
                    SolverPanel.this.planViewHolder.add(SolverPanel.this.plan);
                    SolverPanel.this.planViewHolder.doLayout();
                    SolverPanel.this.planViewHolder.revalidate();
                    SolverPanel.this.plan.addListener(new PlanViewListener(){

                        @Override
                        public void tokenSelected(TimelineView.PlanToken token) {
                            try {
                                SolverPanel.this.console.setPlan((PlanType)SolverPanel.this.console.getMission().getIndividualPlansList().get(token.id));
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    GuiUtils.errorMessage((Component)SolverPanel.this, (Exception)e);
                }
                SolverPanel.this.btnSolve.setEnabled(true);
            }
        };
        this.backgroundTask.setDaemon(true);
        this.backgroundTask.start();
    }

    private void initialize() {
        this.setLayout((LayoutManager)new MigLayout(new LC().minWidth("600px"), new AC().fill()));
        this.speed.setColumns(4);
        this.idleTime.setColumns(4);
        String[] textLocalized = I18n.textf((String)"Execute %plan with %vehicle travelling at %speed m/s idling up to %idletime seconds. ", (Object[])new Object[]{"<SPLIT>", "<SPLIT>", "<SPLIT>", "<SPLIT>"}).split("<SPLIT>");
        int i = 0;
        this.add(new JLabel(textLocalized[i++]));
        this.add(this.plans);
        this.add(new JLabel(textLocalized[i++]));
        this.add(this.vehicles);
        this.add(new JLabel(textLocalized[i++]));
        this.add(this.speed);
        this.speed.setValue(1.1);
        this.add(new JLabel(textLocalized[i++]));
        this.add(this.idleTime);
        this.idleTime.setValue(0);
        this.add(new JLabel(textLocalized[i++]));
        JButton addBtn = new JButton("Add");
        this.add((Component)addBtn, "span");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanTask pt = new PlanTask((PlanType)SolverPanel.this.plans.getSelectedItem(), (VehicleType)SolverPanel.this.vehicles.getSelectedItem(), Double.parseDouble(SolverPanel.this.speed.getText()));
                SolverPanel.this.listModel.addElement(pt);
                SolverPanel.this.planViewHolder.removeAll();
                SolverPanel.this.plan = null;
                SolverPanel.this.planViewHolder.doLayout();
            }
        });
        this.tasks.setBorder(new TitledBorder("Tasks"));
        this.add(this.tasks, new CC().grow(new float[]{0.5f}).span(new int[0]));
        this.tasks.setMinimumSize(new Dimension(10, 200));
        this.tasks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PlanTask pt = (PlanTask)SolverPanel.this.tasks.getSelectedValue();
                if (pt != null && e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add("Remove task").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SolverPanel.this.listModel.removeElement(SolverPanel.this.tasks.getSelectedValue());
                            SolverPanel.this.planViewHolder.removeAll();
                            SolverPanel.this.plan = null;
                            SolverPanel.this.planViewHolder.doLayout();
                        }
                    });
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.btnSolve = new JButton(I18n.text((String)"Solve"));
        this.btnSolve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolverPanel.this.btnSolve.setEnabled(false);
                SolverPanel.this.solve();
            }
        });
        this.add(this.btnSolve);
        this.btnReset = new JButton(I18n.text((String)"Reset"));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolverPanel.this.reset();
            }
        });
        this.add((Component)this.btnReset, "wrap");
        this.planViewHolder.setBorder(BorderFactory.createTitledBorder(I18n.text((String)"Result")));
        this.planViewHolder.setMinimumSize(new Dimension(10, 200));
        this.add((Component)this.planViewHolder, new CC().grow(new float[]{0.4f}).span(new int[0]));
    }
}

