/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.europa.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JPanel;
import psengine.PSConstraint;
import psengine.PSEngine;
import psengine.PSToken;
import psengine.PSVarValue;
import psengine.PSVariable;
import psengine.PSVariableList;
import pt.lsts.neptus.plugins.europa.NeptusSolver;
import pt.lsts.neptus.plugins.europa.gui.TimelineViewListener;
import pt.lsts.neptus.util.DateTimeUtil;

public class TimelineView
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 4762326206387225633L;
    private Vector<PlanToken> plan = new Vector();
    private BiMap<PlanToken, PSToken> original = HashBiMap.create();
    private long startTime = 0L;
    private long endTime = this.startTime + 3600000L;
    private NeptusSolver solver;
    private PlanToken selectedToken = null;
    private PlanToken ghostToken = null;
    private long ghostStartOffset = 0L;
    private long ghostDurationOffset;
    private static int count = 0;
    private Color c1 = new Color(255, 255, 255);
    private Color c2 = new Color(192, 192, 192);
    private HashSet<TimelineViewListener> listeners = new HashSet();
    private static final String TRANSIT_ID = "__TRANSIT__";
    Point2D lastDragPoint = null;

    public void addListener(TimelineViewListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TimelineViewListener listener) {
        this.listeners.remove(listener);
    }

    public long computeEndTime() {
        if (this.plan.isEmpty()) {
            return 0L;
        }
        return this.plan.lastElement().end;
    }

    public TimelineView(NeptusSolver solver) {
        this.solver = solver;
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(600, 50));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    private void addToken(PlanToken tok) {
        this.plan.add(tok);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPlan() {
        long end = this.endTime;
        for (PlanToken p : this.plan) {
            PSEngine pSEngine = this.solver.getEuropa();
            synchronized (pSEngine) {
                p.start = (long)(1000.0 * p.original.getStart().getLowerBound());
                p.end = (long)(1000.0 * p.original.getEnd().getLowerBound());
            }
        }
        if (this.computeEndTime() > end) {
            for (TimelineViewListener l : this.listeners) {
                l.endTimeChanged(this, this.computeEndTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlan(Collection<PSToken> p) {
        this.plan.clear();
        this.original.clear();
        PSEngine pSEngine = this.solver.getEuropa();
        synchronized (pSEngine) {
            long startTime = 0L;
            for (PSToken tok : p) {
                PlanToken t = new PlanToken();
                t.start = startTime + (long)(tok.getStart().getLowerBound() * 1000.0);
                t.end = startTime + (long)(tok.getEnd().getLowerBound() * 1000.0);
                t.original = tok;
                if (tok.getParameter("task") != null) {
                    t.id = tok.getParameter("task").getSingletonValue().asObject().getEntityName();
                    String name = this.solver.resolvePlanName(t.id);
                    if (name != null) {
                        t.id = name;
                    }
                    t.speed = (float)tok.getParameter("speed").getLowerBound();
                    this.original.put((Object)t, (Object)tok);
                } else {
                    t.id = TRANSIT_ID;
                    t.speed = (float)tok.getParameter("speed").getLowerBound();
                }
                this.addToken(t);
                long newStart = Math.min(startTime, t.start);
                long newEnd = Math.max(this.endTime, t.end);
                if (newEnd != this.endTime) {
                    this.endTime = newEnd;
                    for (TimelineViewListener l : this.listeners) {
                        l.endTimeChanged(this, this.endTime);
                    }
                }
                if (newStart == startTime) continue;
                startTime = newStart;
                for (TimelineViewListener l : this.listeners) {
                    l.startTimeChanged(this, startTime);
                }
            }
        }
    }

    private long screenToTime(Point2D pointOnScreen) {
        double scale = (double)(this.endTime - this.startTime) / (double)this.getWidth();
        return this.startTime + (long)(scale * pointOnScreen.getX());
    }

    private double timeOnScreen(long timeMillis) {
        return (double)(timeMillis - this.startTime) / (double)(this.endTime - this.startTime) * (double)this.getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.gray.brighter());
        g2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        for (long h = 0L; h < this.endTime; h += 0x6DDD00L) {
            g2d.setColor(this.c1);
            double x1 = this.timeOnScreen(h);
            double x2 = this.timeOnScreen(h + 3600000L);
            double x3 = this.timeOnScreen(h + 0x6DDD00L);
            g2d.fill(new Rectangle2D.Double(x1, 0.0, x2, this.getHeight()));
            g2d.setColor(this.c2);
            g2d.fill(new Rectangle2D.Double(x2, 0.0, x3, this.getHeight()));
        }
        Vector<PlanToken> h = this.plan;
        synchronized (h) {
            for (PlanToken tok : this.plan) {
                if (this.selectedToken == tok) {
                    this.paintToken(tok, 0L, 0L, g2d, new Color(128, 255, 128, 224), new Color(255, 255, 255, 224));
                    continue;
                }
                this.paintToken(tok, 0L, 0L, g2d, new Color(255, 255, 128, 224), new Color(192, 192, 64, 224));
            }
        }
        if (this.ghostToken != null) {
            long durationInc = this.ghostDurationOffset;
            this.paintToken(this.ghostToken, this.ghostStartOffset - durationInc / 2L, this.ghostStartOffset + durationInc / 2L, g2d, new Color(192, 128, 128, 64), new Color(192, 192, 64, 64));
        }
    }

    private void paintToken(PlanToken tok, long startOffset, long endOffset, Graphics2D g2d, Color c1, Color c2) {
        double start = this.timeOnScreen(tok.start + startOffset);
        double end = this.timeOnScreen(tok.end + endOffset);
        if (!tok.id.equals(TRANSIT_ID)) {
            g2d.setPaint(new GradientPaint(new Point2D.Double(start, 0.0), c1, new Point2D.Double(end, this.getHeight()), c2));
            g2d.fill(new RoundRectangle2D.Double(start, 2.0, end - start, this.getHeight() - 4, 12.0, 12.0));
            g2d.setColor(Color.black);
            g2d.draw(new RoundRectangle2D.Double(start, 2.0, end - start, this.getHeight() - 4, 12.0, 12.0));
            g2d.drawString(tok.id, (int)start + 5, 14);
            g2d.drawString(String.format("%.1f m/s", Float.valueOf(tok.speed)), (int)start + 5, 30);
        } else {
            c1 = c1.darker();
            c1 = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha() / 2);
            c2 = c2.darker();
            c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha() / 2);
            g2d.setPaint(new GradientPaint(new Point2D.Double(start, 0.0), c1, new Point2D.Double(end, this.getHeight()), c2));
            g2d.fill(new RoundRectangle2D.Double(start, 2.0, end - start, this.getHeight() - 4, 12.0, 12.0));
            g2d.setColor(Color.gray.darker());
            g2d.drawString(String.format("%.1f m/s", Float.valueOf(tok.speed)), (int)start + 5, 30);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ghostToken != null) {
            double xDragAmount = (double)e.getX() - this.lastDragPoint.getX();
            double scale = (double)(this.endTime - this.startTime) / (double)this.getWidth();
            long timeIncrease = (long)(xDragAmount * scale);
            if (!e.isControlDown()) {
                this.ghostStartOffset += timeIncrease;
                this.repaint();
            } else {
                this.ghostDurationOffset += timeIncrease;
                this.repaint();
            }
            this.lastDragPoint = e.getPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanToken intercepted(MouseEvent e) {
        long time = this.screenToTime(e.getPoint());
        Vector<PlanToken> vector = this.plan;
        synchronized (vector) {
            for (PlanToken tok : this.plan) {
                if (tok.start > time || tok.end < time) continue;
                return tok;
            }
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        PlanToken intercepted = this.intercepted(e);
        String selected = "";
        if (intercepted != null) {
            selected = intercepted.id + " ";
        }
        this.setToolTipText(selected + DateTimeUtil.milliSecondsToFormatedString((long)this.screenToTime(e.getPoint())));
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        PlanToken before = this.getSelectedToken();
        this.setSelectedToken(this.intercepted(e));
        if (this.getSelectedToken() != before) {
            for (TimelineViewListener l : this.listeners) {
                l.tokenSelected(this, this.getSelectedToken());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        PlanToken intercepted = this.intercepted(e);
        if (intercepted != null) {
            this.ghostToken = intercepted;
            this.ghostDurationOffset = 0L;
            this.ghostStartOffset = 0L;
            this.lastDragPoint = e.getPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSConstraint addConstraint(PSVariable var, int value, PSConstraint existing) {
        PSEngine token;
        try {
            String prefix = "";
            if (var.getParent() != null && (token = this.solver.getEuropa().getTokenByKey(var.getParent().getEntityKey())) != null) {
                prefix = token.getFullTokenType() + " (" + token.getEntityKey() + ").";
            }
            this.solver.log(" --" + prefix + var.toLongString() + " constrained to [" + value + ", +inf]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PSConstraint created = null;
        token = this.solver.getEuropa();
        synchronized (token) {
            this.solver.getEuropa().setAutoPropagation(false);
            PSVariableList list = new PSVariableList();
            PSVariable varNew = this.solver.getEuropa().getPlanDatabaseClient().createVariable("int", "var_" + ++count, true);
            varNew.specifyValue(PSVarValue.getInstance((int)value));
            list.push_back(varNew);
            list.push_back(var);
            created = this.solver.getEuropa().getPlanDatabaseClient().createConstraint("leq", list);
            boolean propResult = this.solver.getEuropa().propagate();
            this.solver.getEuropa().setAutoPropagation(true);
            if (!propResult) {
                try {
                    this.solver.log("Adding constraint failed.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.solver.getEuropa().setAutoPropagation(false);
                this.solver.getEuropa().getPlanDatabaseClient().deleteConstraint(created);
                this.solver.getEuropa().propagate();
                this.solver.getEuropa().setAutoPropagation(true);
                created = null;
                return existing;
            }
            if (existing != null) {
                this.solver.getEuropa().setAutoPropagation(false);
                this.solver.getEuropa().getPlanDatabaseClient().deleteConstraint(existing);
                this.solver.getEuropa().propagate();
                this.solver.getEuropa().setAutoPropagation(true);
            }
            try {
                this.solver.log("\n\n--PLAN --\n");
                this.solver.log(this.solver.getEuropa().planDatabaseToString());
                this.solver.log("\n--PLAN END --\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (TimelineViewListener l : this.listeners) {
            l.planChanged();
        }
        return created;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.ghostToken != null) {
            int newTime;
            PSToken tok = this.ghostToken.original;
            if (this.ghostStartOffset != 0L) {
                newTime = (int)(this.ghostToken.start + this.ghostStartOffset - this.startTime) / 1000;
                this.ghostToken.startConstraint = this.addConstraint(tok.getStart(), newTime, this.ghostToken.startConstraint);
            }
            if (this.ghostDurationOffset != 0L) {
                newTime = (int)Math.min(tok.getDuration().getUpperBound(), (double)((this.ghostToken.end - this.ghostToken.start + this.ghostDurationOffset) / 1000L));
                this.ghostToken.endConstraint = this.addConstraint(tok.getDuration(), newTime, this.ghostToken.endConstraint);
            }
        }
        this.ghostToken = null;
        this.ghostDurationOffset = 0L;
        this.ghostStartOffset = 0L;
        this.lastDragPoint = null;
        this.repaint();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.repaint();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
        this.repaint();
    }

    public PlanToken getSelectedToken() {
        return this.selectedToken;
    }

    public void setSelectedToken(PlanToken selectedToken) {
        this.selectedToken = selectedToken;
        this.repaint();
    }

    static class PlanToken {
        long start;
        long end;
        float speed;
        String id;
        PSToken original = null;
        PSConstraint startConstraint = null;
        PSConstraint endConstraint = null;

        PlanToken() {
        }
    }
}

