/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.web3d.parser.vrml97.ParseException;
import org.web3d.parser.vrml97.VRML97RelaxedParser;
import org.web3d.parser.x3d.X3DBinaryParser;
import org.web3d.parser.x3d.X3DRelaxedParser;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.parser.BaseReader;
import org.web3d.vrml.parser.VRMLParserUtils;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.web3d.x3d.jaxp.X3DErrorHandler;
import org.web3d.x3d.jaxp.X3DSAVAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class GeneralisedReader
extends BaseReader {
    private static final String NAMESPACE_PROP = "useNamespaces";
    private static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    private static final String NO_HEADER_MSG = "Header missing #VRML or #X3D statement";
    private VRML97RelaxedParser relaxed97;
    private X3DRelaxedParser relaxed03;
    private X3DBinaryParser binary03;
    private SAXParserFactory parserFactory;
    private X3DSAVAdapter adapter;
    private X3DEntityResolver resolver;
    private X3DErrorHandler x3dErrors;
    private ContentHandler savContentHandler;

    GeneralisedReader() {
        this.properties.put(NAMESPACE_PROP, Boolean.FALSE);
        try {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new org.web3d.vrml.parser.FactoryConfigurationError("No SAX parser defined");
        }
        this.adapter = new X3DSAVAdapter();
        this.x3dErrors = new X3DErrorHandler();
        this.resolver = new X3DEntityResolver();
    }

    public void parse(final InputSource inputSource) throws IOException, VRMLException {
        boolean bl = false;
        boolean bl2 = false;
        PushbackReader pushbackReader = null;
        boolean bl3 = false;
        String string = inputSource.getURL();
        String string2 = null;
        if (string != null && string.endsWith(".x3db")) {
            string2 = "model/x3d+binary";
        }
        if (string2 != null && string2.equals("model/x3d+binary")) {
            bl3 = true;
        } else {
            try {
                Reader reader = (Reader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return inputSource.getCharacterStream();
                    }
                });
                pushbackReader = new PushbackReader(reader);
            }
            catch (PrivilegedActionException privilegedActionException) {
                String string3 = "IO Error while attempting to access file " + inputSource.getURL();
                IOException iOException = new IOException(string3);
                iOException.initCause(privilegedActionException.getException());
                throw iOException;
            }
            int n = 0;
            block11: while (!bl) {
                n = pushbackReader.read();
                switch (n) {
                    case 60: {
                        bl2 = true;
                        bl = true;
                        continue block11;
                    }
                    case 35: {
                        bl2 = false;
                        bl = true;
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block11;
                    }
                }
                bl = true;
            }
            if (n != -1) {
                pushbackReader.unread(n);
            }
        }
        String string4 = (String)this.properties.get("conformance");
        if (bl2) {
            Object object;
            boolean bl4 = string4.equals("weak");
            Boolean bl5 = (Boolean)this.properties.get(NAMESPACE_PROP);
            this.parserFactory.setValidating(!bl4);
            this.parserFactory.setNamespaceAware(bl5);
            XMLReader xMLReader = null;
            try {
                object = this.parserFactory.newSAXParser();
                this.adapter.setLoadState(inputSource.getBaseURL(), inputSource.getURL(), false);
                xMLReader = ((SAXParser)object).getXMLReader();
                xMLReader.setContentHandler(this.adapter);
                xMLReader.setProperty(LEXICAL_HANDLER_PROP, this.adapter);
                xMLReader.setErrorHandler(this.x3dErrors);
                xMLReader.setEntityResolver(this.resolver);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException("Unable to configure factory as required");
            }
            object = new org.xml.sax.InputSource();
            ((org.xml.sax.InputSource)object).setCharacterStream(pushbackReader);
            ((org.xml.sax.InputSource)object).setEncoding(inputSource.getEncoding());
            try {
                xMLReader.parse((org.xml.sax.InputSource)object);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception != null) {
                    this.errorReporter.errorReport("Error parsing XML", exception);
                    throw new VRMLException("Failed to parse file");
                }
                this.errorReporter.errorReport("Error parsing XML", sAXException);
                throw new VRMLException("Failed to parse file");
            }
        }
        String string5 = inputSource.getBaseURL();
        String string6 = inputSource.getURL();
        if (string6 == null) {
            string6 = "Unknown URL source. Base URL is " + string5;
        }
        if (string4.equals("weak")) {
            this.parseVRMLWeakly(pushbackReader, bl3, inputSource, string5, string6);
        } else if (string4.equals("strict")) {
            this.parseVRMLStrictly(pushbackReader, string5, string6);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        this.x3dErrors.setErrorReporter(errorReporter);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        super.setContentHandler(contentHandler);
        this.adapter.setContentHandler(contentHandler);
        this.savContentHandler = contentHandler;
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        super.setScriptHandler(scriptHandler);
        this.adapter.setScriptHandler(scriptHandler);
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        super.setProtoHandler(protoHandler);
        this.adapter.setProtoHandler(protoHandler);
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        super.setRouteHandler(routeHandler);
        this.adapter.setRouteHandler(routeHandler);
    }

    private void parseVRMLWeakly(Reader reader, boolean bl, InputSource inputSource, String string, String string2) throws IOException, VRMLException {
        String[] stringArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (reader == null) {
            if (bl) {
                bl3 = true;
            }
            stringArray = new String[4];
            stringArray[0] = "#X3D";
            stringArray[1] = "V3.1";
            stringArray[2] = "binary";
        } else if (!this.ignoreHeader) {
            stringArray = VRMLParserUtils.parseFileHeader(reader);
            if (stringArray.length != 4) {
                throw new VRMLParseException(1, 1, NO_HEADER_MSG);
            }
            if (!stringArray[0].equals("#VRML") && !stringArray[0].equals("#X3D")) {
                throw new VRMLParseException(1, 1, "Invalid header. Not a vrml file");
            }
            bl2 = stringArray[0].equals("#VRML");
            if (stringArray[1] == null || bl2 && !stringArray[1].equals("V2.0") || !bl2 && !stringArray[1].equals("V3.0") && !stringArray[1].equals("V3.1")) {
                throw new VRMLParseException(1, 5, "Unsupported version2 " + stringArray[1]);
            }
            if (stringArray[2] == null || !stringArray[2].equals("utf8") && !stringArray[2].equals("binary")) {
                throw new VRMLParseException(1, 10, "Unsupported encoding " + stringArray[2]);
            }
        } else {
            bl2 = false;
            stringArray = new String[4];
            stringArray[0] = "#X3D";
            stringArray[1] = "V3.1";
            stringArray[2] = "utf8";
        }
        Locator locator = null;
        if (bl2) {
            if (this.relaxed97 == null) {
                this.relaxed97 = new VRML97RelaxedParser(reader);
                this.relaxed97.initialize();
            } else {
                this.relaxed97.ReInit(reader);
            }
            this.relaxed97.setContentHandler(this.contentHandler);
            this.relaxed97.setRouteHandler(this.routeHandler);
            this.relaxed97.setScriptHandler(this.scriptHandler);
            this.relaxed97.setProtoHandler(this.protoHandler);
            this.relaxed97.setErrorReporter(this.errorReporter);
            this.relaxed97.setDocumentUrl(string2);
            locator = this.relaxed97.getDocumentLocator();
        }
        if (bl3) {
            InputStream inputStream = inputSource.getByteStream();
            if (this.binary03 == null) {
                this.binary03 = new X3DBinaryParser(inputStream);
                this.binary03.initialize();
            } else {
                this.binary03.ReInit(inputStream);
            }
            this.binary03.setContentHandler(this.contentHandler);
            this.binary03.setRouteHandler(this.routeHandler);
            this.binary03.setScriptHandler(this.scriptHandler);
            this.binary03.setProtoHandler(this.protoHandler);
            this.binary03.setErrorReporter(this.errorReporter);
            this.binary03.setDocumentUrl(string2);
            locator = this.binary03.getDocumentLocator();
        } else {
            if (this.relaxed03 == null) {
                this.relaxed03 = new X3DRelaxedParser(reader);
                this.relaxed03.initialize();
            } else {
                this.relaxed03.ReInit(reader);
            }
            this.relaxed03.setContentHandler(this.contentHandler);
            this.relaxed03.setRouteHandler(this.routeHandler);
            this.relaxed03.setScriptHandler(this.scriptHandler);
            this.relaxed03.setProtoHandler(this.protoHandler);
            this.relaxed03.setErrorReporter(this.errorReporter);
            this.relaxed03.setDocumentUrl(string2);
            locator = this.relaxed03.getDocumentLocator();
        }
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
            this.contentHandler.startDocument(string2, string, stringArray[2], stringArray[0], stringArray[1], stringArray[3]);
        }
        try {
            if (bl2) {
                this.relaxed97.Scene();
            } else if (bl3) {
                this.binary03.Scene();
            } else {
                this.relaxed03.Scene();
            }
            if (this.contentHandler != null) {
                this.contentHandler.endDocument();
            }
        }
        catch (ParseException parseException) {
            VRMLParseException vRMLParseException = new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), "Error in file: " + string2 + "\n" + parseException.getMessage());
            throw vRMLParseException;
        }
        catch (org.web3d.parser.x3d.ParseException parseException) {
            VRMLParseException vRMLParseException = new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), "Error in file: " + string2 + "\n" + parseException.getMessage());
            throw vRMLParseException;
        }
    }

    protected void parseVRMLStrictly(Reader reader, String string, String string2) throws IOException, SAVException {
        throw new SAVNotSupportedException("Strict parsing not implemented yet");
    }
}

