/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.web3d.parser.x3d.X3DFieldReader;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.export.Exporter;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.UnsupportedSpecVersionException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.SceneBuilder;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.renderer.CRProtoCreator;
import org.web3d.vrml.renderer.norender.NRNodeFactory;
import org.web3d.vrml.renderer.norender.NRProtoCreator;
import org.web3d.vrml.renderer.norender.NRSceneBuilderFactory;
import org.web3d.vrml.sav.BinaryContentHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.SAVException;

public abstract class BaseRetainedExporter
extends Exporter
implements BinaryContentHandler {
    protected static final String CONTAINER_PROPS_FILE = "XMLcontainerfields.properties";
    protected OutputStream oStream;
    protected int majorVersion;
    protected int minorVersion;
    protected SceneBuilder builder;
    protected VRMLNodeFactory nodeFactory;
    protected HashMap defaultNodes;
    protected VRMLNodeType defaultNode;
    protected boolean upgrading;
    protected Map currentDefMap;
    protected Map currentIsMap;
    protected PrototypeDecl currentPrototypeDecl;
    protected CRProtoCreator protoCreator;
    protected VRMLScene scene;
    protected String profile;
    protected ArrayList componentList;
    private SimpleStack defStack;
    private HashMap currentDefTable;
    private SimpleStack defRemapStack;
    private HashMap currentDefRemapTable;
    private SimpleStack defNumStack;
    private HashMap currentDefNumTable;
    protected HashMap epToUrl;
    private String currentEp;
    protected Pattern[] scriptPatterns;
    protected String[] scriptReplacements;
    protected boolean convertOldContent;
    protected HashMap oldProtos;
    protected HashMap fieldRemap;
    protected boolean hanimFound;
    protected HashMap hanimNodes;
    protected boolean geospatialFound;
    protected HashMap geospatialNodes;
    protected HashMap isCache;
    protected Properties containerFields;
    protected String encodingTo;
    protected boolean stripWhitespace;
    protected boolean processingDocument;
    protected VRMLFieldReader fieldReader;
    static /* synthetic */ Class class$org$web3d$vrml$export$BaseRetainedExporter;

    public BaseRetainedExporter(int n, int n2) {
        super(n, n2);
        NRSceneBuilderFactory nRSceneBuilderFactory = new NRSceneBuilderFactory(false, true, true, true, true, true, true);
        this.builder = nRSceneBuilderFactory.createBuilder();
        this.nodeFactory = NRNodeFactory.getNRNodeFactory();
        this.defaultNodes = new HashMap();
        this.componentList = new ArrayList();
        this.isCache = new HashMap();
        this.currentDefTable = new HashMap();
        this.currentDefRemapTable = new HashMap();
        this.currentDefNumTable = new HashMap();
        this.defStack = new SimpleStack();
        this.defRemapStack = new SimpleStack();
        this.defNumStack = new SimpleStack();
        this.epToUrl = new HashMap();
        this.initScriptPatterns();
        this.initOldProtos();
        this.stripWhitespace = false;
    }

    public void setConvertOldContent(boolean bl) {
        this.convertOldContent = bl;
        if (bl) {
            this.fieldReader = new X3DFieldReader();
        }
    }

    protected abstract void printHeader(int var1, int var2);

    protected abstract void printProfile(String var1);

    protected abstract void printComponents(ComponentInfo[] var1);

    protected abstract void printMetaData(Map var1);

    protected abstract void printPrototypeDecl(PrototypeDecl var1);

    protected abstract void printROUTE(ROUTE var1, Map var2);

    protected abstract void printExports(Map var1);

    protected abstract void printImports(Map var1);

    public void endDocument() throws SAVException, VRMLException {
        this.builder.endDocument();
        this.scene = this.builder.getScene();
        if (this.convertOldContent) {
            if (this.hanimFound) {
                this.componentList.add(new ComponentInfo("H-Anim", 1));
            }
            if (this.geospatialFound) {
                this.componentList.add(new ComponentInfo("Geospatial", 1));
            }
        }
        int n = this.scene.getSpecificationMajorVersion();
        int n2 = this.scene.getSpecificationMinorVersion();
        if (this.upgrading) {
            n = 3;
            n2 = 0;
        }
        SceneMetaData sceneMetaData = this.scene.getMetaData();
        this.printHeader(n, n2);
        String string = this.upgrading ? "Immersive" : sceneMetaData.getProfileName();
        this.printProfile(string);
        ComponentInfo[] componentInfoArray = sceneMetaData.getComponents();
        int n3 = this.componentList.size();
        int n4 = 0;
        if (componentInfoArray != null) {
            n4 = componentInfoArray.length;
        }
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[n4 + this.componentList.size()];
        this.componentList.toArray(componentInfoArray2);
        if (n4 > 0) {
            for (int i = 0; i < componentInfoArray.length; ++i) {
                componentInfoArray2[n3 + i] = componentInfoArray[i];
            }
        }
        this.printComponents(componentInfoArray2);
        this.printMetaData(sceneMetaData.getMetaData());
    }

    public void setDocumentLocator(Locator locator) {
        this.builder.setDocumentLocator(locator);
        if (this.fieldReader != null) {
            this.fieldReader.setDocumentLocator(locator);
        }
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        if (this.processingDocument) {
            return;
        }
        this.processingDocument = true;
        int n = string5.indexOf(46);
        String string7 = string5.substring(n + 1);
        this.majorVersion = 3;
        this.minorVersion = Integer.parseInt(string7);
        this.nodeFactory.setSpecVersion(this.majorVersion, this.minorVersion);
        if (string5.equals("V2.0")) {
            this.upgrading = true;
            this.nodeFactory.setProfile("Immersive");
            this.profile = "Immersive";
            System.out.println("Upgrading content from VRML to X3D");
        }
        this.builder.startDocument(string, string2, string3, string4, string5, string6);
        this.protoCreator = new NRProtoCreator(this.nodeFactory, string2, this.majorVersion, this.minorVersion);
        this.hanimFound = false;
        this.geospatialFound = false;
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.builder.profileDecl(string);
        this.nodeFactory.setProfile(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        this.builder.componentDecl(string);
        int n = string.indexOf(":");
        if (n < 0) {
            throw new VRMLException("Invalid component decl , no level");
        }
        String string2 = string.substring(0, n);
        int n2 = Integer.parseInt(string.substring(n + 1));
        this.nodeFactory.addComponent(string2, n2);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        this.builder.metaDecl(string, string2);
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        this.builder.importDecl(string, string2, string3);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        this.builder.exportDecl(string, string2);
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        if (string2 != null) {
            if (this.currentDefTable.get(string2) != null) {
                Integer n = (Integer)this.currentDefNumTable.get(string2);
                n = n != null ? new Integer(n + 1) : new Integer(1);
                this.currentDefNumTable.put(string2, n);
                String string3 = string2 + n;
                System.out.println("Duplicate DEF detected, renamed to: " + string3);
                this.currentDefRemapTable.put(string2, string3);
                string2 = string3;
            } else {
                this.currentDefTable.put(string2, string);
            }
        }
        if (this.convertOldContent) {
            if (this.hanimNodes.get(string) != null) {
                this.hanimFound = true;
            }
            if (this.geospatialNodes.get(string) != null) {
                this.geospatialFound = true;
            }
        }
        this.builder.startNode(string, string2);
    }

    public void endNode() throws SAVException, VRMLException {
        this.builder.endNode();
    }

    public void startField(String string) throws SAVException, VRMLException {
        this.builder.startField(string);
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        this.builder.fieldValue(string);
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        this.builder.fieldValue(stringArray);
    }

    public void fieldValue(int n) throws SAVException, VRMLException {
        this.builder.fieldValue(n);
    }

    public void fieldValue(int[] nArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(nArray, n);
    }

    public void fieldValue(boolean bl) throws SAVException, VRMLException {
        this.builder.fieldValue(bl);
    }

    public void fieldValue(boolean[] blArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(blArray, n);
    }

    public void fieldValue(float f) throws SAVException, VRMLException {
        this.builder.fieldValue(f);
    }

    public void fieldValue(float[] fArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(fArray, n);
    }

    public void fieldValue(long l) throws SAVException, VRMLException {
        this.builder.fieldValue(l);
    }

    public void fieldValue(long[] lArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(lArray, n);
    }

    public void fieldValue(double d) throws SAVException, VRMLException {
        this.builder.fieldValue(d);
    }

    public void fieldValue(double[] dArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(dArray, n);
    }

    public void fieldValue(String[] stringArray, int n) throws SAVException, VRMLException {
        this.builder.fieldValue(stringArray);
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        String string2 = (String)this.currentDefRemapTable.get(string);
        if (string2 != null) {
            string = string2;
        }
        this.builder.useDecl(string);
    }

    public void endField() throws SAVException, VRMLException {
        this.builder.endField();
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        this.builder.routeDecl(string, string2, string3, string4);
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.builder.startScriptDecl();
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.builder.endScriptDecl();
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        this.builder.scriptFieldDecl(n, string, string2, object);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        this.builder.startProtoDecl(string);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        this.builder.endProtoDecl();
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        this.builder.protoFieldDecl(n, string, string2, object);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        this.builder.protoIsDecl(string);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        this.builder.startProtoBody();
        this.defStack.push(this.currentDefTable);
        this.defRemapStack.push(this.currentDefRemapTable);
        this.defNumStack.push(this.currentDefNumTable);
        this.currentDefTable = new HashMap();
        this.currentDefRemapTable = new HashMap();
        this.currentDefNumTable = new HashMap();
    }

    public void endProtoBody() throws SAVException, VRMLException {
        this.builder.endProtoBody();
        this.currentDefTable = (HashMap)this.defStack.pop();
        this.currentDefRemapTable = (HashMap)this.defRemapStack.pop();
        this.currentDefNumTable = (HashMap)this.defNumStack.pop();
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        this.builder.startExternProtoDecl(string);
        this.currentEp = string;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.builder.endExternProtoDecl();
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        this.builder.externProtoURI(stringArray);
        this.epToUrl.put(this.currentEp, stringArray);
    }

    protected String findIS(VRMLNodeType vRMLNodeType, int n, Map map) {
        if (map == null) {
            return null;
        }
        Map.Entry[] entryArray = (Map.Entry[])this.isCache.get(map);
        if (entryArray == null) {
            entryArray = new Map.Entry[map.size()];
            map.entrySet().toArray(entryArray);
            this.isCache.put(map, entryArray);
        }
        for (int i = 0; i < entryArray.length; ++i) {
            List list = (List)entryArray[i].getValue();
            for (int j = 0; j < list.size(); ++j) {
                ProtoFieldInfo protoFieldInfo = (ProtoFieldInfo)list.get(j);
                if (protoFieldInfo.node != vRMLNodeType || protoFieldInfo.field != n) continue;
                VRMLFieldDeclaration vRMLFieldDeclaration = this.currentPrototypeDecl.getFieldDeclaration(((Integer)entryArray[i].getKey()).intValue());
                return vRMLFieldDeclaration.getName();
            }
        }
        return null;
    }

    protected void printIS(Map map) {
        if (map == null) {
            return;
        }
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        for (int i = 0; i < entryArray.length; ++i) {
            List list = (List)entryArray[i].getValue();
            for (int j = 0; j < list.size(); ++j) {
                ProtoFieldInfo protoFieldInfo = (ProtoFieldInfo)list.get(j);
                System.out.println("   n: " + protoFieldInfo.node + " field: " + protoFieldInfo.field);
            }
        }
    }

    protected void printDefMap(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        System.out.println("DEF Map:");
        for (int i = 0; i < entryArray.length; ++i) {
            System.out.println("   " + entryArray[i].getKey() + " --> " + entryArray[i].getValue());
        }
    }

    protected String getPublicId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "ISO//Web3D//DTD X3D 3.0//EN";
            }
            case 1: {
                return "ISO//Web3D//DTD X3D 3.1//EN";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }

    protected String getSystemId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "http://www.web3d.org/specifications/x3d-3.0.dtd";
            }
            case 1: {
                return "http://www.web3d.org/specifications/x3d-3.1.dtd";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }

    protected void reverseMap(Map map, Map map2) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            VRMLNode vRMLNode = (VRMLNode)entry.getValue();
            String string = (String)entry.getKey();
            map2.put(entry.getValue(), string);
        }
    }

    protected void loadContainerProperties(final int n, final int n2) {
        if (this.containerFields == null) {
            this.containerFields = new Properties();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = "config/" + n + "." + n2 + "/" + BaseRetainedExporter.CONTAINER_PROPS_FILE;
                try {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
                    if (inputStream == null) {
                        inputStream = (class$org$web3d$vrml$export$BaseRetainedExporter == null ? (class$org$web3d$vrml$export$BaseRetainedExporter = BaseRetainedExporter.class$("org.web3d.vrml.export.BaseRetainedExporter")) : class$org$web3d$vrml$export$BaseRetainedExporter).getClassLoader().getResourceAsStream(string);
                    }
                    if (inputStream != null) {
                        BaseRetainedExporter.this.containerFields.load(inputStream);
                    } else {
                        System.out.println("Couldn't find container properties file: " + string);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error reading container properties file");
                }
                return null;
            }
        });
    }

    private void initScriptPatterns() {
        this.scriptPatterns = new Pattern[7];
        this.scriptReplacements = new String[7];
        int n = 0;
        this.scriptPatterns[n] = Pattern.compile("Browser.addRoute");
        this.scriptReplacements[n++] = "Browser.currentScene.addRoute";
        this.scriptPatterns[n] = Pattern.compile("Browser.deleteRoute");
        this.scriptReplacements[n++] = "Browser.currentScene.deleteRoute";
        this.scriptPatterns[n] = Pattern.compile("Browser.getName\\p{Punct}\\p{Punct}");
        this.scriptReplacements[n++] = "Browser.name";
        this.scriptPatterns[n] = Pattern.compile("Browser.getVersion\\p{Punct}\\p{Punct}");
        this.scriptReplacements[n++] = "Browser.version";
        this.scriptPatterns[n] = Pattern.compile("Browser.getCurrentSpeed\\p{Punct}\\p{Punct}");
        this.scriptReplacements[n++] = "Browser.currentSpeed";
        this.scriptPatterns[n] = Pattern.compile("Browser.getCurrentFrameRate\\p{Punct}\\p{Punct}");
        this.scriptReplacements[n++] = "Browser.currentFrameRate";
        this.scriptPatterns[n] = Pattern.compile("Browser.getWorldURL\\p{Punct}\\p{Punct}");
        this.scriptReplacements[n++] = "Browser.currentScene.worldURL";
    }

    private void initOldProtos() {
        this.fieldRemap = new HashMap();
        this.hanimNodes = new HashMap();
        this.hanimNodes.put("Humanoid", "HAnimHumanoid");
        this.hanimNodes.put("Joint", "HAnimJoint");
        this.hanimNodes.put("Segment", "HAnimSegment");
        this.hanimNodes.put("Site", "HAnimSite");
        this.hanimNodes.put("Displacer", "HAnimDisplacer");
        this.geospatialNodes = new HashMap();
        Integer n = new Integer(5);
        Integer n2 = new Integer(12);
        this.geospatialNodes.put("GeoOrigin", "GeoOrigin");
        this.fieldRemap.put("GeoOrigin.geoCoords", n2);
        this.geospatialNodes.put("GeoViewpoint", "GeoViewpoint");
        this.fieldRemap.put("GeoViewpoint.position", n2);
        this.geospatialNodes.put("GeoLocation", "GeoLocation");
        this.fieldRemap.put("GeoLocation.geoCoords", n2);
        this.geospatialNodes.put("GeoLOD", "GeoLOD");
        this.geospatialNodes.put("GeoTouchSensor", "GeoTouchSensor");
        this.geospatialNodes.put("GeoElevationGrid", "GeoElevationGrid");
        this.fieldRemap.put("GeoElevationGrid.creaseAngle", n);
        this.fieldRemap.put("GeoElevationGrid.xSpacing", n);
        this.fieldRemap.put("GeoElevationGrid.zSpacing", n);
        this.fieldRemap.put("GeoElevationGrid.geoGridOrigin", n2);
        this.geospatialNodes.put("GeoMetadata", "GeoMetadata");
        this.geospatialNodes.put("GeoCoordinate", "GeoCoordinate");
        this.fieldRemap.put("GeoCoordinate.point", n2);
        this.geospatialNodes.put("GeoPositionInterpolator", "GeoPositionInterpolator");
        this.fieldRemap.put("GeoPositionInterpolator.keyValue", n2);
        this.oldProtos = new HashMap(this.hanimNodes.size() + this.geospatialNodes.size());
        this.oldProtos.putAll(this.hanimNodes);
        this.oldProtos.putAll(this.geospatialNodes);
    }

    protected void convertFieldData(int n, VRMLFieldData vRMLFieldData, VRMLFieldDeclaration vRMLFieldDeclaration) {
        switch (n) {
            case 5: {
                switch (vRMLFieldData.dataType) {
                    case 6: {
                        vRMLFieldData.doubleValue = this.fieldReader.SFDouble(vRMLFieldData.stringValue);
                        break;
                    }
                    case 4: {
                        vRMLFieldData.doubleValue = vRMLFieldData.floatValue;
                        break;
                    }
                    case 11: {
                        int n2 = vRMLFieldData.floatArrayValue.length;
                        vRMLFieldData.doubleArrayValue = new double[n2];
                        for (int i = 0; i < n2; ++i) {
                            vRMLFieldData.doubleArrayValue[i] = vRMLFieldData.floatArrayValue[i];
                        }
                        break;
                    }
                    default: {
                        System.out.println("Unhandled type conversion in convertFieldData:" + vRMLFieldDeclaration);
                        System.out.println("original type: " + vRMLFieldData.dataType);
                        return;
                    }
                }
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 12: {
                switch (vRMLFieldData.dataType) {
                    case 6: {
                        vRMLFieldData.doubleArrayValue = this.fieldReader.MFDouble(vRMLFieldData.stringValue);
                        break;
                    }
                    case 14: {
                        vRMLFieldData.doubleArrayValue = this.MFDouble(vRMLFieldData.stringArrayValue);
                        break;
                    }
                    case 11: {
                        int n3 = vRMLFieldData.floatArrayValue.length;
                        vRMLFieldData.doubleArrayValue = new double[n3];
                        for (int i = 0; i < n3; ++i) {
                            vRMLFieldData.doubleArrayValue[i] = vRMLFieldData.floatArrayValue[i];
                        }
                        break;
                    }
                    default: {
                        System.out.println("Unhandled type conversion in convertFieldData:" + vRMLFieldDeclaration);
                        System.out.println("original type: " + vRMLFieldData.dataType);
                        return;
                    }
                }
                vRMLFieldData.dataType = (short)12;
                break;
            }
            default: {
                System.out.println("Unhandled conversion in convertFieldData:" + vRMLFieldDeclaration);
            }
        }
    }

    private double[] MFDouble(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int n2 = 0;
        double[][] dArrayArray = new double[n][];
        int n3 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            dArrayArray[n3] = this.fieldReader.MFDouble(stringArray[n3]);
            n2 += dArrayArray[n3].length;
        }
        double[] dArray = new double[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            int n5 = dArrayArray[n3].length;
            System.arraycopy(dArrayArray[n3], 0, dArray, n4, n5);
            n4 += n5;
        }
        return dArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

