/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

public class FloatPacker {
    private static final int MANTISSA_BITS_32 = 23;
    private static final long EXPONENT_BITS_32 = 8L;
    private static final long MANTISSA_MASK_32 = 0x7FFFFFL;
    private static final long EXPONENT_MASK_32 = 2139095040L;
    private static final long SIGN_MASK_32 = Integer.MIN_VALUE;
    private static final int EXPONENT_BIAS_32 = 127;
    private static final int SIGN_SHIFT_32 = 31;
    private int exponent_bits;
    private int mantissa_bits;
    private int sign_mask;
    private int mantissa_mask;
    private int exponent_mask;
    private int exponent_bias;
    private int sign_shift;
    private int exponent_min;
    private int exponent_max;

    public FloatPacker(int n, int n2) {
        this.exponent_bits = n;
        this.mantissa_bits = n2;
        this.exponent_bias = (1 << this.exponent_bits - 1) - 1;
        this.sign_shift = this.exponent_bits + this.mantissa_bits;
        this.sign_mask = 1 << this.sign_shift;
        this.exponent_mask = (1 << this.exponent_bits) - 1 << this.mantissa_bits;
        this.mantissa_mask = (1 << this.mantissa_bits) - 1;
        this.exponent_max = (1 << this.exponent_bits - 1) - 1;
        this.exponent_min = -this.exponent_max - 1;
        if ((long)this.exponent_bits > 8L) {
            System.out.println("Too many exponent bits, max: 8");
            new Exception().printStackTrace();
            this.exponent_bits = 8;
        }
        if (this.mantissa_bits > 23) {
            System.out.println("Too man mantissa bits, max: 23");
            this.mantissa_bits = 23;
        }
    }

    public long encode(float f, boolean bl) {
        int n;
        int n2;
        if (f == 0.0f) {
            return 0L;
        }
        long l = Float.floatToIntBits(f);
        int n3 = 23 - this.mantissa_bits;
        long l2 = l & 0x7FFFFFL;
        int n4 = (int)(l & 0x7F800000L) >> 23;
        long l3 = l >> 31;
        n4 -= 127;
        if (bl && n3 != 0 && ((l2 += (long)(n2 = 1 << n3 - 1)) & (long)(n = 0x800000)) > 0L) {
            l2 = 0L;
            ++n4;
        }
        l2 >>= n3;
        if (n4 < this.exponent_min) {
            if (n4 < this.exponent_min - 1) {
                return 0L;
            }
            n4 = this.exponent_min;
        }
        if (n4 > this.exponent_max) {
            n4 = this.exponent_max;
        }
        long l4 = l3 << this.sign_shift | (long)((n4 -= this.exponent_min) << this.mantissa_bits) | l2;
        return l4;
    }

    public float decode(long l, boolean bl) {
        if (l == 0L) {
            return 0.0f;
        }
        long l2 = l & (long)this.mantissa_mask;
        int n = (int)(l & (long)this.exponent_mask) >> this.mantissa_bits;
        long l3 = l >> this.sign_shift;
        n += this.exponent_min;
        long l4 = bl ? l3 << 31 | (long)(n << 23) | l2 : (long)((n += 127) << 23) | (l2 <<= 23 - this.mantissa_bits);
        return Float.intBitsToFloat((int)l4);
    }
}

