/*
 * Decompiled with CFR 0.152.
 */
package pt.up.fe.dceg.neptus.util.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public abstract class OctetCharset
extends Charset {
    protected static final char REPLACEMENT = '\ufffd';
    private final char[] byte2char;
    private final char[][] char2byte;

    protected OctetCharset(String cname, String[] aliases, char[] byte2char) {
        super(cname, aliases);
        char[][] char2byte = new char[256][];
        int i = 0;
        while (i < 256) {
            char c = byte2char[i];
            if (c != '\ufffd') {
                int high = c >> 8;
                char[] table = char2byte[high];
                if (table == null) {
                    table = new char[256];
                    Arrays.fill(table, '\ufffd');
                    char2byte[high] = table;
                }
                table[c & 0xFF] = i;
            }
            i = (char)(i + 1);
        }
        this.byte2char = byte2char;
        this.char2byte = char2byte;
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        /*
         * WARNING - void declaration
         */
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            char[][] c2b = OctetCharset.this.char2byte;
            while (in.hasRemaining()) {
                void var6_6;
                char b;
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                char[] table = c2b[c >> 8];
                if (table == null || (b = table[c & 0xFF]) == '\ufffd') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put((byte)(var6_6 & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            char[] b2c = OctetCharset.this.byte2char;
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = b2c[in.get() & 0xFF];
                if (c == '\ufffd') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

