/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import org.web3d.vrml.export.X3DBinarySerializer;
import org.web3d.vrml.export.X3DXMLRetainedExporter;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.VRMLScene;

public class X3DBinaryRetainedExporter
extends X3DXMLRetainedExporter
implements SceneGraphTraversalSimpleObserver {
    private StringWriter writer;
    private OutputStream origStream;
    private int compressionMethod;
    private float quantizeParam;

    public X3DBinaryRetainedExporter(OutputStream outputStream, int n, int n2, int n3, float f) {
        super(new StringWriter(), n, n2);
        this.compressionMethod = n3;
        this.quantizeParam = f;
        if (n3 == 2) {
            this.useNC = true;
        }
        this.origStream = outputStream;
        this.printDocType = false;
        this.stripWhitespace = true;
        this.encodingTo = ".x3db";
    }

    public void writeScene(VRMLScene vRMLScene) {
        super.writeScene(vRMLScene);
        String string = ((StringWriter)this.filterWriter).toString();
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        X3DBinarySerializer x3DBinarySerializer = new X3DBinarySerializer(this.compressionMethod, false, this.quantizeParam);
        x3DBinarySerializer.setProtoMap(this.protoMap);
        x3DBinarySerializer.writeFiltered(stringBufferInputStream, this.origStream);
        try {
            this.origStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

