/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.util.IntHashMap;
import org.web3d.util.XMLTools;
import org.web3d.vrml.export.BaseRetainedExporter;
import org.web3d.vrml.export.compressors.NodeCompressor;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoInstancePlaceHolder;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRExternPrototypeDecl;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractDynamicFieldNode;
import org.web3d.vrml.sav.SAVException;

public class X3DXMLRetainedExporter
extends BaseRetainedExporter
implements SceneGraphTraversalSimpleObserver {
    private static String INDENT_STRING = "   ";
    private HashMap EMPTY_MAP = new HashMap();
    private int indent = 0;
    private String indentString;
    private IntHashMap indentMap;
    private HashSet usedNodes;
    protected PrintWriter p;
    protected Writer filterWriter;
    private HashSet protoDeclSet;
    private SceneGraphTraverser traverser;
    private VRMLWorldRootNodeType root;
    protected boolean printDocType;
    protected boolean useNC = false;
    private boolean ignoreData;
    protected HashMap protoMap;
    private NodeCompressor currentCompressor;
    private boolean compressedAttWay = false;

    public X3DXMLRetainedExporter(OutputStream outputStream, int n, int n2) {
        super(n, n2);
        this.init();
        this.p = new PrintWriter(outputStream, true);
    }

    public X3DXMLRetainedExporter(Writer writer, int n, int n2) {
        super(n, n2);
        this.init();
        this.filterWriter = writer;
        this.p = new PrintWriter(writer, true);
    }

    private void init() {
        this.usedNodes = new HashSet();
        this.indentString = "";
        this.indentMap = new IntHashMap();
        this.protoDeclSet = new HashSet();
        this.traverser = new SceneGraphTraverser();
        this.protoMap = new HashMap();
        this.encodingTo = ".x3d";
        this.printDocType = false;
        this.stripWhitespace = false;
        this.ignoreData = false;
    }

    public void writeScene(VRMLScene vRMLScene) {
        List list;
        this.usedNodes.clear();
        Map map = vRMLScene.getDEFNodes();
        this.currentDefMap = new HashMap(map.size());
        this.reverseMap(map, this.currentDefMap);
        Map map2 = this.currentDefMap;
        ArrayList arrayList = vRMLScene.getNodeTemplates();
        Iterator iterator = arrayList.iterator();
        this.root = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
        this.traverser.setObserver(this);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ExternalPrototypeDecl) {
                this.printExternalPrototypeDecl((CRExternPrototypeDecl)e);
                continue;
            }
            this.printPrototypeDecl((PrototypeDecl)e);
            list = ((AbstractProto)e).getAllFields();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator2.next();
                if (vRMLFieldDeclaration == null) continue;
                this.protoMap.put(((VRMLNodeTemplate)e).getVRMLNodeName() + "." + vRMLFieldDeclaration.getName(), vRMLFieldDeclaration);
            }
        }
        this.currentDefMap = map2;
        this.traverse(this.root, true);
        this.printImports(vRMLScene.getImports());
        list = vRMLScene.getRoutes();
        int n = ((ArrayList)list).size();
        for (int i = 0; i < n; ++i) {
            this.printROUTE((ROUTE)((ArrayList)list).get(i), this.currentDefMap);
        }
        this.printExports(vRMLScene.getExports());
        this.p.println("</Scene>");
        this.p.println("</X3D>");
        this.p.flush();
    }

    public void endDocument() throws SAVException, VRMLException {
        if (!this.processingDocument) {
            return;
        }
        this.processingDocument = false;
        super.endDocument();
        this.writeScene(this.scene);
    }

    public void printHeader(int n, int n2) {
        this.p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.printDocType) {
            this.p.print("<!DOCTYPE X3D PUBLIC ");
        }
        this.loadContainerProperties(n, n2);
    }

    public void printProfile(String string) {
        String string2 = this.getPublicId(this.majorVersion, this.minorVersion);
        String string3 = this.getSystemId(this.majorVersion, this.minorVersion);
        if (this.printDocType) {
            this.p.print("\"");
            this.p.print(string2);
            this.p.print("\" \"");
            this.p.print(string3);
            this.p.print("\">\n");
        }
        this.p.print("<X3D profile=\"");
        this.p.print(string);
        this.p.print("\" version=\"");
        this.p.print(this.majorVersion);
        this.p.print(".");
        this.p.print(this.minorVersion);
        this.p.print("\">\n");
    }

    public void printComponents(ComponentInfo[] componentInfoArray) {
        int n = componentInfoArray.length;
        this.p.println("<head>");
        for (int i = 0; i < n; ++i) {
            this.p.print("<component name=\"");
            this.p.print(componentInfoArray[i].getName());
            this.p.print("\" level=\"");
            this.p.print(componentInfoArray[i].getLevel());
            this.p.println("\" />");
        }
    }

    public void printMetaData(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        int n = entryArray.length;
        if (n > 0) {
            // empty if block
        }
        this.indentUp();
        for (int i = 0; i < n; ++i) {
            this.p.print(this.indentString);
            this.p.println("<meta name=\"" + entryArray[i].getKey() + "\" key=\"" + entryArray[i].getValue() + "\" />");
        }
        this.p.println("</head>\n");
        this.p.println("<Scene>");
    }

    public void printROUTE(ROUTE rOUTE, Map map) {
        VRMLNode vRMLNode = rOUTE.getSourceNode();
        VRMLNode vRMLNode2 = rOUTE.getDestinationNode();
        String string = (String)map.get(vRMLNode);
        String string2 = vRMLNode2 instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode2).getImportedName() : (String)map.get(vRMLNode2);
        string = vRMLNode instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode).getImportedName() : (String)map.get(vRMLNode);
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(rOUTE.getSourceIndex());
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNode2.getFieldDeclaration(rOUTE.getDestinationIndex());
        this.p.print(this.indentString);
        this.p.print("<ROUTE fromNode=\"");
        this.p.print(string);
        this.p.print("\"");
        this.p.print(" fromField=\"");
        this.p.print(vRMLFieldDeclaration.getName());
        this.p.print("\" toNode=\"");
        this.p.print(string2);
        this.p.print("\" toField=\"");
        this.p.print(vRMLFieldDeclaration2.getName());
        this.p.println("\"/>");
    }

    public void printExports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        for (int i = 0; i < entryArray.length; ++i) {
            String string = (String)entryArray[i].getValue();
            String string2 = (String)entryArray[i].getKey();
            this.p.print(this.indentString);
            this.p.print("<EXPORT localDEF=\"");
            this.p.print(string);
            this.p.print("\"");
            if (string2 != null && !string.equals(string2)) {
                this.p.print(" AS=\"");
                this.p.print(string2);
                this.p.print("\"/>");
                continue;
            }
            this.p.println("/>");
        }
    }

    public void printImports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        for (int i = 0; i < entryArray.length; ++i) {
            String string = (String)entryArray[i].getKey();
            Object v = entryArray[i].getValue();
            if (v instanceof String[]) {
                String[] stringArray = (String[])entryArray[i].getValue();
                this.p.print(this.indentString);
                this.p.print("<IMPORT inlineDEF=\"");
                this.p.print(stringArray[0]);
                this.p.print("\" exportedDEF=\"");
                this.p.print(stringArray[1]);
                this.p.print("\" AS=\"");
                this.p.print(string);
                this.p.println("\" />");
                continue;
            }
            ImportNodeProxy importNodeProxy = (ImportNodeProxy)v;
            this.p.print(this.indentString);
            this.p.print("<IMPORT inlineDEF=\"");
            this.p.print(importNodeProxy.getInlineDEFName());
            this.p.print("\" exportedDEF=\"");
            this.p.print(importNodeProxy.getExportedName());
            this.p.print("\" AS=\"");
            this.p.print(importNodeProxy.getImportedName());
            this.p.println("\" />");
        }
    }

    public void traverse(VRMLNode vRMLNode, boolean bl) {
        if (vRMLNode == null) {
            return;
        }
        if (bl) {
            this.recurseSimpleSceneGraphChild((VRMLNodeType)vRMLNode, false, false);
        } else {
            this.processSimpleNode(null, -1, (VRMLNodeType)vRMLNode, null);
        }
    }

    private void processSimpleNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, String string) {
        String string2;
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        String string3 = null;
        String string4 = vRMLNodeType2.getVRMLNodeName();
        if (this.convertOldContent && (string2 = (String)this.oldProtos.get(string4)) != null) {
            string4 = string2;
        }
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        this.indentUp();
        if (!(string == null || (string2 = (String)this.containerFields.get(string4)) != null && string2.equals(string))) {
            string3 = string;
        }
        if (bl) {
            string2 = (String)this.currentDefMap.get(vRMLNodeType2);
            if (string2 == null) {
                this.printDefMap(this.currentDefMap);
            }
            this.p.print(this.indentString);
            this.p.print("<");
            this.p.print(string4);
            this.p.print(" USE='");
            this.p.print(string2);
            this.p.print("' ");
            if (string3 != null) {
                this.p.print("containerField='");
                this.p.print(string3);
                this.p.print("' ");
            }
            this.p.print("/>");
            if (!this.stripWhitespace) {
                this.p.println();
            }
            this.indentDown();
        } else {
            boolean bl2 = false;
            if (this.useNC) {
                if (vRMLNodeType2.getVRMLNodeName().equals("IndexedFaceSet")) {
                    System.out.println("Using compression");
                    this.ignoreData = true;
                    bl2 = true;
                }
                if (vRMLNodeType2.getVRMLNodeName().equals("TriangleSet")) {
                    this.ignoreData = true;
                    bl2 = true;
                }
                if (vRMLNodeType2.getVRMLNodeName().equals("IndexedTriangleSet")) {
                    this.ignoreData = true;
                    bl2 = true;
                }
            }
            boolean bl3 = this.printStartNode(vRMLNodeType2, bl, this.currentDefMap, this.currentIsMap, string3, bl2);
            boolean bl4 = this.recurseSimpleSceneGraphChild(vRMLNodeType2, bl3, bl2);
            this.printEndNode(vRMLNodeType2, bl4, bl2, this.currentIsMap);
            if (bl2) {
                this.ignoreData = false;
                this.currentCompressor = null;
            }
        }
    }

    private boolean recurseSimpleSceneGraphChild(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2) {
        int[] nArray = vRMLNodeType.getNodeFieldIndices();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = vRMLNodeType.getFieldIndex("metadata");
        boolean bl6 = bl;
        String string = null;
        for (int i = 0; i < nArray.length; ++i) {
            VRMLFieldDeclaration vRMLFieldDeclaration;
            int n2;
            if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
                bl3 = true;
                bl6 = true;
            }
            bl4 = false;
            string = null;
            if (bl6 && i == n) {
                bl6 = false;
            }
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(nArray[i]);
            if (bl3 && i == n) {
                if (vRMLFieldData.nodeValue == null) continue;
                bl3 = false;
            }
            if (vRMLFieldData.dataType == 13) {
                VRMLFieldDeclaration vRMLFieldDeclaration2;
                if (vRMLFieldData.nodeArrayValue != null && vRMLFieldData.nodeArrayValue.length > 0) {
                    bl5 = true;
                } else if (bl) continue;
                if (bl6) {
                    vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(nArray[i]);
                    this.p.print(this.indentString);
                    if (bl3) {
                        n2 = vRMLFieldDeclaration2.getAccessType();
                        if (n2 == 2 || n2 == 3) {
                            bl4 = true;
                        }
                        this.printDeclNoValue(vRMLFieldDeclaration2);
                        this.p.print("name='");
                        this.p.print(vRMLFieldDeclaration2.getName());
                        this.p.print("'");
                    } else {
                        this.p.print(this.indentString);
                        this.p.print("<fieldValue ");
                        this.p.print("name='");
                        this.p.print(vRMLFieldDeclaration2.getName());
                        this.p.print("'");
                    }
                    if (vRMLFieldData.numElements > 0) {
                        this.p.println(">");
                    } else {
                        this.p.println("/>");
                    }
                } else {
                    vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(nArray[i]);
                    string = vRMLFieldDeclaration2.getName();
                }
                for (int j = 0; j < vRMLFieldData.numElements; ++j) {
                    if (vRMLFieldData.nodeArrayValue[j] == null || this.convertOldContent && vRMLFieldData.nodeArrayValue[j].getVRMLNodeName().equals("GeoOrigin") && !vRMLNodeType.getFieldDeclaration(nArray[i]).getName().equals("geoOrigin")) continue;
                    this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeArrayValue[j], string);
                }
                if (!bl6) continue;
                if (bl) {
                    if (vRMLFieldData.numElements == 0) continue;
                    this.p.println("</fieldValue>");
                    continue;
                }
                if (vRMLFieldData.numElements == 0) continue;
                this.p.println("</field>");
                continue;
            }
            if (nArray[i] == n && bl2) continue;
            if (vRMLFieldData.nodeValue != null) {
                bl5 = true;
            }
            if (vRMLFieldData.nodeValue == null && !bl3) continue;
            if (bl6) {
                vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                this.p.print(this.indentString);
                if (bl3) {
                    n2 = vRMLFieldDeclaration.getAccessType();
                    if (n2 == 2 || n2 == 3) {
                        bl4 = true;
                    }
                    this.printDeclNoValue(vRMLFieldDeclaration);
                    this.p.print("name='");
                    this.p.print(vRMLFieldDeclaration.getName());
                    this.p.print("'");
                } else {
                    this.p.print("<fieldValue name='");
                    this.p.print(vRMLFieldDeclaration.getName());
                    this.p.print("'");
                }
                if (vRMLFieldData.nodeValue == null && bl3) {
                    this.p.println("/>");
                    continue;
                }
                this.p.println(">");
            } else {
                vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                string = vRMLFieldDeclaration.getName();
            }
            this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeValue, string);
            if (!bl6) continue;
            if (bl) {
                this.p.println("</fieldValue>");
                continue;
            }
            this.p.println("</field>");
        }
        return bl5;
    }

    public void printStartScriptNode(AbstractDynamicFieldNode abstractDynamicFieldNode, boolean bl, Map map, Map map2) {
        VRMLFieldData vRMLFieldData;
        int n;
        VRMLFieldDeclaration vRMLFieldDeclaration;
        List list = abstractDynamicFieldNode.getAllFields();
        Iterator iterator = list.iterator();
        int n2 = abstractDynamicFieldNode.getFieldIndex("mustEvaluate");
        int n3 = abstractDynamicFieldNode.getFieldIndex("directOutput");
        int n4 = abstractDynamicFieldNode.getFieldIndex("url");
        int n5 = abstractDynamicFieldNode.getFieldIndex("metadata");
        while (iterator.hasNext()) {
            vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            if (vRMLFieldDeclaration == null) continue;
            n = abstractDynamicFieldNode.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = abstractDynamicFieldNode.getFieldValue(n);
            }
            catch (Exception exception) {
                System.out.println("Can't get field: " + vRMLFieldDeclaration.getName() + " for: " + abstractDynamicFieldNode);
                continue;
            }
            if (n == n5) continue;
            if (n == n2) {
                if (!vRMLFieldData.booleanValue) continue;
                this.p.print(" ");
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldData, vRMLFieldDeclaration, false, true);
                continue;
            }
            if (n == n3) {
                if (!vRMLFieldData.booleanValue) continue;
                this.p.print(" ");
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldData, vRMLFieldDeclaration, false, true);
                continue;
            }
            if (n != n4) continue;
        }
        this.p.print(">");
        this.p.println();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            if (vRMLFieldDeclaration == null) continue;
            n = abstractDynamicFieldNode.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = abstractDynamicFieldNode.getFieldValue(n);
            }
            catch (Exception exception) {
                System.out.println("Can't get field: " + vRMLFieldDeclaration.getName() + " for: " + abstractDynamicFieldNode);
                continue;
            }
            if (n == n5 || n == n2 || n == n3 || n == n4) continue;
            this.printScriptFieldDecl((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldDeclaration, n, vRMLFieldData, map, this.currentIsMap);
        }
        this.indentDown();
    }

    public boolean printStartNode(VRMLNodeType vRMLNodeType, boolean bl, Map map, Map map2, String string, boolean bl2) {
        String string2;
        int n;
        Object object;
        VRMLFieldDeclaration vRMLFieldDeclaration;
        Object object2;
        ArrayList<String[]> arrayList;
        int n2;
        Object object3;
        Object object4;
        String string3 = (String)map.get(vRMLNodeType);
        String string4 = vRMLNodeType.getVRMLNodeName();
        boolean bl3 = false;
        boolean bl4 = false;
        int[] nArray = vRMLNodeType.getNodeFieldIndices();
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            if (this.convertOldContent) {
                object4 = (String)this.oldProtos.get(string4);
                if (object4 != null) {
                    string4 = object4;
                } else {
                    bl4 = true;
                }
            } else {
                bl4 = true;
            }
        }
        this.p.print(this.indentString);
        if (bl4) {
            this.p.print("<ProtoInstance name='");
            this.p.print(string4);
            this.p.print("'");
        } else {
            this.p.print("<");
            this.p.print(string4);
        }
        if (string3 != null) {
            this.p.print(" DEF=\"");
            this.p.print(string3);
            this.p.print("\" ");
        }
        if (string != null) {
            this.p.print(" containerField='");
            this.p.print(string);
            this.p.print("'");
        }
        if (bl4) {
            this.p.println(">");
        }
        this.indentUp();
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            this.printStartScriptNode((AbstractDynamicFieldNode)vRMLNodeType, bl, map, map2);
            return false;
        }
        object4 = (VRMLNodeType)this.defaultNodes.get(string4);
        if (object4 == null && !(vRMLNodeType instanceof CRProtoInstance)) {
            object4 = (VRMLNodeType)this.nodeFactory.createVRMLNode(string4, false);
            if (object4 == null) {
                System.out.println("Could not create node: " + string4);
            }
            this.defaultNodes.put(string4, object4);
        }
        int n3 = vRMLNodeType.getNumFields();
        boolean bl5 = false;
        boolean bl6 = false;
        HashSet<Integer> hashSet = null;
        String string5 = null;
        if (vRMLNodeType instanceof VRMLExternalNodeType) {
            bl6 = true;
            string5 = ((VRMLExternalNodeType)((Object)vRMLNodeType)).getWorldUrl();
            hashSet = new HashSet<Integer>();
            if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
                hashSet.add(new Integer(vRMLNodeType.getFieldIndex("url")));
            } else {
                object3 = ((VRMLMultiExternalNodeType)((Object)vRMLNodeType)).getUrlFieldIndexes();
                for (n2 = 0; n2 < ((Object)object3).length; ++n2) {
                    hashSet.add(new Integer((int)object3[n2]));
                }
            }
        }
        if (this.upgrading && string4.equals("Inline")) {
            bl5 = true;
        }
        object3 = new ArrayList();
        if (vRMLNodeType instanceof AbstractProto) {
            List list = ((AbstractProto)vRMLNodeType).getAllFields();
            arrayList = list.iterator();
            while (arrayList.hasNext()) {
                object3.add(arrayList.next());
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList = vRMLNodeType.getFieldDeclaration(n2);
                object3.add(arrayList);
            }
        }
        Iterator iterator = object3.iterator();
        arrayList = new ArrayList<String[]>();
        int n4 = 0;
        while (iterator.hasNext()) {
            object2 = (VRMLFieldDeclaration)iterator.next();
            vRMLFieldDeclaration = null;
            if (object2 == null || (object = this.findIS(vRMLNodeType, n = vRMLNodeType.getFieldIndex(string2 = ((VRMLFieldDeclaration)object2).getName()), map2)) == null) continue;
            arrayList.add(new String[]{((VRMLFieldDeclaration)object2).getName(), object});
        }
        iterator = object3.iterator();
        if (bl2) {
            bl3 = true;
        }
        while (iterator.hasNext()) {
            int n5;
            String[] stringArray;
            VRMLFieldData vRMLFieldData;
            int n6;
            object2 = (VRMLFieldDeclaration)iterator.next();
            vRMLFieldDeclaration = null;
            if (object2 == null) continue;
            string2 = ((VRMLFieldDeclaration)object2).getName();
            n = vRMLNodeType.getFieldIndex(string2);
            if (object4 != null) {
                n4 = object4.getFieldIndex(string2);
                vRMLFieldDeclaration = object4.getFieldDeclaration(n4);
            }
            if ((object = this.findIS(vRMLNodeType, n, map2)) != null || this.ignoreData && (n6 = (int)(this.currentCompressor.handleData(string4, string2) ? 1 : 0)) != 0 || (n6 = ((VRMLFieldDeclaration)object2).getAccessType()) == 1 || n6 == 4) continue;
            try {
                vRMLFieldData = vRMLNodeType.getFieldValue(n);
            }
            catch (Exception exception) {
                System.out.println("Can't get field: " + ((VRMLFieldDeclaration)object2).getName() + " for: " + vRMLNodeType + " named: " + vRMLNodeType.getVRMLNodeName());
                System.out.println("Index: " + n);
                continue;
            }
            if (vRMLFieldData.dataType == 7) {
                if (vRMLFieldData.nodeValue == null) continue;
                bl3 = true;
                continue;
            }
            if (vRMLFieldData.dataType == 13) {
                if (vRMLFieldData.nodeArrayValue == null || vRMLFieldData.nodeArrayValue.length <= 0) continue;
                bl3 = true;
                continue;
            }
            if (object4 != null && this.isDefault(vRMLNodeType, (VRMLFieldDeclaration)object2, n4, vRMLFieldData, (VRMLNodeType)object4)) continue;
            this.p.print(" ");
            if (bl6 && hashSet.contains(new Integer(n)) && (stringArray = vRMLFieldData.stringArrayValue) != null && string5 != null) {
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    if (stringArray[n5] == null || !stringArray[n5].startsWith(string5)) continue;
                    stringArray[n5] = stringArray[n5].substring(string5.length());
                }
                vRMLFieldData.stringArrayValue = stringArray;
            }
            if (bl5 && ((VRMLFieldDeclaration)object2).getName().equals("url") && (stringArray = vRMLFieldData.stringArrayValue) != null) {
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    int n7 = stringArray[n5].indexOf(".wrl");
                    if (n7 < 0) continue;
                    stringArray[n5] = stringArray[n5].substring(0, n7);
                    stringArray[n5] = stringArray[n5] + this.encodingTo;
                }
                vRMLFieldData.stringArrayValue = stringArray;
            }
            this.printFieldValue(vRMLNodeType, vRMLFieldData, (VRMLFieldDeclaration)object2, bl4, !bl4);
        }
        if (bl2 && this.compressedAttWay) {
            System.out.println("Compressing node: " + vRMLNodeType);
            this.p.print(" encoder='1' ");
            object2 = this.currentCompressor.compress(vRMLNodeType);
            this.p.print("data='");
            for (int i = 0; i < ((Object)object2).length; ++i) {
                this.p.print((int)object2[i]);
                this.p.print(" ");
            }
            this.p.print("'");
        }
        if (bl3 && !bl4) {
            this.p.print(">");
            if (!this.stripWhitespace) {
                this.p.println();
            }
            this.printISList(arrayList);
        } else if (!bl4) {
            if (arrayList.size() > 0) {
                this.p.println(">");
                this.printISList(arrayList);
                this.p.print(this.indentString);
                this.p.print("</");
                this.p.print(string4);
                this.p.println(">");
            } else {
                this.p.print(" />");
                if (!this.stripWhitespace) {
                    this.p.println();
                }
            }
        } else {
            this.printISList(arrayList);
        }
        if (bl2 && !this.compressedAttWay) {
            System.out.println("Compressing node: " + vRMLNodeType);
            this.p.print(this.indentString);
            this.p.println("<MetadataSet name='.x3db'>");
            this.indentUp();
            object2 = null;
            int n8 = vRMLNodeType.getFieldIndex("metadata");
            object = vRMLNodeType.getFieldValue(n8);
            if (((VRMLFieldData)object).nodeValue != null) {
                System.out.println("Printing original metadata");
                this.ignoreData = false;
                this.processSimpleNode(null, -1, (VRMLNodeType)((VRMLFieldData)object).nodeValue, "metadata");
                this.ignoreData = true;
            }
            this.p.print(this.indentString);
            this.p.print("<MetadataInteger name='encoding'");
            this.p.println(" value='1'/>");
            int[] nArray2 = this.currentCompressor.compress(vRMLNodeType);
            this.p.print(this.indentString);
            this.p.print("<MetadataInteger name='payload'");
            this.p.print(" value='");
            for (int i = 0; i < nArray2.length; ++i) {
                this.p.print(nArray2[i]);
                this.p.print(" ");
            }
            this.p.println("'/>");
            String string6 = this.currentCompressor.getEncoderMetadata();
            if (string6 != null) {
                this.p.println("<MetadataSet name='Encoder Metadata' >");
                this.p.print(this.indentString);
                this.p.println(string6);
                this.p.println("</MetadataSet>");
            }
            this.indentDown();
            this.p.print(this.indentString);
            this.p.println("</MetadataSet>");
        }
        this.indentDown();
        return bl4;
    }

    public void printEndNode(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2, Map map) {
        Object object;
        Object object2 = vRMLNodeType.getVRMLNodeName();
        boolean bl3 = false;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            if (this.convertOldContent) {
                object = (String)this.oldProtos.get(object2);
                if (object != null) {
                    object2 = object;
                } else {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        }
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            Object object3;
            object = ((AbstractDynamicFieldNode)vRMLNodeType).getAllFields();
            Iterator iterator = object.iterator();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (iterator.hasNext()) {
                int n;
                VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
                if (vRMLFieldDeclaration == null || (object3 = this.findIS(vRMLNodeType, n = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName()), map)) == null || object3 == null) continue;
                arrayList.add(new String[]{vRMLFieldDeclaration.getName(), object3});
            }
            this.printISList(arrayList);
            this.indentUp();
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
            object3 = null;
            try {
                object3 = vRMLNodeType.getFieldValue(n);
            }
            catch (Exception exception) {
                System.out.println("Can't get field: " + vRMLFieldDeclaration.getName() + " for: " + vRMLNodeType + " named: " + vRMLNodeType.getVRMLNodeName());
                System.out.println("Index: " + n);
            }
            if (this.upgrading) {
                String[] stringArray = new String[((VRMLFieldData)object3).stringArrayValue.length];
                boolean bl4 = false;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = ((VRMLFieldData)object3).stringArrayValue[i];
                    if (!bl4 && (stringArray[i].startsWith("javascript:") || stringArray[i].startsWith("vrmlscript:"))) {
                        stringArray[i] = "ecmascript:" + stringArray[i].substring(11);
                        bl4 = true;
                    }
                    int n3 = this.scriptPatterns.length;
                    for (int j = 0; j < n3; ++j) {
                        stringArray[i] = this.scriptPatterns[j].matcher(stringArray[i]).replaceAll(this.scriptReplacements[j]);
                    }
                }
                ((VRMLFieldData)object3).stringArrayValue = stringArray;
            }
            this.p.print(this.indentString);
            this.p.println("<![CDATA[");
            this.indentUp();
            for (int i = 0; i < ((VRMLFieldData)object3).stringArrayValue.length; ++i) {
                this.p.print(this.indentString);
                this.p.println(((VRMLFieldData)object3).stringArrayValue[i]);
            }
            this.indentDown();
            this.p.print(this.indentString);
            this.p.println("]]>");
            this.indentDown();
            this.p.print(this.indentString);
            this.p.print("</");
            this.p.print((String)object2);
            this.p.print(">");
            if (!this.stripWhitespace) {
                this.p.println();
            }
            this.indentDown();
            return;
        }
        if (bl3) {
            this.p.print(this.indentString);
            this.p.println("</ProtoInstance>");
        } else if (bl) {
            this.p.print(this.indentString);
            this.p.print("</");
            this.p.print((String)object2);
            this.p.print(">");
            if (!this.stripWhitespace) {
                this.p.println();
            }
        }
        this.indentDown();
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        if (vRMLNodeType2 instanceof ProtoInstancePlaceHolder) {
            this.protoDeclSet.add(((ProtoInstancePlaceHolder)vRMLNodeType2).getProtoDefinition());
        }
    }

    public void printPrototypeDecl(PrototypeDecl prototypeDecl) {
        int n;
        this.currentDefMap = new HashMap();
        Map map = this.currentDefMap;
        this.reverseMap(prototypeDecl.getDEFMap(), this.currentDefMap);
        this.currentIsMap = prototypeDecl.getISMaps();
        this.currentPrototypeDecl = prototypeDecl;
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
        String string = prototypeDecl.getVRMLNodeName();
        VRMLNode vRMLNode = this.protoCreator.newInstance((VRMLNodeTemplate)prototypeDecl, (VRMLExecutionSpace)this.root, this.majorVersion, this.minorVersion, false);
        this.defaultNodes.put(prototypeDecl.getVRMLNodeName(), vRMLNode);
        if (this.convertOldContent && this.oldProtos.get(string) != null) {
            return;
        }
        this.p.print(this.indentString);
        this.p.print("<ProtoDeclare name='");
        this.p.print(string);
        this.p.println("' >");
        this.indentUp();
        this.p.print(this.indentString);
        this.p.println("<ProtoInterface>");
        this.indentUp();
        List list = prototypeDecl.getAllFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            int n2 = prototypeDecl.getFieldIndex(vRMLFieldDeclaration.getName());
            VRMLFieldData vRMLFieldData = null;
            int n3 = vRMLFieldDeclaration.getAccessType();
            if (n3 != 1 && n3 != 4) {
                vRMLFieldData = prototypeDecl.getFieldValue(n2);
                bl = true;
            } else {
                bl = false;
            }
            if (vRMLFieldDeclaration.getName().equals("metadata") && (vRMLFieldData == null || vRMLFieldData.nodeValue == null)) continue;
            this.printProtoFieldDecl(vRMLFieldDeclaration, n2, vRMLFieldData, this.currentDefMap, this.currentIsMap, bl);
        }
        this.indentDown();
        this.p.print(this.indentString);
        this.p.println("</ProtoInterface>");
        this.p.print(this.indentString);
        this.p.println("<ProtoBody>");
        this.protoDeclSet.clear();
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.traverser.reset();
            this.traverser.traverseGraph(vRMLNodeTypeArray[i]);
        }
        PrototypeDecl[] prototypeDeclArray = new PrototypeDecl[this.protoDeclSet.size()];
        this.protoDeclSet.toArray(prototypeDeclArray);
        for (n = 0; n < prototypeDeclArray.length; ++n) {
            this.printPrototypeDecl(prototypeDeclArray[n]);
        }
        this.currentDefMap = map;
        this.currentIsMap = prototypeDecl.getISMaps();
        this.currentPrototypeDecl = prototypeDecl;
        for (n = 0; n < vRMLNodeTypeArray.length; ++n) {
            this.traverse(vRMLNodeTypeArray[n], false);
        }
        this.printImports(prototypeDecl.getImportDecls());
        Set set = prototypeDecl.getRouteDecls();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            this.printROUTE((ROUTE)iterator2.next(), this.currentDefMap);
        }
        this.p.print(this.indentString);
        this.p.println("</ProtoBody>");
        this.indentDown();
        this.p.print(this.indentString);
        this.p.println("</ProtoDeclare>");
    }

    public void printExternalPrototypeDecl(CRExternPrototypeDecl cRExternPrototypeDecl) {
        this.currentDefMap = new HashMap();
        String string = cRExternPrototypeDecl.getVRMLNodeName();
        if (this.convertOldContent && this.oldProtos.get(string) != null) {
            return;
        }
        this.p.print(this.indentString);
        this.p.print("<ExternProtoDeclare name='");
        this.p.print(string);
        this.p.print("' ");
        String[] stringArray = (String[])this.epToUrl.get(cRExternPrototypeDecl.getVRMLNodeName());
        this.p.print("url='");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            this.p.print("\"");
            if (this.upgrading && (n2 = stringArray[i].indexOf(".wrl")) >= 0) {
                stringArray[i] = stringArray[i].substring(0, n2);
                stringArray[i] = stringArray[i] + this.encodingTo;
            }
            this.p.print(stringArray[i]);
            this.p.print("\"");
            if (i == n - 1) continue;
            this.p.println();
        }
        this.p.println("' >");
        this.indentUp();
        List list = cRExternPrototypeDecl.getAllFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            int n3 = cRExternPrototypeDecl.getFieldIndex(vRMLFieldDeclaration.getName());
            Object var9_11 = null;
            if (vRMLFieldDeclaration.getName().equals("metadata")) continue;
            this.printProtoFieldDecl(vRMLFieldDeclaration, n3, null, this.currentDefMap, this.currentIsMap, false);
        }
        this.indentDown();
        this.p.print(this.indentString);
        this.p.println("</ExternProtoDeclare>");
    }

    private boolean isMFField(VRMLFieldDeclaration vRMLFieldDeclaration) {
        int n = vRMLFieldDeclaration.getFieldType();
        return n % 2 == 0;
    }

    private void indentUp() {
        ++this.indent;
        if (this.stripWhitespace) {
            return;
        }
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
            this.indentMap.put(this.indent, this.indentString);
        }
    }

    private void indentDown() {
        --this.indent;
        if (this.stripWhitespace) {
            return;
        }
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
        }
    }

    private void printProtoFieldDecl(VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2, boolean bl) {
        this.p.print(this.indentString);
        this.p.print("<field accessType='");
        int n2 = vRMLFieldDeclaration.getAccessType();
        switch (n2) {
            case 2: {
                this.p.print("initializeOnly' ");
                break;
            }
            case 3: {
                this.p.print("inputOutput' ");
                break;
            }
            case 1: {
                this.p.print("inputOnly' ");
                break;
            }
            case 4: {
                this.p.print("outputOnly' ");
                break;
            }
            default: {
                System.out.println("Unknown field type in X3DClassicExporter: " + n2);
            }
        }
        this.p.print("type='");
        this.p.print(vRMLFieldDeclaration.getFieldTypeString());
        this.p.print("' name='");
        this.p.print(vRMLFieldDeclaration.getName());
        this.p.print("' ");
        if (vRMLFieldData != null) {
            switch (vRMLFieldData.dataType) {
                case 7: {
                    VRMLNode vRMLNode = vRMLFieldData.nodeValue;
                    if (vRMLNode == null) {
                        this.p.println("/>");
                        break;
                    }
                    this.traverse(vRMLNode, false);
                    this.p.print(this.indentString);
                    this.p.println("</field>");
                    break;
                }
                case 13: {
                    this.p.println(">");
                    VRMLNode[] vRMLNodeArray = vRMLFieldData.nodeArrayValue;
                    int n3 = vRMLNodeArray.length;
                    this.indentUp();
                    for (int i = 0; i < n3; ++i) {
                        this.p.print(this.indentString);
                        this.traverse(vRMLNodeArray[i], false);
                    }
                    this.indentDown();
                    this.p.print(this.indentString);
                    this.p.println("</field>");
                    break;
                }
                default: {
                    this.printFieldValue(null, vRMLFieldData, vRMLFieldDeclaration, false, false);
                    this.p.println(" />");
                    break;
                }
            }
        } else {
            if (bl) {
                this.printFieldValue(null, vRMLFieldData, vRMLFieldDeclaration, false, false);
            }
            this.p.println(" />");
        }
    }

    private void printDeclNoValue(VRMLFieldDeclaration vRMLFieldDeclaration) {
        int n = vRMLFieldDeclaration.getAccessType();
        this.p.print("<field accessType='");
        switch (n) {
            case 2: {
                this.p.print("initializeOnly");
                break;
            }
            case 3: {
                this.p.print("inputOutput");
                break;
            }
            case 1: {
                this.p.print("inputOnly");
                break;
            }
            case 4: {
                this.p.print("outputOnly");
                break;
            }
            default: {
                System.out.println("Unknown field type in X3DClassicExporter: " + n);
            }
        }
        this.p.print("' type='");
        this.p.print(vRMLFieldDeclaration.getFieldTypeString());
        this.p.print("' ");
    }

    private void printScriptFieldDecl(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2) {
        String string = this.findIS(vRMLNodeType, n, map2);
        if (vRMLFieldData != null && (vRMLFieldData.dataType == 7 || vRMLFieldData.dataType == 13)) {
            return;
        }
        this.p.print(this.indentString);
        this.printDeclNoValue(vRMLFieldDeclaration);
        this.p.print("name='");
        this.p.print(vRMLFieldDeclaration.getName());
        this.p.print("'");
        int n2 = vRMLFieldDeclaration.getAccessType();
        if (n2 == 1 || n2 == 4) {
            this.p.println("/>");
            return;
        }
        if (vRMLFieldData != null) {
            switch (vRMLFieldData.dataType) {
                case 7: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    this.printFieldValue(vRMLNodeType, vRMLFieldData, vRMLFieldDeclaration, false, false);
                    this.p.println(" />");
                }
            }
        }
    }

    private boolean isDefault(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, VRMLNodeType vRMLNodeType2) {
        VRMLFieldData vRMLFieldData2;
        try {
            vRMLFieldData2 = vRMLNodeType2.getFieldValue(n);
        }
        catch (Exception exception) {
            System.out.println("Can't get field: " + vRMLFieldDeclaration.getName() + " for: " + vRMLNodeType + " named: " + vRMLNodeType.getVRMLNodeName());
            System.out.println("Index: " + n);
            return false;
        }
        if (vRMLFieldData == null) {
            return true;
        }
        boolean bl = true;
        block1 : switch (vRMLFieldData.dataType) {
            case 1: {
                if (vRMLFieldData2.booleanValue == vRMLFieldData.booleanValue) break;
                bl = false;
                break;
            }
            case 2: {
                if (vRMLFieldData2.intValue == vRMLFieldData.intValue) break;
                bl = false;
                break;
            }
            case 3: {
                if (vRMLFieldData2.longValue == vRMLFieldData.longValue) break;
                bl = false;
                break;
            }
            case 4: {
                if (vRMLFieldData2.floatValue == vRMLFieldData.floatValue) break;
                bl = false;
                break;
            }
            case 5: {
                if (vRMLFieldData2.doubleValue == vRMLFieldData.doubleValue) break;
                bl = false;
                break;
            }
            case 6: {
                if (vRMLFieldData2.stringValue == vRMLFieldData.stringValue) break;
                bl = false;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (vRMLFieldData2.booleanArrayValue == null && vRMLFieldData.booleanArrayValue == null) break;
                if (vRMLFieldData2.booleanArrayValue == null || vRMLFieldData.booleanArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.booleanArrayValue.length != vRMLFieldData.booleanArrayValue.length) {
                    bl = false;
                    break;
                }
                int n2 = vRMLFieldData2.booleanArrayValue.length;
                for (int i = 0; i < n2; ++i) {
                    if (vRMLFieldData2.booleanArrayValue[i] == vRMLFieldData.booleanArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 9: {
                if (vRMLFieldData2.intArrayValue == null && vRMLFieldData.intArrayValue == null) break;
                if (vRMLFieldData2.intArrayValue == null || vRMLFieldData.intArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.intArrayValue.length != vRMLFieldData.intArrayValue.length) {
                    bl = false;
                    break;
                }
                int n3 = vRMLFieldData2.intArrayValue.length;
                for (int i = 0; i < n3; ++i) {
                    if (vRMLFieldData2.intArrayValue[i] == vRMLFieldData.intArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 10: {
                if (vRMLFieldData2.longArrayValue == null && vRMLFieldData.longArrayValue == null) break;
                if (vRMLFieldData2.longArrayValue == null || vRMLFieldData.longArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.longArrayValue.length != vRMLFieldData.longArrayValue.length) {
                    bl = false;
                    break;
                }
                int n4 = vRMLFieldData2.longArrayValue.length;
                for (int i = 0; i < n4; ++i) {
                    if (vRMLFieldData2.longArrayValue[i] == vRMLFieldData.longArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 11: {
                if (vRMLFieldData2.floatArrayValue == null && vRMLFieldData.floatArrayValue == null) break;
                if (vRMLFieldData2.floatArrayValue == null || vRMLFieldData.floatArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.floatArrayValue.length != vRMLFieldData.floatArrayValue.length) {
                    bl = false;
                    break;
                }
                int n5 = vRMLFieldData2.floatArrayValue.length;
                for (int i = 0; i < n5; ++i) {
                    if (vRMLFieldData2.floatArrayValue[i] == vRMLFieldData.floatArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 12: {
                if (vRMLFieldData2.doubleArrayValue == null && vRMLFieldData.doubleArrayValue == null) break;
                if (vRMLFieldData2.doubleArrayValue == null || vRMLFieldData.doubleArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.doubleArrayValue.length != vRMLFieldData.doubleArrayValue.length) {
                    bl = false;
                    break;
                }
                int n6 = vRMLFieldData2.doubleArrayValue.length;
                for (int i = 0; i < n6; ++i) {
                    if (vRMLFieldData2.doubleArrayValue[i] == vRMLFieldData.doubleArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (vRMLFieldData2.stringArrayValue == null && vRMLFieldData.stringArrayValue == null) break;
                if (vRMLFieldData2.stringArrayValue == null || vRMLFieldData.stringArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.stringArrayValue.length != vRMLFieldData.stringArrayValue.length) {
                    bl = false;
                    break;
                }
                int n7 = vRMLFieldData2.stringArrayValue.length;
                for (int i = 0; i < n7; ++i) {
                    if (vRMLFieldData2.stringArrayValue[i] == null && vRMLFieldData.stringArrayValue[i] == null) continue;
                    if (vRMLFieldData2.stringArrayValue[i] == null || vRMLFieldData.stringArrayValue[i] == null) {
                        bl = false;
                        break block1;
                    }
                    if (vRMLFieldData2.stringArrayValue[i].equals(vRMLFieldData.stringArrayValue[i])) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
        }
        return bl;
    }

    private void printFieldValue(VRMLNodeType vRMLNodeType, VRMLFieldData vRMLFieldData, VRMLFieldDeclaration vRMLFieldDeclaration, boolean bl, boolean bl2) {
        String string;
        Integer n;
        if (vRMLFieldData == null) {
            int n2 = vRMLFieldDeclaration.getFieldType();
            if (n2 == 27) {
                this.p.print(" value=''");
            }
            return;
        }
        if (this.convertOldContent && vRMLNodeType != null && (n = (Integer)this.fieldRemap.get(string = vRMLNodeType.getVRMLNodeName() + "." + vRMLFieldDeclaration.getName())) != null) {
            int n3 = n;
            this.convertFieldData(n3, vRMLFieldData, vRMLFieldDeclaration);
        }
        if (bl) {
            this.p.print("<fieldValue name='");
            this.p.print(vRMLFieldDeclaration.getName());
            this.p.print("'");
        }
        if (vRMLFieldData.dataType == 13 || vRMLFieldData.dataType == 7) {
            this.p.print(" >");
            return;
        }
        if (bl) {
            this.p.print(" value='");
        } else if (bl2) {
            this.p.print(vRMLFieldDeclaration.getName());
            this.p.print("='");
        } else {
            this.p.print(" value='");
        }
        switch (vRMLFieldData.dataType) {
            case 1: {
                if (vRMLFieldData.booleanValue) {
                    this.p.print("true");
                    break;
                }
                this.p.print("false");
                break;
            }
            case 2: {
                this.p.print(vRMLFieldData.intValue);
                break;
            }
            case 3: {
                this.p.print(vRMLFieldData.longValue);
                break;
            }
            case 4: {
                this.p.print(vRMLFieldData.floatValue);
                break;
            }
            case 5: {
                this.p.print(vRMLFieldData.doubleValue);
                break;
            }
            case 6: {
                if (vRMLFieldData.stringValue == null) break;
                this.p.print(XMLTools.XML.escape(vRMLFieldData.stringValue));
                break;
            }
            case 8: {
                int n4 = vRMLFieldData.numElements;
                for (int i = 0; i < n4; ++i) {
                    if (i == n4 - 1) {
                        if (vRMLFieldData.booleanArrayValue[i]) {
                            this.p.print("true");
                            continue;
                        }
                        this.p.print("false");
                        continue;
                    }
                    if (vRMLFieldData.booleanArrayValue[i]) {
                        this.p.print("true,");
                        continue;
                    }
                    this.p.print("false,");
                }
                break;
            }
            case 9: {
                int n5 = vRMLFieldData.numElements;
                for (int i = 0; i < n5; ++i) {
                    if (i == n5 - 1) {
                        this.p.print(vRMLFieldData.intArrayValue[i]);
                        continue;
                    }
                    this.p.print(vRMLFieldData.intArrayValue[i]);
                    this.p.print(" ");
                }
                break;
            }
            case 10: {
                int n6 = vRMLFieldData.numElements;
                for (int i = 0; i < n6; ++i) {
                    if (i == n6 - 1) {
                        this.p.print(vRMLFieldData.longArrayValue[i]);
                        continue;
                    }
                    this.p.print(vRMLFieldData.longArrayValue[i]);
                    this.p.print(" ");
                }
                break;
            }
            case 11: {
                boolean bl3 = this.isMFField(vRMLFieldDeclaration);
                if (bl3) {
                    int n7 = vRMLFieldData.numElements;
                    if (n7 <= 0) break;
                    int n8 = vRMLFieldData.floatArrayValue.length / n7;
                    int n9 = 0;
                    for (int i = 0; i < n7; ++i) {
                        for (int j = 0; j < n8; ++j) {
                            this.p.print(vRMLFieldData.floatArrayValue[n9++]);
                            if (j == n8 - 1) continue;
                            this.p.print(" ");
                        }
                        if (i == n7 - 1) continue;
                        this.p.print(" ,");
                    }
                } else {
                    int n10 = vRMLFieldData.floatArrayValue.length;
                    for (int i = 0; i < n10; ++i) {
                        this.p.print(vRMLFieldData.floatArrayValue[i]);
                        if (i == n10 - 1) continue;
                        this.p.print(" ");
                    }
                }
                break;
            }
            case 12: {
                boolean bl4 = this.isMFField(vRMLFieldDeclaration);
                if (bl4) {
                    int n11 = vRMLFieldData.numElements;
                    int n12 = vRMLFieldData.doubleArrayValue.length / n11;
                    if (n11 <= 0) break;
                    int n13 = 0;
                    for (int i = 0; i < n11; ++i) {
                        for (int j = 0; j < n12; ++j) {
                            this.p.print(vRMLFieldData.doubleArrayValue[n13++]);
                            if (j == n12 - 1) continue;
                            this.p.print(" ");
                        }
                        if (i == n11 - 1) continue;
                        this.p.print(" ,");
                    }
                } else {
                    int n14 = vRMLFieldData.doubleArrayValue.length;
                    for (int i = 0; i < n14; ++i) {
                        this.p.print(vRMLFieldData.doubleArrayValue[i]);
                        if (i == n14 - 1) continue;
                        this.p.print(" ");
                    }
                }
                break;
            }
            case 14: {
                if (vRMLFieldData.stringArrayValue == null) break;
                int n15 = vRMLFieldData.numElements;
                for (int i = 0; i < n15; ++i) {
                    if (i == n15 - 1) {
                        this.p.print("\"");
                        this.p.print(XMLTools.XML.escape(vRMLFieldData.stringArrayValue[i]));
                        this.p.print("\"");
                        continue;
                    }
                    this.p.print("\"");
                    this.p.print(XMLTools.XML.escape(vRMLFieldData.stringArrayValue[i]));
                    this.p.print("\",");
                }
                break;
            }
        }
        this.p.print("'");
        if (bl) {
            this.p.println(" />");
        }
    }

    private void printISList(List list) {
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            this.p.print(this.indentString);
            this.p.println("<IS>");
            this.indentUp();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                this.p.print(this.indentString);
                this.p.print("<connect nodeField='");
                this.p.print(stringArray[0]);
                this.p.print("' protoField='");
                this.p.print(stringArray[1]);
                this.p.println("' />");
            }
            this.indentDown();
            this.p.print(this.indentString);
            this.p.println("</IS>");
        }
    }
}

