/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alliance;

import de.baderjene.aistoolkit.aisparser.message.Message01;
import de.baderjene.aistoolkit.aisparser.message.Message03;
import de.baderjene.aistoolkit.aisparser.message.Message05;
import pt.lsts.neptus.types.coord.LocationType;

public class AisContact {
    private int mmsi;
    private double sog = 0.0;
    private double cog = 0.0;
    private String label = null;
    private long lastUpdate = 0L;
    private LocationType loc = new LocationType();
    private Message05 additionalProperties = null;

    public LocationType getLocation() {
        return this.loc;
    }

    public AisContact(int mmsi) {
        System.out.println("Created AIS contact for mmsi " + mmsi);
        this.mmsi = mmsi;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void update(Message01 m) {
        this.lastUpdate = System.currentTimeMillis();
        this.loc.setLatitudeDegs(m.getLatitude());
        this.loc.setLongitudeDegs(m.getLongitude());
        this.cog = m.getTrueHeading();
        this.sog = m.getSpeedOverGround();
        if (this.label == null) {
            this.label = "" + m.getSourceMmsi();
        }
    }

    public void update(Message03 m) {
        this.lastUpdate = System.currentTimeMillis();
        this.loc.setLatitudeDegs(m.getLatitude());
        this.loc.setLongitudeDegs(m.getLongitude());
        this.cog = m.getTrueHeading();
        this.sog = m.getSpeedOverGround();
        if (this.label == null) {
            this.label = "" + m.getSourceMmsi();
        }
    }

    public void update(Message05 m) {
        this.lastUpdate = System.currentTimeMillis();
        this.label = m.getVesselName();
        this.additionalProperties = m;
    }

    public long ageMillis() {
        return System.currentTimeMillis() - this.lastUpdate;
    }

    public int getMmsi() {
        return this.mmsi;
    }

    public double getSog() {
        return this.sog;
    }

    public double getCog() {
        return this.cog;
    }

    public String getLabel() {
        return this.label == null ? null : this.label.trim();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSog(double sog) {
        this.sog = sog;
    }

    public void setCog(double cog) {
        this.cog = cog;
    }

    public void setLocation(LocationType loc) {
        this.loc = loc;
    }

    public Message05 getAdditionalProperties() {
        return this.additionalProperties;
    }
}

