/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alliance;

import de.baderjene.aistoolkit.aisparser.AISObserver;
import de.baderjene.aistoolkit.aisparser.message.Message;
import de.baderjene.aistoolkit.aisparser.message.Message01;
import de.baderjene.aistoolkit.aisparser.message.Message03;
import de.baderjene.aistoolkit.aisparser.message.Message05;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.plugins.alliance.AisContact;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.systems.external.ExternalSystemsHolder;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.NMEAUtils;

public class AisContactDb
implements AISObserver {
    private LinkedHashMap<Integer, AisContact> contacts = new LinkedHashMap();
    private LinkedHashMap<Integer, String> labelCache = new LinkedHashMap();
    File cache = new File("conf/ais.cache");
    private String lastGGA = null;

    public AisContactDb() {
        if (!this.cache.canRead()) {
            return;
        }
        int count = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.cache));
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(",");
                int mmsi = Integer.parseInt(parts[0]);
                String name = parts[1].trim();
                this.labelCache.put(mmsi, name);
                line = reader.readLine();
                ++count;
            }
            reader.close();
            System.out.println("Read " + count + " vessel names from " + this.cache.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveCache() {
        int count = 0;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.cache));
            for (Map.Entry<Integer, String> entry : this.labelCache.entrySet()) {
                writer.write(entry.getKey() + "," + entry.getValue() + "\n");
                ++count;
            }
            writer.close();
            System.out.println("Wrote " + count + " vessel names to " + this.cache.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processGGA(String sentence) {
        this.lastGGA = sentence;
    }

    public void processRattm(String sentence) {
        AisContact contact;
        if (this.lastGGA == null) {
            return;
        }
        LocationType myLoc = NMEAUtils.processGGASentence((String)this.lastGGA);
        String[] parts = sentence.trim().split(",");
        double heading = Double.parseDouble(parts[3]);
        double dist = Double.parseDouble(parts[2]) * 1852.0;
        LocationType newLoc = new LocationType(myLoc);
        newLoc.setAzimuth(heading);
        newLoc.setOffsetDistance(dist);
        newLoc.convertToAbsoluteLatLonDepth();
        String id = parts[11];
        Integer rid = Integer.parseInt(parts[1]);
        if (id.isEmpty()) {
            id = "radar-" + parts[1];
        }
        if (ImcSystemsHolder.getSystemWithName((String)id) != null && ImcSystemsHolder.getSystemWithName((String)id).isActive()) {
            return;
        }
        if (!this.contacts.containsKey(rid)) {
            contact = new AisContact(rid);
            this.contacts.put(rid, contact);
        }
        contact = this.contacts.get(rid);
        contact.setLocation(newLoc);
        contact.setLabel(id);
    }

    public void processBtll(String sentence) {
        AisContact contact;
        String[] parts = sentence.replaceFirst("\\*\\w\\w$", "").trim().split(",");
        int mmsi = Integer.parseInt(parts[1]);
        double lat = 0.0;
        double lon = 0.0;
        try {
            lat = NMEAUtils.nmeaLatOrLongToWGS84((String)parts[2]);
            lon = NMEAUtils.nmeaLatOrLongToWGS84((String)parts[4]);
            if (parts[3].equals("S")) {
                lat = -lat;
            }
            if (parts[5].equals("W")) {
                lon = -lon;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)("Unable to parse coordinates in " + sentence));
            return;
        }
        String id = parts[6];
        if (ImcSystemsHolder.getSystemWithName((String)id) != null && ImcSystemsHolder.getSystemWithName((String)id).isActive()) {
            return;
        }
        double heading = 0.0;
        try {
            heading = Double.parseDouble(parts[9]);
        }
        catch (Exception e) {
            // empty catch block
        }
        LocationType loc = new LocationType(lat, lon);
        if (!this.contacts.containsKey(mmsi)) {
            contact = new AisContact(mmsi);
            this.contacts.put(mmsi, contact);
        }
        contact = this.contacts.get(mmsi);
        contact.setLocation(loc);
        contact.setCog(heading);
        contact.setLabel(id);
        if (ImcSystemsHolder.getSystemWithName((String)id) == null) {
            this.updateSystem(mmsi, loc, heading);
        }
    }

    public void updateSystem(int mmsi, LocationType loc, double heading) {
        String name = this.contacts.get(mmsi).getLabel();
        if (name.equals("" + mmsi)) {
            return;
        }
        ExternalSystem sys = ExternalSystemsHolder.lookupSystem((String)name);
        if (sys == null) {
            sys = new ExternalSystem(name);
            ExternalSystemsHolder.registerSystem((ExternalSystem)sys);
        }
        sys.setLocation(this.contacts.get(mmsi).getLocation());
        sys.setAttitudeDegrees(this.contacts.get(mmsi).getCog());
        sys.setType(VehicleType.SystemTypeEnum.UNKNOWN);
    }

    public synchronized void update(Message arg0) {
        int mmsi = arg0.getSourceMmsi();
        switch (arg0.getType()) {
            case 1: {
                if (!this.contacts.containsKey(mmsi)) {
                    this.contacts.put(mmsi, new AisContact(mmsi));
                }
                this.contacts.get(mmsi).update((Message01)arg0);
                if (this.labelCache.containsKey(mmsi)) {
                    this.contacts.get(mmsi).setLabel(this.labelCache.get(mmsi));
                }
                this.updateSystem(mmsi, this.contacts.get(mmsi).getLocation(), this.contacts.get(mmsi).getCog());
                break;
            }
            case 3: {
                if (!this.contacts.containsKey(mmsi)) {
                    this.contacts.put(mmsi, new AisContact(mmsi));
                }
                this.contacts.get(mmsi).update((Message03)arg0);
                if (this.labelCache.containsKey(mmsi)) {
                    this.contacts.get(mmsi).setLabel(this.labelCache.get(mmsi));
                }
                this.updateSystem(mmsi, this.contacts.get(mmsi).getLocation(), this.contacts.get(mmsi).getCog());
                break;
            }
            case 5: {
                if (!this.contacts.containsKey(mmsi)) {
                    this.contacts.put(mmsi, new AisContact(mmsi));
                }
                this.contacts.get(mmsi).update((Message05)arg0);
                String name = ((Message05)arg0).getVesselName();
                this.labelCache.put(mmsi, name);
                this.updateSystem(mmsi, this.contacts.get(mmsi).getLocation(), this.contacts.get(mmsi).getCog());
                break;
            }
            default: {
                System.err.println("Ignoring AIS message of type " + arg0.getType());
            }
        }
    }

    public synchronized void purge(long maximumAgeMillis) {
        Vector<Integer> toRemove = new Vector<Integer>();
        for (Map.Entry<Integer, AisContact> entry : this.contacts.entrySet()) {
            if (entry.getValue().ageMillis() <= maximumAgeMillis) continue;
            toRemove.add(entry.getKey());
        }
        Iterator<Map.Entry<Integer, AisContact>> i$ = toRemove.iterator();
        while (i$.hasNext()) {
            int rem = (Integer)((Object)i$.next());
            System.out.println("Removing " + rem + " because is more than " + maximumAgeMillis + " milliseconds old.");
            this.contacts.remove(rem);
        }
    }

    public Collection<AisContact> getContacts() {
        Vector<AisContact> c = new Vector<AisContact>();
        c.addAll(this.contacts.values());
        return c;
    }
}

