/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alliance;

import com.google.common.eventbus.Subscribe;
import de.baderjene.aistoolkit.aisparser.AISObserver;
import de.baderjene.aistoolkit.aisparser.AISParser;
import de.baderjene.aistoolkit.aisparser.message.Message05;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.JMenuItem;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import pt.lsts.imc.DevDataText;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.alliance.AisContact;
import pt.lsts.neptus.plugins.alliance.AisContactDb;
import pt.lsts.neptus.plugins.alliance.NmeaListener;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NMEAUtils;

@PluginDescription(name="NMEA Plotter")
public class NmeaPlotter
extends ConsoleLayer {
    @NeptusProperty(name="Connect to the serial port")
    public boolean serialListen = false;
    @NeptusProperty(name="Serial Port Device")
    public String uartDevice = "/dev/ttyUSB0";
    @NeptusProperty(name="Serial Port Baud Rate")
    public int uartBaudRate = 38400;
    @NeptusProperty(name="Serial Port Data Bits")
    public int dataBits = 8;
    @NeptusProperty(name="Serial Port Stop Bits")
    public int stopBits = 1;
    @NeptusProperty(name="Serial Port Parity Bits")
    public int parity = 0;
    @NeptusProperty(name="UDP port to bind")
    public int udpPort = 7878;
    @NeptusProperty(name="Listen for incoming UDP packets")
    public boolean udpListen = true;
    @NeptusProperty(name="Maximum age in for AIS contacts (seconds)")
    public int maximumAisAge = 600;
    @NeptusProperty(name="Use Neptus external systems API", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean useExternalSystemsApi = true;
    @NeptusProperty(name="Retransmit to other Neptus consoles", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean retransmitToNeptus = true;
    @NeptusProperty(name="Log received data", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public boolean logReceivedData = true;
    @NeptusProperty(name="Number of track points", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public int trackPoints = 100;
    private JMenuItem connectItem = null;
    private boolean connected = false;
    GeneralPath ship = new GeneralPath();
    private SerialPort serialPort;
    private HashSet<NmeaListener> listeners;
    private AisContactDb contactDb;
    private AISParser parser;
    private LinkedHashMap<String, LocationType> lastLocs;
    private LinkedHashMap<String, ScatterPointsElement> tracks;

    public NmeaPlotter() {
        this.ship.moveTo(0.0, 1.0);
        this.ship.lineTo(1.0, 0.6);
        this.ship.lineTo(1.0, -1.0);
        this.ship.lineTo(-1.0, -1.0);
        this.ship.lineTo(-1.0, 0.6);
        this.ship.lineTo(0.0, 1.0);
        this.serialPort = null;
        this.listeners = new HashSet();
        this.contactDb = new AisContactDb();
        this.parser = new AISParser();
        this.lastLocs = new LinkedHashMap();
        this.tracks = new LinkedHashMap();
    }

    @Periodic(millisBetweenUpdates=5000)
    public void updateTracks() {
        for (AisContact c : this.contactDb.getContacts()) {
            LocationType l = c.getLocation();
            String name = c.getLabel();
            if (this.lastLocs.get(name) != null && this.lastLocs.get(name).equals((Object)l)) continue;
            if (!this.tracks.containsKey(name)) {
                ScatterPointsElement sc = new ScatterPointsElement();
                sc.setCenterLocation(l);
                sc.setColor(Color.black, Color.gray.brighter());
                sc.setNumberOfPoints(this.trackPoints);
                this.tracks.put(name, sc);
            }
            this.tracks.get(name).addPoint(l);
        }
    }

    private void connectToSerial() throws Exception {
        this.serialPort = new SerialPort(this.uartDevice);
        boolean opened = this.serialPort.openPort();
        if (!opened) {
            throw new Exception("Unable to open port " + this.uartDevice);
        }
        this.serialPort.addEventListener(new SerialPortEventListener(){
            private String currentString = "";

            public void serialEvent(SerialPortEvent arg0) {
                try {
                    String s = NmeaPlotter.this.serialPort.readString();
                    if (s.contains("\n")) {
                        this.currentString = this.currentString + s.substring(0, s.indexOf(10));
                        if (!this.currentString.trim().isEmpty()) {
                            for (NmeaListener l : NmeaPlotter.this.listeners) {
                                l.nmeaSentence(this.currentString.trim());
                            }
                            NmeaPlotter.this.parseSentence(this.currentString);
                            if (NmeaPlotter.this.retransmitToNeptus) {
                                NmeaPlotter.this.retransmit(this.currentString);
                            }
                            if (NmeaPlotter.this.logReceivedData) {
                                LsfMessageLogger.log((IMCMessage)new DevDataText(this.currentString));
                            }
                        }
                        this.currentString = s.substring(s.indexOf(10) + 1);
                    } else {
                        this.currentString = this.currentString + s;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.serialPort.setParams(this.uartBaudRate, this.dataBits, this.stopBits, this.parity);
    }

    private void retransmit(String sentence) {
        DevDataText ddt = new DevDataText(sentence);
        for (ImcSystem s : ImcSystemsHolder.lookupSystemByType((VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.CCU)) {
            ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)ddt, s.getName());
        }
    }

    @Subscribe
    public void on(DevDataText ddt) {
        this.parseSentence(ddt.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSentence(String s) {
        String nmeaType = NMEAUtils.nmeaType((String)(s = s.trim()));
        if (nmeaType.equals("$B-TLL") || nmeaType.equals("$A-TLL")) {
            this.contactDb.processBtll(s);
        } else if (nmeaType.equals("$GPGGA")) {
            this.contactDb.processGGA(s);
        } else if (nmeaType.equals("$RATTM")) {
            this.contactDb.processRattm(s);
        } else {
            AISParser aISParser = this.parser;
            synchronized (aISParser) {
                this.parser.process(s);
            }
        }
    }

    private void connect() throws Exception {
        if (this.serialListen) {
            this.connectToSerial();
        }
        if (this.udpListen) {
            final DatagramSocket socket = new DatagramSocket(this.udpPort);
            Thread listener = new Thread("NmeaListener"){

                @Override
                public void run() {
                    NmeaPlotter.this.connected = true;
                    NeptusLog.pub().info((Object)"Listening to NMEA messages over UDP.");
                    while (NmeaPlotter.this.connected) {
                        try {
                            DatagramPacket dp = new DatagramPacket(new byte[65507], 65507);
                            socket.receive(dp);
                            String sentence = new String(dp.getData());
                            sentence = sentence.substring(0, sentence.indexOf(0));
                            NmeaPlotter.this.parseSentence(sentence);
                            if (NmeaPlotter.this.retransmitToNeptus) {
                                NmeaPlotter.this.retransmit(sentence);
                            }
                            if (!NmeaPlotter.this.logReceivedData) continue;
                            LsfMessageLogger.log((IMCMessage)new DevDataText(sentence));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    NeptusLog.pub().info((Object)"UDP Socket closed.");
                    socket.close();
                }
            };
            listener.setDaemon(true);
            listener.start();
        }
    }

    public void disconnect() throws Exception {
        if (this.serialListen) {
            this.serialPort.closePort();
        }
        this.connected = false;
    }

    public void addListener(NmeaListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NmeaListener listener) {
        this.listeners.remove(listener);
    }

    public void cleanLayer() {
        if (this.serialPort != null) {
            try {
                this.serialPort.closePort();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    public boolean userControlsOpacity() {
        return false;
    }

    @Periodic(millisBetweenUpdates=60000)
    public void purgeOldContacts() {
        this.contactDb.purge(this.maximumAisAge * 1000);
    }

    @Periodic(millisBetweenUpdates=120000)
    public void saveCache() {
        this.contactDb.saveCache();
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        ArrayList<ScatterPointsElement> els = new ArrayList<ScatterPointsElement>();
        els.addAll(this.tracks.values());
        for (ScatterPointsElement el : els) {
            el.paint((Graphics2D)g.create(), renderer, renderer.getRotation());
        }
        for (AisContact c : this.contactDb.getContacts()) {
            LocationType l = c.getLocation();
            if (l.getLatitudeDegs() == 0.0 && l.getLongitudeDegs() == 0.0) continue;
            Point2D pt = renderer.getScreenPosition(l);
            g.setColor(new Color(64, 124, 192));
            g.drawString(c.getLabel(), (int)pt.getX() + 17, (int)pt.getY() + 2);
            if (c.getAdditionalProperties() != null) {
                g.setColor(new Color(64, 124, 192, 128));
                Message05 m = c.getAdditionalProperties();
                Graphics2D copy = (Graphics2D)g.create();
                double width = m.getDimensionToPort() + m.getDimensionToStarboard();
                double length = m.getDimensionToStern() + m.getDimensionToBow();
                double centerX = pt.getX();
                double centerY = pt.getY();
                copy.translate(centerX, centerY);
                copy.rotate(Math.PI + Math.toRadians(c.getCog()) - renderer.getRotation());
                copy.scale(renderer.getZoom(), renderer.getZoom());
                copy.scale(width / 2.0, length / 2.0);
                copy.fill(this.ship);
                copy.scale(1.0 / (width / 2.0), 1.0 / (length / 2.0));
            }
            g.setColor(Color.black);
            g.fill(new Ellipse2D.Double((int)pt.getX() - 3, (int)pt.getY() - 3, 6.0, 6.0));
        }
    }

    public void initLayer() {
        this.connectItem = this.getConsole().addMenuItem(I18n.text((String)"Tools") + ">" + I18n.text((String)"NMEA Plotter") + ">" + I18n.text((String)"Connect"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!NmeaPlotter.this.connected) {
                        NmeaPlotter.this.connect();
                        NmeaPlotter.this.connected = true;
                        NmeaPlotter.this.connectItem.setText(I18n.text((String)"Disconnect"));
                    } else {
                        NmeaPlotter.this.disconnect();
                        NmeaPlotter.this.connected = false;
                        NmeaPlotter.this.connectItem.setText(I18n.text((String)"Connect"));
                    }
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)NmeaPlotter.this.getConsole(), (Exception)ex);
                }
            }
        });
        this.getConsole().addMenuItem(I18n.text((String)"Tools") + ">" + I18n.text((String)"NMEA Plotter") + ">" + I18n.text((String)"Settings"), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUtils.editPluginProperties((Object)((Object)NmeaPlotter.this), (boolean)true);
            }
        });
        this.parser.register((AISObserver)this.contactDb);
    }
}

