/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.efolaga;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.IPlanFileExporter;
import pt.lsts.neptus.types.mission.plan.PlanType;

@PluginDescription
public class KmlPlanExporter
implements IPlanFileExporter {
    public String getExporterName() {
        return "KML (eFolaga)";
    }

    private String placemark(String id, ManeuverLocation loc) {
        loc.convertToAbsoluteLatLonDepth();
        StringBuilder sb = new StringBuilder();
        sb.append("  <Placemark>\n");
        sb.append("    <name>" + id + "</name>\n");
        sb.append("    <description>going-to.string=FIXED_CONSTANT_DEPTH_UPDATES=depth=" + Math.abs(loc.getZ()) + "</description>\n");
        sb.append("    <Point>\n");
        sb.append(String.format("      <coordinates>%.5f,%.5f,0.</coordinates>\n", loc.getLongitudeDegs(), loc.getLatitudeDegs()));
        sb.append("    </Point>\n");
        sb.append("  </Placemark>\n");
        return sb.toString();
    }

    public void exportToFile(PlanType plan, File out, ProgressMonitor monitor) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(out));
        writer.write(this.header(plan));
        block6: for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            switch (m.getType()) {
                case "Goto": {
                    writer.write(this.placemark(m.getId(), ((Goto)m).getEndLocation()));
                    continue block6;
                }
            }
        }
        writer.write(this.footer(plan));
        writer.close();
    }

    private String header(PlanType plan) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sb.append("<kml xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\" xmlns:kml=\"http://www.opengis.net/kml/2.2\">\n");
        sb.append("<Document>\n");
        sb.append("  <name>Neptus plan '" + plan.getId() + "'</name>\n");
        return sb.toString();
    }

    private String footer(PlanType plan) {
        return "</Document>\n</kml>\n";
    }

    public String[] validExtensions() {
        return new String[]{"kml"};
    }

    public static void main(String[] args) throws Exception {
        KmlPlanExporter exporter = new KmlPlanExporter();
        MissionType mt = new MissionType("/home/zp/workspace/neptus/missions/APDL/missao-apdl.nmisz");
        PlanType pt = (PlanType)mt.getIndividualPlansList().get("folaga_plan");
        exporter.exportToFile(pt, new File("/home/zp/Desktop/out.kml"), null);
    }
}

