/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gpx;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.vecmath.Point3d;
import org.alternativevision.gpx.GPXParser;
import org.alternativevision.gpx.beans.GPX;
import org.alternativevision.gpx.beans.Track;
import org.alternativevision.gpx.beans.Waypoint;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="GPX Support")
public class GpxImportExport
extends ConsolePanel {
    private static final long serialVersionUID = 1L;

    public GpxImportExport(ConsoleLayout console) {
        super(console);
    }

    public void cleanSubPanel() {
    }

    private MapType getMap(MissionType mt) {
        MapGroup mg = MapGroup.getMapGroupInstance((MissionType)mt);
        return mg.getMaps()[0];
    }

    private void addPath(Collection<LocationType> points, String name) {
        if (points.isEmpty()) {
            return;
        }
        MissionType mission = this.getConsole().getMission();
        MapType map = this.getMap(mission);
        MapGroup mg = MapGroup.getMapGroupInstance((MissionType)mission);
        AbstractElement existing = null;
        AbstractElement[] elems = mg.getMapObjectsByID(name);
        if (elems != null && elems.length > 0) {
            existing = elems[0];
        }
        PathElement el = new PathElement();
        if (existing != null) {
            NeptusLog.pub().warn((Object)("Object with name " + name + " was replaced."));
            existing.getParentMap().remove(name);
        }
        el.setCenterLocation(points.iterator().next());
        for (LocationType loc : points) {
            double[] offsets = loc.getOffsetFrom(el.getCenterLocation());
            el.addPoint(offsets[1], offsets[0], 0.0, false);
        }
        el.setFilled(false);
        el.addPoint(0.0, 0.0, 0.0, false);
        el.setMyColor(Color.magenta);
        el.setId(name);
        map.addObject((AbstractElement)el);
    }

    private void addMark(LocationType loc, String name) {
        MissionType mission = this.getConsole().getMission();
        MapType map = this.getMap(mission);
        MapGroup mg = MapGroup.getMapGroupInstance((MissionType)mission);
        AbstractElement existing = null;
        AbstractElement[] elems = mg.getMapObjectsByID(name);
        if (elems != null && elems.length > 0) {
            existing = elems[0];
        }
        MarkElement el = new MarkElement(map.getMapGroup(), map);
        if (existing != null) {
            if (existing instanceof MarkElement) {
                el = (MarkElement)existing;
                NeptusLog.pub().warn((Object)("Object with name " + name + " got a position update"));
            } else {
                NeptusLog.pub().warn((Object)("Object with name " + name + " was removed from the map"));
                existing.getParentMap().remove(name);
            }
        }
        el.setId(name);
        el.setCenterLocation(loc);
        map.addObject((AbstractElement)el);
    }

    public void initSubPanel() {
        this.addMenuItem("Tools>GPX>Import", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Select GPX file to import");
                chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)"GPX files", (String[])new String[]{"gpx"}));
                int op = chooser.showOpenDialog((Component)GpxImportExport.this.getConsole());
                if (op != 0) {
                    return;
                }
                try {
                    GPXParser parser = new GPXParser();
                    GPX gpx = parser.parseGPX((InputStream)new FileInputStream(chooser.getSelectedFile()));
                    for (Waypoint wpt : gpx.getWaypoints()) {
                        LocationType loc = new LocationType(wpt.getLatitude().doubleValue(), wpt.getLongitude().doubleValue());
                        GpxImportExport.this.addMark(loc, wpt.getName());
                    }
                    for (Track t : gpx.getTracks()) {
                        Vector<LocationType> locs = new Vector<LocationType>();
                        for (Waypoint wpt : t.getTrackPoints()) {
                            locs.add(new LocationType(wpt.getLatitude().doubleValue(), wpt.getLongitude().doubleValue()));
                        }
                        GpxImportExport.this.addPath(locs, t.getName());
                    }
                    GpxImportExport.this.getConsole().getMission().save(true);
                    GpxImportExport.this.getConsole().warnMissionListeners();
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)GpxImportExport.this.getConsole(), (Exception)ex);
                }
            }
        });
        this.addMenuItem("Tools>GPX>Export", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Select GPX file to export");
                    chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)"GPX files", (String[])new String[]{"gpx"}));
                    int op = chooser.showSaveDialog((Component)GpxImportExport.this.getConsole());
                    if (op != 0) {
                        return;
                    }
                    GPX gpx = new GPX();
                    MapGroup map = MapGroup.getMapGroupInstance((MissionType)GpxImportExport.this.getConsole().getMission());
                    for (MarkElement el : map.getAllObjectsOfType(MarkElement.class)) {
                        Waypoint wpt = new Waypoint();
                        LocationType loc = new LocationType(el.getCenterLocation());
                        loc.convertToAbsoluteLatLonDepth();
                        wpt.setLatitude(Double.valueOf(loc.getLatitudeDegs()));
                        wpt.setLongitude(Double.valueOf(loc.getLongitudeDegs()));
                        wpt.setName(el.getId());
                        gpx.addWaypoint(wpt);
                    }
                    for (MarkElement el : map.getAllObjectsOfType(PathElement.class)) {
                        Track t = new Track();
                        t.setName(el.getId());
                        ArrayList<Waypoint> wpts = new ArrayList<Waypoint>();
                        for (Point3d p : el.getPoints()) {
                            LocationType loc = new LocationType(el.getCenterLocation());
                            loc.translatePosition(p.x, p.y, 0.0);
                            loc.convertToAbsoluteLatLonDepth();
                            Waypoint wpt = new Waypoint();
                            wpt.setLatitude(Double.valueOf(loc.getLatitudeDegs()));
                            wpt.setLongitude(Double.valueOf(loc.getLongitudeDegs()));
                            wpts.add(wpt);
                        }
                        t.setTrackPoints(wpts);
                        gpx.addTrack(t);
                    }
                    gpx.setCreator("Neptus");
                    GPXParser parser = new GPXParser();
                    parser.writeGPX(gpx, (OutputStream)new FileOutputStream(chooser.getSelectedFile()));
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)GpxImportExport.this.getConsole(), (Exception)ex);
                }
            }
        });
    }
}

