/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.calib;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.imc.DevCalibrationControl;
import pt.lsts.imc.DevCalibrationState;
import pt.lsts.imc.EntityList;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;

@Popup(accelerator=121, width=400, height=250)
@PluginDescription(name="Device Calibration", icon="pt/lsts/neptus/plugins/calib/calib.png")
public class CalibrationSubPanel
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    protected JButton btnStart;
    protected JButton btnStop = new JButton(I18n.text((String)"Cancel"));
    protected JButton btnNext = new JButton(I18n.text((String)"Next Step") + " >");
    protected JButton btnPrev = new JButton("< " + I18n.text((String)"Previous Step"));
    protected JEditorPane calibText;
    protected JPanel bottom;
    protected int calibratingEntity = -1;
    protected JComboBox<String> entitySelection = null;

    public CalibrationSubPanel(ConsoleLayout cl) {
        super(cl);
        this.initializeInterface();
    }

    @Subscribe
    public void on(EntityList list) {
        try {
            if (list.getSourceName() == null || !list.getSourceName().equals(this.getMainVehicleId())) {
                return;
            }
            if (this.entitySelection == null) {
                Object[] entities = list.getList().keySet().toArray(new String[0]);
                Arrays.sort(entities);
                this.entitySelection = new JComboBox<Object>(entities);
                this.entitySelection.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DevCalibrationControl cmd = new DevCalibrationControl();
                        CalibrationSubPanel.this.calibratingEntity = EntitiesResolver.resolveId((String)CalibrationSubPanel.this.getMainVehicleId(), (String)(CalibrationSubPanel.this.entitySelection.getSelectedItem() + ""));
                        cmd.setDstEnt(CalibrationSubPanel.this.calibratingEntity);
                        cmd.setOp(DevCalibrationControl.OP.START);
                        CalibrationSubPanel.this.send((IMCMessage)cmd);
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalibrationSubPanel.this.add(CalibrationSubPanel.this.entitySelection, "North");
                        CalibrationSubPanel.this.invalidate();
                        CalibrationSubPanel.this.validate();
                        CalibrationSubPanel.this.repaint();
                        CalibrationSubPanel.this.calibText.setText(I18n.text((String)"Select entity to be calibrated"));
                    }
                });
            }
        }
        catch (Exception e) {
            NeptusLog.pub().fatal((Object)(e.getMessage() + " :: main system=" + this.getMainVehicleId()), (Throwable)e);
        }
    }

    @Subscribe
    public void on(ConsoleEventMainSystemChange change) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CalibrationSubPanel.this.entitySelection != null) {
                    CalibrationSubPanel.this.remove(CalibrationSubPanel.this.entitySelection);
                }
                CalibrationSubPanel.this.entitySelection = null;
                CalibrationSubPanel.this.invalidate();
                CalibrationSubPanel.this.validate();
                CalibrationSubPanel.this.repaint();
                CalibrationSubPanel.this.calibratingEntity = -1;
            }
        });
    }

    @Subscribe
    public void on(DevCalibrationState state) {
        if (state.getSourceName().equals(this.getMainVehicleId()) && state.getSrcEnt() == this.calibratingEntity) {
            this.calibText.setText(state.getStep());
        }
        this.btnNext.setEnabled((state.getFlags() & 2) == 0);
        this.btnPrev.setEnabled((state.getFlags() & 1) == 0);
        this.btnStop.setEnabled((state.getFlags() & 0x10) == 0);
    }

    protected void initializeInterface() {
        this.setLayout(new BorderLayout());
        this.calibText = new JEditorPane();
        this.calibText.setEditable(false);
        this.calibText.setText(I18n.text((String)"Waiting for vehicle..."));
        this.calibText.setFont(new Font("Arial", 1, 16));
        this.calibText.setBorder(BorderFactory.createBevelBorder(1));
        this.add(this.calibText, "Center");
        this.bottom = new JPanel(new GridLayout(1, 0));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevCalibrationControl cmd = new DevCalibrationControl();
                CalibrationSubPanel.this.calibratingEntity = EntitiesResolver.resolveId((String)CalibrationSubPanel.this.getMainVehicleId(), (String)(CalibrationSubPanel.this.entitySelection.getSelectedItem() + ""));
                cmd.setDstEnt(CalibrationSubPanel.this.calibratingEntity);
                cmd.setOp(DevCalibrationControl.OP.STEP_PREVIOUS);
                CalibrationSubPanel.this.send((IMCMessage)cmd);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevCalibrationControl cmd = new DevCalibrationControl();
                CalibrationSubPanel.this.calibratingEntity = EntitiesResolver.resolveId((String)CalibrationSubPanel.this.getMainVehicleId(), (String)(CalibrationSubPanel.this.entitySelection.getSelectedItem() + ""));
                cmd.setDstEnt(CalibrationSubPanel.this.calibratingEntity);
                cmd.setOp(DevCalibrationControl.OP.STEP_NEXT);
                CalibrationSubPanel.this.send((IMCMessage)cmd);
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevCalibrationControl cmd = new DevCalibrationControl();
                CalibrationSubPanel.this.calibratingEntity = EntitiesResolver.resolveId((String)CalibrationSubPanel.this.getMainVehicleId(), (String)(CalibrationSubPanel.this.entitySelection.getSelectedItem() + ""));
                cmd.setDstEnt(CalibrationSubPanel.this.calibratingEntity);
                cmd.setOp(DevCalibrationControl.OP.STOP);
                CalibrationSubPanel.this.send((IMCMessage)cmd);
                CalibrationSubPanel.this.calibratingEntity = -1;
                CalibrationSubPanel.this.calibText.setText(I18n.text((String)"Select entity to be calibrated"));
            }
        });
        this.bottom.add(this.btnPrev);
        this.bottom.add(this.btnStop);
        this.bottom.add(this.btnNext);
        this.btnPrev.setEnabled(false);
        this.btnStop.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.add(this.bottom, "South");
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

