/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.blueeye;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Dialog;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.blueeye.PlanBlueprint;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Blue Eye Planning", description="This plugin listens for Plan Blueprints and generates respective Neptus plans")
public class BlueEyePlanner
extends ConsolePanel {
    private static final long serialVersionUID = 1378142356540460721L;

    public BlueEyePlanner(ConsoleLayout cl) {
        super(cl);
    }

    @Subscribe
    public void on(PlanBlueprint plan) {
        if (this.getConsole().getMission().getIndividualPlansList().containsKey(plan.getPlanId())) {
            NeptusLog.pub().warn((Object)("Received an event for an already existing PlanBluePrint: " + plan.getPlanId()));
            return;
        }
        PlanType pt = plan.generate();
        pt.setMissionType(this.getConsole().getMission());
        this.getConsole().getMission().addPlan(pt);
        this.getConsole().warnMissionListeners();
        this.getConsole().getMission().save(true);
        GuiUtils.infoMessage((Component)this.getConsole(), (String)"Plan received from web", (String)("The plan '" + plan.getPlanId() + "' was downloaded from web and added to the mission."), (Dialog.ModalityType)Dialog.ModalityType.APPLICATION_MODAL);
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

