/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.blueeye;

import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class PlanBlueprint {
    private String planId;
    private String systemId;
    private Vector<Waypoint> trajectory = new Vector();

    public PlanBlueprint(int imcid, String planId) {
        this.systemId = ImcSystemsHolder.lookupSystem((ImcId16)new ImcId16((long)imcid)).getName();
        this.planId = planId;
    }

    public void addPoint(double latDegrees, double lonDegrees, double depthMeters) {
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeDegs(latDegrees);
        loc.setLongitudeDegs(lonDegrees);
        if (depthMeters >= 0.0) {
            loc.setZ(depthMeters);
            loc.setZUnits(ManeuverLocation.Z_UNITS.DEPTH);
        } else {
            loc.setZ(-depthMeters);
            loc.setZUnits(ManeuverLocation.Z_UNITS.ALTITUDE);
        }
        this.trajectory.add(new Waypoint(loc));
    }

    public PlanType generate() {
        PlanType plan = new PlanType(null);
        plan.setId(this.planId);
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.systemId);
        plan.setVehicle(sys.getName());
        Vector<Object> maneuvers = new Vector<Object>();
        FollowPath current = null;
        ManeuverLocation lastLoc = null;
        int count = 1;
        for (Waypoint wpt : this.trajectory) {
            lastLoc = wpt.coordinates;
            if (current == null || wpt.coordinates.getZUnits() != current.getStartLocation().getZUnits()) {
                current = (FollowPath)plan.getVehicleType().getManeuverFactory().getManeuver("FollowPath");
                current.setId("" + count);
                ++count;
                Vector<double[]> points = new Vector<double[]>();
                points.add(new double[]{0.0, 0.0, 0.0, 0.0});
                current.setOffsets(points);
                maneuvers.add(current);
                current.setManeuverLocation(wpt.coordinates);
                continue;
            }
            double[] offsets = wpt.coordinates.getOffsetFrom((LocationType)current.getManeuverLocation());
            Vector<double[]> points = new Vector<double[]>();
            points.addAll(current.getPathPoints());
            double[] dArray = new double[4];
            dArray[0] = offsets[0];
            dArray[1] = offsets[1];
            dArray[2] = wpt.coordinates.getZ() - current.getManeuverLocation().getZ();
            points.add(dArray);
            current.setOffsets(points);
        }
        StationKeeping sk = (StationKeeping)plan.getVehicleType().getManeuverFactory().getManeuver("StationKeeping");
        sk.setId("" + count);
        ManeuverLocation loc = lastLoc.clone();
        loc.setZ(0.0);
        loc.setZUnits(ManeuverLocation.Z_UNITS.DEPTH);
        sk.setManeuverLocation(loc);
        maneuvers.add(sk);
        String lastMan = null;
        for (Maneuver maneuver : maneuvers) {
            plan.getGraph().addManeuver(maneuver);
            if (lastMan != null) {
                plan.getGraph().addTransition(lastMan, maneuver.getId(), (Object)"true");
            }
            lastMan = maneuver.getId();
        }
        return plan;
    }

    public void addPoint(Waypoint wpt) {
        this.trajectory.add(wpt);
    }

    public void addPoints(Collection<Waypoint> wpts) {
        this.trajectory.addAll(wpts);
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public static void main(String[] args) {
        NeptusLog.init();
        int imcid = ImcSystemsHolder.getSystemWithName((String)"lauv-xtreme-2").getId().intValue();
        PlanBlueprint plan = new PlanBlueprint(imcid, "test1");
        plan.addPoint(41.18547713427995, -8.70566725730896, 3.0);
        plan.addPoint(41.18456472894702, -8.704508543014526, 3.0);
        plan.addPoint(41.18441131441246, -8.704723119735718, 3.0);
        plan.addPoint(41.18518645785469, -8.705699443817139, 3.0);
        plan.addPoint(41.185081491050695, -8.705892562866211, -2.0);
        plan.addPoint(41.18432249530712, -8.704948425292969, -2.0);
        plan.addPoint(41.18417715469308, -8.705259561538696, -4.0);
        plan.addPoint(41.1850330447767, -8.706353902816772, 3.0);
        plan.addPoint(41.18548117144345, -8.705696761608124, 3.0);
        IMCMessage msg = plan.generate().asIMCPlan();
        GuiUtils.testFrame((JComponent)new JScrollPane(new JLabel(IMCUtils.getAsHtml((IMCMessage)msg))));
    }

    class Waypoint {
        private ManeuverLocation coordinates;

        public Waypoint(ManeuverLocation loc) {
            this.coordinates = loc.clone();
        }
    }
}

