/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.actualstate;

import java.util.Vector;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRA2DPlot;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(name="Corrected position")
public class ActualPosition
extends MRA2DPlot {
    private MRAPanel mraPanel;

    public ActualPosition(MRAPanel panel) {
        super(panel);
        this.mraPanel = panel;
    }

    public void addLogMarker(LogMarker marker) {
        XYSeries markerSeries = this.getMarkerSeries();
        IMCMessage state = this.mraPanel.getSource().getLog("EstimatedState").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
        LocationType loc = new LocationType();
        loc.setLatitudeRads(state.getDouble("lat"));
        loc.setLongitudeRads(state.getDouble("lon"));
        loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
        loc.convertToAbsoluteLatLonDepth();
        if (markerSeries != null) {
            markerSeries.add((XYDataItem)new TimedXYDataItem(loc.getLatitudeDegs(), loc.getLongitudeDegs(), new Double(marker.getTimestamp()).longValue(), marker.getLabel()));
        }
    }

    public void removeLogMarker(LogMarker marker) {
    }

    public void GotoMarker(LogMarker marker) {
    }

    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState"});
    }

    public void process(LsfIndex source) {
        LsfIterator it = source.getIterator(EstimatedState.class, (long)(this.timestep * 1000.0));
        Vector<EstimatedState> nonAdjusted = new Vector<EstimatedState>();
        Vector<LocationType> nonAdjustedLocs = new Vector<LocationType>();
        LocationType lastLoc = null;
        double lastTime = 0.0;
        EstimatedState es = (EstimatedState)it.next();
        while (es != null) {
            LocationType thisLoc = new LocationType();
            thisLoc.setLatitudeRads(es.getLat());
            thisLoc.setLongitudeRads(es.getLon());
            if (es.getDepth() > 0.0) {
                thisLoc.setDepth(es.getDepth());
            }
            if (es.getAlt() > 0.0) {
                thisLoc.setDepth(-es.getAlt());
            }
            thisLoc.translatePosition(es.getX(), es.getY(), 0.0);
            double speed = Math.sqrt(es.getU() * es.getU() + es.getV() * es.getV() + es.getW() * es.getW());
            thisLoc.convertToAbsoluteLatLonDepth();
            if (lastLoc != null) {
                double expectedDiff = speed * (es.getTimestamp() - lastTime);
                lastTime = es.getTimestamp();
                double diff = lastLoc.getHorizontalDistanceInMeters(thisLoc);
                this.addValue(es.getTimestampMillis(), thisLoc.getLatitudeDegs(), thisLoc.getLongitudeDegs(), es.getSourceName(), "Estimated Position");
                if (diff < expectedDiff * 3.0) {
                    nonAdjusted.add(es);
                    nonAdjustedLocs.add(thisLoc);
                } else if (!nonAdjusted.isEmpty()) {
                    double[] adjustment = thisLoc.getOffsetFrom(lastLoc);
                    EstimatedState firstNonAdjusted = (EstimatedState)nonAdjusted.firstElement();
                    double timeOfAdjustment = es.getTimestamp() - firstNonAdjusted.getTimestamp();
                    double xIncPerSec = adjustment[0] / timeOfAdjustment;
                    double yIncPerSec = adjustment[1] / timeOfAdjustment;
                    for (int i = 0; i < nonAdjusted.size(); ++i) {
                        EstimatedState adj = (EstimatedState)nonAdjusted.get(i);
                        LocationType loc = (LocationType)nonAdjustedLocs.get(i);
                        loc.translatePosition(xIncPerSec * (adj.getTimestamp() - firstNonAdjusted.getTimestamp()), yIncPerSec * (adj.getTimestamp() - firstNonAdjusted.getTimestamp()), 0.0);
                        loc.convertToAbsoluteLatLonDepth();
                        this.addValue(adj.getTimestampMillis(), loc.getLatitudeDegs(), loc.getLongitudeDegs(), adj.getSourceName(), "Actual Position");
                    }
                    nonAdjusted.clear();
                    nonAdjustedLocs.clear();
                    nonAdjusted.add(es);
                    nonAdjustedLocs.add(thisLoc);
                }
            }
            lastLoc = thisLoc;
            lastTime = es.getTimestamp();
            es = (EstimatedState)it.next();
        }
    }
}

