/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ctd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitor;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.Salinity;
import pt.lsts.imc.Temperature;
import pt.lsts.imc.lsf.IndexScanner;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.ctd.JImagePanel;

@PluginDescription(name="CTD color map", icon="pt/lsts/neptus/plugins/ctd/thermometer.png", active=false)
public class CTDSidePlot
extends SimpleMRAVisualization {
    private static final long serialVersionUID = -2237994701546034699L;
    private JTabbedPane tabs = new JTabbedPane();
    private MRAPanel panel;

    public CTDSidePlot(MRAPanel panel) {
        super(panel);
        this.panel = panel;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLsfIndex().getEntityId("CTD") != 255;
    }

    private JImagePanel buildImage(String name, Vector<Double> xCoords, Vector<Double> yCoords, Vector<Double> values) {
        double ycoord;
        double maxDepth = Collections.max(yCoords);
        double maxTemp = Collections.max(values);
        double minTemp = Collections.min(values);
        double maxTime = xCoords.lastElement();
        double minTime = xCoords.firstElement();
        JImagePanel ji = new JImagePanel(1100, 725);
        BufferedImage tmpImage = new BufferedImage(1000, 600, 2);
        ColorMap cmap = ColorMapFactory.createJetColorMap();
        double depthFactor = 600.0 / maxDepth;
        double timeFactor = 1000.0 / (maxTime - minTime);
        Point2D[] points = new Point2D[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            points[i] = new Point2D.Double(xCoords.get(i) * timeFactor, yCoords.get(i) * depthFactor);
        }
        ColorMapUtils.generateColorMap((Point2D[])points, (Double[])values.toArray(new Double[0]), (Graphics2D)((Graphics2D)tmpImage.getGraphics()), (double)1000.0, (double)600.0, (int)128, (ColorMap)cmap, (boolean)false);
        Graphics2D g2d = (Graphics2D)ji.getBi().getGraphics();
        g2d.drawImage((Image)tmpImage, 75, 25, null);
        g2d.drawImage(ColorMapUtils.getBar((ColorMap)cmap, (int)ColorMapUtils.HORIZONTAL_ORIENTATION, (int)1000, (int)20), 75, 650, null);
        g2d.setColor(Color.black);
        g2d.drawRect(75, 650, 1000, 20);
        g2d.drawRect(75, 25, 1000, 600);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(255, 255, 255, 128));
        int d = 0;
        while ((double)d < maxDepth) {
            ycoord = depthFactor * (double)d + 25.0;
            g2d.draw(new Line2D.Double(70.0, ycoord, 1075.0, ycoord));
            ++d;
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setFont(new Font("Arial", 0, 20));
        d = 0;
        while ((double)d < maxDepth) {
            ycoord = depthFactor * (double)d + 25.0;
            g2d.draw(new Line2D.Double(70.0, ycoord, 75.0, ycoord));
            g2d.drawString("" + d, 40, (int)ycoord + 10);
            ++d;
        }
        g2d.translate(20, 375);
        g2d.rotate(-1.5707963267948966);
        g2d.drawString(name, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-20, -375);
        double pos = 0.0;
        int i = 75;
        while (i <= 1075) {
            double temperature = minTemp + (maxTemp - minTemp) * pos;
            g2d.draw(new Line2D.Double(i, 670.0, i, 675.0));
            g2d.drawString(String.format("%.2f", temperature), i - 25, 700);
            i += 100;
            pos += 0.1;
        }
        g2d.translate(75, 25);
        for (i = 2; i < xCoords.size(); i += 2) {
            double x1 = (xCoords.get(i - 2) - minTime) * timeFactor;
            double y1 = yCoords.get(i - 2) * depthFactor;
            double x2 = (xCoords.get(i) - minTime) * timeFactor;
            double y2 = yCoords.get(i) * depthFactor;
            g2d.draw(new Line2D.Double(x1, y1, x2, y2));
        }
        return ji;
    }

    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        LsfIndex index = source.getLsfIndex();
        IndexScanner scanner = new IndexScanner(index);
        ProgressMonitor pmonitor = new ProgressMonitor((Component)this.panel, "Creating visualization", "Parsing data", 0, index.getNumberOfMessages());
        Vector<Double> xCoords = new Vector<Double>();
        Vector<Double> yCoords = new Vector<Double>();
        Vector<Double> temp = new Vector<Double>();
        Vector<Double> sal = new Vector<Double>();
        while (true) {
            Temperature t = (Temperature)scanner.next(Temperature.class, "CTD");
            Salinity s = (Salinity)scanner.next(Salinity.class, "CTD");
            EstimatedState d = (EstimatedState)scanner.next(EstimatedState.class);
            if (t == null || s == null || d == null) break;
            pmonitor.setProgress(scanner.getIndex());
            xCoords.add(d.getTimestamp());
            yCoords.add(d.getDepth());
            temp.add(t.getValue());
            sal.add(s.getValue());
        }
        for (int i = 0; !temp.isEmpty() && i < 20; ++i) {
            temp.remove(0);
            sal.remove(0);
            xCoords.remove(0);
            yCoords.remove(yCoords.size() - 1);
        }
        pmonitor.setNote("Generating temperature colormap");
        this.tabs.add("Temperature", this.buildImage("Depth", xCoords, yCoords, temp));
        pmonitor.setNote("Generating salinity colormap");
        this.tabs.add("Salinity", this.buildImage("Depth", xCoords, yCoords, sal));
        pmonitor.close();
        return this.tabs;
    }
}

