/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ctd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import pt.lsts.neptus.util.GuiUtils;

public class JImagePanel
extends JPanel {
    private static final long serialVersionUID = -8755419622843900439L;
    private BufferedImage bi;
    private JLabel lbl;

    public JImagePanel(int imgWidth, int imgHeight) {
        this.bi = new BufferedImage(imgWidth, imgHeight, 2);
        this.bi.getGraphics().setColor(Color.red);
        this.bi.getGraphics().fillRect(0, 0, imgWidth, imgHeight);
        this.bi.getGraphics().setColor(Color.black);
        this.setLayout(new BorderLayout());
        this.lbl = new JLabel(new ImageIcon(this.bi));
        this.add((Component)new JScrollPane(this.lbl), "Center");
        this.lbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add("Save image").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JFileChooser chooser = new JFileChooser();
                            chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)"PNG files", (String[])new String[]{"png"}));
                            if (chooser.showSaveDialog(JImagePanel.this) != 0) {
                                return;
                            }
                            try {
                                ImageIO.write((RenderedImage)JImagePanel.this.bi, "PNG", chooser.getSelectedFile());
                                GuiUtils.infoMessage((Component)JImagePanel.this, (String)"Save image", (String)("Image saved to " + chooser.getSelectedFile()));
                            }
                            catch (Exception ex) {
                                GuiUtils.errorMessage((Component)JImagePanel.this, (Exception)ex);
                            }
                        }
                    });
                    popup.show(JImagePanel.this.lbl, e.getX(), e.getY());
                }
            }
        });
    }

    public BufferedImage getBi() {
        return this.bi;
    }

    public static void main(String[] args) {
        GuiUtils.testFrame((JComponent)new JImagePanel(1024, 768));
    }
}

