/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.gui.BlockingGlassPane;
import pt.lsts.neptus.gui.ColorMapListRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.mraplots.XYZDataType;
import pt.lsts.neptus.plugins.mraplots.XYZUtils;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(author="Paulo Dias", name="Bathymetry 2D", version="0.9", icon="pt/lsts/neptus/plugins/mraplots/2D_v2.png", active=false)
public class BathymetryPlotter
extends SimpleMRAVisualization {
    private JScrollPane imageScrollPane;
    private JComboBox<?> cmapCombo;
    private JFormattedTextField gridSizeTextField;
    private JFormattedTextField widthSizeTextField;
    private JFormattedTextField heightSizeTextField;
    private JFormattedTextField timeStepTextField;
    private JComboBox<String> bottomDistanceEntityCombo;
    private JToolBar toolbar;
    private BufferedImage image;
    private BufferedImage caption;
    private JPanel holderPanel;
    private BlockingGlassPane blockPanel;
    private int gridSize = 100;
    private int targetImageWidth = 512;
    private int targetImageHeight = 512;
    private boolean started = false;
    private boolean onError = false;
    private int imcVersion;
    private LinkedHashMap<Integer, String> entities;
    private Vector<Double> xVec;
    private Vector<Double> yVec;
    private Vector<Double> zVec;
    private XYZDataType xyzData;
    private DataDiscretizer dd;
    private DataDiscretizer.DataPoint[] dps;
    private Rectangle2D.Double bounds;
    private Thread t = null;

    public BathymetryPlotter(MRAPanel panel) {
        super(panel);
    }

    public Double getDefaultTimeStep() {
        return MRAProperties.defaultTimestep;
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return false;
    }

    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        if (this.started) {
            return this;
        }
        this.blockPanel = new BlockingGlassPane();
        this.started = true;
        this.source = source;
        this.timestep = timestep;
        switch (this.imcVersion) {
            case 4: {
                this.setupIMC4(source, timestep);
                break;
            }
            case 5: {
                this.setupIMC5(source, timestep);
                break;
            }
            default: {
                NeptusLog.pub().debug((Object)(I18n.text((String)"Unsupported IMC version: ") + this.imcVersion));
            }
        }
        this.commonSetup();
        this.runWork();
        return this;
    }

    private void setupIMC5(IMraLogGroup source, double timestep) {
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
    }

    private void commonSetup() {
        this.cmapCombo = new JComboBox<ColorMap>(ColorMap.cmaps);
        this.cmapCombo.setSelectedItem(ColorMapFactory.createJetColorMap());
        this.cmapCombo.setRenderer((ListCellRenderer<?>)new ColorMapListRenderer());
        this.toolbar.add(this.cmapCombo);
        JButton bt = new JButton(new AbstractAction(I18n.text((String)"Recreate")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BathymetryPlotter.this.runWork();
            }
        });
        this.toolbar.add(bt);
        JButton bt1 = new JButton(new AbstractAction(I18n.text((String)"Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BathymetryPlotter.this.save();
            }
        });
        this.toolbar.add(bt1);
        this.setLayout(new BorderLayout());
        this.add(this.toolbar, "North");
        this.imageScrollPane = new JScrollPane();
        this.imageScrollPane.setBorder(null);
        this.holderPanel = new JPanel();
        this.holderPanel.setLayout(new BorderLayout());
        this.holderPanel.add(this.imageScrollPane);
        this.add(this.holderPanel);
    }

    private void setupIMC4(IMraLogGroup source, double timestep) {
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.gridSizeTextField = new JFormattedTextField(GuiUtils.getNeptusIntegerFormat());
        this.gridSizeTextField.setText("" + this.gridSize);
        this.gridSizeTextField.setColumns(4);
        this.entities = LogUtils.getEntities((IMraLogGroup)source);
        Vector<String> bottomDistanceEntitiesVector = new Vector<String>();
        bottomDistanceEntitiesVector.add("ALL");
        IMraLog bdSouce = source.getLog("BottomDistance");
        IMCMessage le = bdSouce.nextLogEntry();
        while (le != null) {
            int eid = le.getInteger("src_ent");
            String eName = this.entities.get(eid);
            if (!bottomDistanceEntitiesVector.contains(eName)) {
                bottomDistanceEntitiesVector.add(eName);
            }
            le = bdSouce.nextLogEntry();
        }
        String[] bdEntitiesArray = bottomDistanceEntitiesVector.toArray(new String[bottomDistanceEntitiesVector.size()]);
        Arrays.sort(bdEntitiesArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int res = o1.compareTo(o2);
                if (res == 0) {
                    return res;
                }
                if ("ALL".equals(o1) || "ALL".equals(o2)) {
                    return "ALL".equals(o1) ? -1 : 1;
                }
                if ("Depth & Heading Control".equals(o1) || "Depth & Heading Control".equals(o2)) {
                    return "Depth & Heading Control".equals(o1) ? -1 : 1;
                }
                if ("DVL".equals(o1) || "DVL".equals(o2)) {
                    return "DVL".equals(o1) ? -1 : 1;
                }
                if ("Echo Sounder".equals(o1) || "Echo Sounder".equals(o2)) {
                    return "Echo Sounder".equals(o1) ? -1 : 1;
                }
                return res;
            }
        });
        this.bottomDistanceEntityCombo = new JComboBox<String>(bdEntitiesArray);
        this.bottomDistanceEntityCombo.setSelectedItem(bdEntitiesArray.length > 1 ? bdEntitiesArray[1] : bdEntitiesArray[0]);
        this.toolbar.add(new JLabel(" " + I18n.text((String)"Entity") + ": "));
        this.toolbar.add(this.bottomDistanceEntityCombo);
        this.widthSizeTextField = new JFormattedTextField(GuiUtils.getNeptusIntegerFormat());
        this.widthSizeTextField.setText("" + this.targetImageWidth);
        this.widthSizeTextField.setColumns(4);
        this.heightSizeTextField = new JFormattedTextField(GuiUtils.getNeptusIntegerFormat());
        this.heightSizeTextField.setText("" + this.targetImageWidth);
        this.heightSizeTextField.setColumns(4);
        this.timeStepTextField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)4));
        this.timeStepTextField.setText("" + timestep);
        this.timeStepTextField.setColumns(7);
        this.timeStepTextField.addPropertyChangeListener("timestep", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source == BathymetryPlotter.this.timeStepTextField) {
                    BathymetryPlotter.this.setTimestep(((Number)BathymetryPlotter.this.timeStepTextField.getValue()).doubleValue());
                }
            }
        });
        this.toolbar.add(new JLabel(" " + I18n.text((String)"Time step (s)") + ": "));
        this.toolbar.add(this.timeStepTextField);
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.toolbar.add(new JLabel(" " + I18n.text((String)"Image width") + ": "));
        this.toolbar.add(this.widthSizeTextField);
        this.toolbar.add(new JLabel(" " + I18n.text((String)"height") + ": "));
        this.toolbar.add(this.heightSizeTextField);
        this.toolbar.add(Box.createHorizontalStrut(10));
    }

    private void setTimestep(double timestep) {
        this.timestep = timestep;
    }

    protected void save() {
        int opt = JOptionPane.showOptionDialog((Component)((Object)this), I18n.text((String)"Save image or as map"), I18n.text((String)"Save options"), 2, 3, null, new String[]{I18n.text((String)"Save Image With Caption"), I18n.text((String)"Save Plain Image"), I18n.text((String)"Save as Height Map"), I18n.text((String)"Save as Map"), I18n.text((String)"Cancel")}, I18n.text((String)"Save Image"));
        if (opt < 4 && opt > -1) {
            String name = JOptionPane.showInputDialog((Component)((Object)this), (Object)I18n.text((String)"Input image name"));
            BufferedImage toSave = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            switch (opt) {
                case 1: {
                    Graphics imageGraphics = toSave.getGraphics();
                    imageGraphics.drawImage(this.image, 0, 0, null);
                    break;
                }
                case 0: {
                    Graphics imageGraphics = toSave.getGraphics();
                    imageGraphics.drawImage(this.image, 0, 0, null);
                    imageGraphics.drawImage(this.caption, 0, 0, null);
                    break;
                }
                case 2: {
                    ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)this.bounds, (DataDiscretizer.DataPoint[])this.dps, (int)0, (Graphics2D)toSave.createGraphics(), (double)toSave.getWidth(), (double)toSave.getHeight(), (int)255, (ColorMap)ColorMapFactory.createGrayScaleColorMap(), (double)(this.dd.minVal[0] * 0.995), (double)(this.dd.maxVal[0] * 1.005));
                    break;
                }
                case 3: {
                    if ("".equalsIgnoreCase(name)) break;
                    ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)this.bounds, (DataDiscretizer.DataPoint[])this.dps, (int)0, (Graphics2D)toSave.createGraphics(), (double)toSave.getWidth(), (double)toSave.getHeight(), (int)255, (ColorMap)ColorMapFactory.createGrayScaleColorMap(), (double)(this.dd.minVal[0] * 0.995), (double)(this.dd.maxVal[0] * 1.005));
                    XYZUtils.getAsMapType(this.image, toSave, name, "./", this.xyzData.centerLoc, this.xyzData.scale, -this.xyzData.maxZ, -this.xyzData.minZ);
                }
            }
            if (!"".equalsIgnoreCase(name)) {
                File destFile = new File("./" + name + ".png");
                XYZUtils.saveImageToPNG(toSave, destFile);
            }
        }
    }

    private void runWork() {
        this.toolbar.setEnabled(false);
        this.holderPanel.removeAll();
        this.holderPanel.add((Component)this.blockPanel);
        this.blockPanel.block(true);
        this.blockPanel.setText(I18n.text((String)"Generating bathymetry plot"));
        for (Component component : this.toolbar.getComponents()) {
            component.setEnabled(false);
        }
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    switch (BathymetryPlotter.this.imcVersion) {
                        case 4: {
                            BathymetryPlotter.this.generateIMC4();
                        }
                        case 5: {
                            BathymetryPlotter.this.generateIMC5();
                        }
                    }
                    double scaleY = (double)BathymetryPlotter.this.image.getWidth() / BathymetryPlotter.this.bounds.getWidth();
                    double scaleX = (double)BathymetryPlotter.this.image.getHeight() / BathymetryPlotter.this.bounds.getHeight();
                    double minY = BathymetryPlotter.this.bounds.getMinX();
                    double minX = BathymetryPlotter.this.bounds.getMinY();
                    XYZUtils.drawPath((Graphics2D)BathymetryPlotter.this.image.getGraphics(), scaleX, scaleY, minX, minY, BathymetryPlotter.this.timestep, BathymetryPlotter.this.source);
                    BathymetryPlotter.this.caption = new BufferedImage(200, 250, 2);
                    XYZUtils.drawLegend((Graphics2D)BathymetryPlotter.this.caption.getGraphics(), (ColorMap)BathymetryPlotter.this.cmapCombo.getSelectedItem(), I18n.text((String)"Bathymetry"), 1.0 / ((BathymetryPlotter)BathymetryPlotter.this).xyzData.scale, "m", -((BathymetryPlotter)BathymetryPlotter.this).xyzData.minZ, -((BathymetryPlotter)BathymetryPlotter.this).xyzData.maxZ);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BathymetryPlotter.this.remove(BathymetryPlotter.this.imageScrollPane);
                            BathymetryPlotter.this.imageScrollPane.setBorder(null);
                            JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 2"));
                            panel.add(new JLabel(new ImageIcon(BathymetryPlotter.this.caption)));
                            panel.add(new JLabel(new ImageIcon(BathymetryPlotter.this.image)));
                            BathymetryPlotter.this.imageScrollPane.getViewport().setView(panel);
                            BathymetryPlotter.this.add(BathymetryPlotter.this.imageScrollPane, "Center");
                            BathymetryPlotter.this.toolbar.setEnabled(true);
                            for (Component component : BathymetryPlotter.this.toolbar.getComponents()) {
                                component.setEnabled(true);
                            }
                            BathymetryPlotter.this.revalidate();
                            BathymetryPlotter.this.blockPanel.setText(I18n.text((String)"Done"));
                            BathymetryPlotter.this.holderPanel.removeAll();
                            BathymetryPlotter.this.holderPanel.add(BathymetryPlotter.this.imageScrollPane);
                            BathymetryPlotter.this.blockPanel.block(false);
                        }
                    });
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
                BathymetryPlotter.this.t = null;
            }
        });
        this.t.setName("BathymetryPlotter thread");
        this.t.setDaemon(true);
        this.t.start();
    }

    public void onCleanup() {
        if (this.blockPanel != null) {
            this.blockPanel.block(false);
        }
        if (this.t != null) {
            this.t.interrupt();
        }
        super.onCleanup();
    }

    private boolean generateIMC4() {
        long timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " generateIMC4"));
        try {
            IMraLogGroup src = this.source;
            try {
                this.timestep = Double.parseDouble(this.timeStepTextField.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.timeStepTextField.setText("" + this.timestep);
            }
            String selEntityStr = (String)this.bottomDistanceEntityCombo.getSelectedItem();
            int selBdEntInt = 255;
            for (Integer eid : this.entities.keySet()) {
                if (!this.entities.get(eid).equals(selEntityStr)) continue;
                selBdEntInt = eid;
                break;
            }
            IMraLog bParser = src.getLog("BottomDistance");
            IMraLog stateParser = src.getLog("EstimatedState");
            this.xVec = new Vector();
            this.yVec = new Vector();
            this.zVec = new Vector();
            try {
                this.gridSize = Integer.parseInt(this.gridSizeTextField.getText());
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
                this.gridSizeTextField.setText("100");
            }
            this.dd = new DataDiscretizer(1.0);
            IMCMessage bEntry = null;
            IMCMessage entry = stateParser.nextLogEntry();
            timestamp = System.currentTimeMillis();
            NeptusLog.pub().debug((Object)(timestamp + " finding reference location"));
            LocationType imageCornerRef = LogUtils.getHomeRef((IMraLogGroup)src);
            if (imageCornerRef == null) {
                imageCornerRef = new LocationType();
                imageCornerRef.setLatitudeDegs(Math.toDegrees(entry.getDouble("lat")));
                imageCornerRef.setLatitudeDegs(Math.toDegrees(entry.getDouble("lon")));
            }
            LocationType tmp = new LocationType();
            bEntry = bParser.nextLogEntry();
            double bValue = 0.0;
            timestamp = System.currentTimeMillis();
            NeptusLog.pub().debug((Object)(timestamp + " Analysing data"));
            while (bEntry != null && !this.onError) {
                if (bEntry != null) {
                    IMCMessage stateEntry = stateParser.getEntryAtOrAfter(bParser.currentTimeMillis());
                    if (stateEntry == null) {
                        bParser.advance((long)(this.timestep * 1000.0));
                        bEntry = bParser.getCurrentEntry();
                        continue;
                    }
                    if (selBdEntInt != 255 && selBdEntInt != bEntry.getInteger("src_ent") || bEntry != null && !"VALID".equalsIgnoreCase(bEntry.getString("validity"))) {
                        while (bEntry != null && bEntry.getDouble("src_ent") != (double)selBdEntInt || bEntry != null && !"VALID".equalsIgnoreCase(bEntry.getString("validity"))) {
                            bEntry = bParser.nextLogEntry();
                        }
                    }
                    if ((tmp = LogUtils.getLocation((LocationType)imageCornerRef, (IMCMessage)(stateEntry = stateParser.getEntryAtOrAfter(bParser.currentTimeMillis())))).getAllZ() < 0.8) {
                        bParser.advance((long)(this.timestep * 1000.0));
                        bEntry = bParser.getCurrentEntry();
                        continue;
                    }
                    tmp = tmp.getNewAbsoluteLatLonDepth();
                    double distance = bEntry.getDouble("value") + tmp.getDepth();
                    if (distance != 0.0) {
                        if (bValue == 0.0) {
                            bValue = distance;
                        }
                        bValue = distance = bValue * 0.9 + distance * 0.1;
                    }
                    tmp.setDepth(0.0);
                    double[] offs = tmp.getOffsetFrom(imageCornerRef);
                    this.xVec.add(offs[0]);
                    this.yVec.add(offs[1]);
                    this.zVec.add(-distance);
                    this.dd.addPoint(offs[1], -offs[0], -distance);
                }
                bParser.advance((long)(1000.0 * this.timestep));
                bEntry = bParser.getCurrentEntry();
                if ((bEntry == null || selBdEntInt == 255 || selBdEntInt == bEntry.getInteger("src_ent")) && (bEntry == null || "VALID".equalsIgnoreCase(bEntry.getString("validity")))) continue;
                while (bEntry != null && bEntry.getDouble("src_ent") != (double)selBdEntInt || bEntry != null && !"VALID".equalsIgnoreCase(bEntry.getString("validity"))) {
                    bEntry = bParser.nextLogEntry();
                }
            }
            timestamp = System.currentTimeMillis();
            NeptusLog.pub().debug((Object)(timestamp + " generating image"));
            if (this.onError) {
                return false;
            }
            try {
                this.targetImageWidth = Integer.parseInt(this.widthSizeTextField.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.widthSizeTextField.setText("" + this.targetImageWidth);
            }
            try {
                this.targetImageHeight = Integer.parseInt(this.heightSizeTextField.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.heightSizeTextField.setText("" + this.targetImageHeight);
            }
            this.generateClippedImage(this.gridSize, imageCornerRef, this.targetImageWidth, this.targetImageHeight);
            return !this.onError;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError = true;
            return false;
        }
    }

    private void generateClippedImage(int gridSize, LocationType imageCornerRef, int targetImageWidth, int targetImageHeight) {
        this.dps = this.dd.getDataPoints();
        long timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " getInterpolatedData"));
        this.xyzData = XYZUtils.getInterpolatedData(imageCornerRef, this.xVec, this.yVec, this.zVec, targetImageWidth, targetImageHeight, gridSize);
        this.image = new BufferedImage(this.xyzData.width, this.xyzData.height, 2);
        double maxX = this.dd.maxX + 25.0;
        double maxY = this.dd.maxY + 25.0;
        double minX = this.dd.minX - 25.0;
        double minY = this.dd.minY - 25.0;
        double dimensionX = maxX - minX;
        double dimensionY = maxY - minY;
        double ratioWanted = (double)targetImageWidth / (double)targetImageHeight;
        double ratioReal = dimensionX / dimensionY;
        if (ratioReal < ratioWanted) {
            dimensionX = dimensionY * ratioWanted;
        } else {
            dimensionY = dimensionX / ratioWanted;
        }
        double centerX = (maxX + minX) / 2.0;
        double centerY = (maxY + minY) / 2.0;
        this.bounds = new Rectangle2D.Double(centerX - dimensionX / 2.0, centerY - dimensionY / 2.0, dimensionX, dimensionY);
        try {
            timestamp = System.currentTimeMillis();
            NeptusLog.pub().debug((Object)(timestamp + " generateInterpolatedColorMap"));
            ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)this.bounds, (DataDiscretizer.DataPoint[])this.dps, (int)0, (Graphics2D)this.image.createGraphics(), (double)this.image.getWidth(), (double)this.image.getHeight(), (int)255, (ColorMap)((ColorMap)this.cmapCombo.getSelectedItem()), (double)(this.dd.minVal[0] * 0.995), (double)(this.dd.maxVal[0] * 1.005));
        }
        catch (NullPointerException e) {
            NeptusLog.pub().error((Object)e, (Throwable)e);
        }
        timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " Clip with CHull"));
        try {
            double scaleX = (double)this.image.getWidth() / this.bounds.getWidth();
            double scaleY = (double)this.image.getHeight() / this.bounds.getHeight();
            double minX1 = this.bounds.getMinX();
            double minY1 = this.bounds.getMinY();
            double maxX1 = this.bounds.getMaxX();
            double maxY1 = this.bounds.getMaxY();
            Graphics2D g2 = (Graphics2D)this.image.getGraphics().create();
            g2.setColor(new Color(0, 0, 0, 255));
            Graphics2D g2S = (Graphics2D)this.image.getGraphics().create();
            g2S.translate(-minX1 * scaleX, -minY1 * scaleY);
            g2S.scale(scaleX, scaleY);
            AffineTransform transfS = g2S.getTransform();
            g2S.dispose();
            ArrayList points = this.dd.computeConvexHull();
            ArrayList pointsGrow = MathMiscUtils.dilatePolygonPoint((ArrayList)points, (double)10.0);
            GeneralPath cHullShapeS = new GeneralPath();
            cHullShapeS.setWindingRule(0);
            cHullShapeS.moveTo(minX1, minY1);
            cHullShapeS.lineTo(maxX1, minY1);
            cHullShapeS.lineTo(maxX1, maxY1);
            cHullShapeS.lineTo(minX1, maxY1);
            cHullShapeS.lineTo(minX1, minY1);
            for (int i = 0; i < pointsGrow.size(); ++i) {
                if (i == 0) {
                    cHullShapeS.moveTo(((Point)pointsGrow.get((int)i)).x, ((Point)pointsGrow.get((int)i)).y);
                } else {
                    cHullShapeS.lineTo(((Point)pointsGrow.get((int)i)).x, ((Point)pointsGrow.get((int)i)).y);
                }
                if (i != pointsGrow.size() - 1) continue;
                cHullShapeS.lineTo(((Point)pointsGrow.get((int)0)).x, ((Point)pointsGrow.get((int)0)).y);
            }
            g2.setComposite(AlphaComposite.getInstance(1));
            g2.setColor(new Color(0, 255, 0, 255));
            g2.fill(cHullShapeS.createTransformedShape(transfS));
            g2.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " done"));
    }

    private boolean generateIMC5() {
        long timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " starting generateIMC5"));
        this.xVec = new Vector();
        this.yVec = new Vector();
        this.zVec = new Vector();
        this.dd = new DataDiscretizer(1.0);
        timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " setting up imageCornerRef"));
        EstimatedState firstEstStateMsg = (EstimatedState)this.source.getLsfIndex().getFirst(EstimatedState.class);
        LocationType imageCornerRef = LogUtils.getLocation((IMCMessage)firstEstStateMsg);
        double bValue = 0.0;
        LsfIndex lsfIndex = this.source.getLsfIndex();
        timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " processing points"));
        for (EstimatedState currEstStateMsg : lsfIndex.getIterator(EstimatedState.class)) {
            if (currEstStateMsg.getAlt() < 0.0 || currEstStateMsg.getDepth() < MRAProperties.minDepthForBathymetry || Math.abs(currEstStateMsg.getTheta()) > Math.toDegrees(10.0)) continue;
            double waterColumn = currEstStateMsg.getDepth() + currEstStateMsg.getAlt();
            LocationType estStateMsgLocation = LogUtils.getLocation((IMCMessage)currEstStateMsg);
            double[] offs = estStateMsgLocation.getOffsetFrom(imageCornerRef);
            this.xVec.add(offs[0]);
            this.yVec.add(offs[1]);
            this.zVec.add(-waterColumn);
            if (waterColumn != 0.0) {
                if (bValue == 0.0) {
                    bValue = waterColumn;
                }
                bValue = waterColumn = bValue * 0.9 + waterColumn * 0.1;
            }
            this.dd.addPoint(offs[1], -offs[0], -waterColumn);
        }
        timestamp = System.currentTimeMillis();
        NeptusLog.pub().debug((Object)(timestamp + " generating image"));
        int targetImageWidth = 1024;
        int targetImageHeight = 768;
        this.generateClippedImage(this.gridSize, imageCornerRef, targetImageWidth, targetImageHeight);
        return true;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }
}

