/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.neptus.util.GuiUtils;

public class Histogram
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected BufferedImage histogram = null;

    public Histogram() {
        this.setData(new double[]{0.0}, 0.0, 255.0);
    }

    public void setData(double[] data, double fixedMin, double fixedMax) {
        double min = fixedMin;
        double max = fixedMax;
        if (Double.isNaN(fixedMin) || Double.isNaN(fixedMax)) {
            min = data[0];
            max = data[0];
            for (int i = 1; i < data.length; ++i) {
                if (data[i] > max) {
                    max = data[i];
                }
                if (!(data[i] < min)) continue;
                min = data[i];
            }
        }
        int width = data.length;
        int height = 255;
        this.histogram = new BufferedImage(width, height, 2);
        Graphics2D g = this.histogram.createGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.red);
        for (int i = 0; i < data.length; ++i) {
            g.draw(new Line2D.Double(i, height - 1, i, (double)(height - 1) - data[i] / max * 255.0));
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.histogram != null) {
            g.drawImage(this.histogram, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.histogram.getWidth(), this.histogram.getHeight(), this);
        }
    }

    public static void main(String[] args) {
        Histogram hist = new Histogram();
        double[] vals = new double[2000];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Math.random() * 255.0;
        }
        hist.setData(vals, 0.0, 255.0);
        GuiUtils.testFrame((JComponent)hist);
    }
}

