/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class LsfIndexTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected final String[] fields = new String[]{I18n.text((String)"Time (UTC)"), I18n.text((String)"Message"), I18n.text((String)"Source"), I18n.text((String)"Src. Entity"), I18n.text((String)"Destination")};
    protected LsfIndex index = null;
    protected SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS ");
    LinkedHashMap<Integer, IMCMessage> cache;

    public LsfIndexTableModel(LsfIndex index) {
        this.dateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.cache = new LinkedHashMap<Integer, IMCMessage>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, IMCMessage> eldest) {
                return super.size() > 100;
            }
        };
        this.index = index;
    }

    @Override
    public int getRowCount() {
        return this.index.getNumberOfMessages();
    }

    @Override
    public int getColumnCount() {
        return this.fields.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.fields[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IMCMessage msg = this.cache.containsKey(rowIndex) ? this.cache.get(rowIndex) : this.index.getMessage(rowIndex);
        this.cache.put(rowIndex, msg);
        switch (columnIndex) {
            case 0: {
                return this.dateFormatUTC.format(new Date(msg.getTimestampMillis()));
            }
            case 1: {
                return msg.getAbbrev();
            }
            case 2: {
                return this.index.getDefinitions().getResolver().resolve(msg.getSrc());
            }
            case 3: {
                return this.index.getEntityName(msg.getSrc(), (int)msg.getSrcEnt());
            }
            case 4: {
                return this.index.getDefinitions().getResolver().resolve(msg.getDst());
            }
        }
        return "?";
    }

    public static void main(String[] args) throws Exception {
        LsfIndex index = new LsfIndex(new File("/home/zp/Desktop/143245_rows_minus1.5m_1000rpm/Data.lsf"), new IMCDefinition((InputStream)new FileInputStream(new File("/home/zp/Desktop/143245_rows_minus1.5m_1000rpm/IMC.xml"))));
        LsfIndexTableModel tableModel = new LsfIndexTableModel(index);
        JTable table = new JTable(tableModel);
        GuiUtils.testFrame((JComponent)new JScrollPane(table));
    }
}

