/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ProgressMonitor;
import javax.swing.plaf.basic.BasicSliderUI;
import net.miginfocom.swing.MigLayout;
import org.imgscalr.Scalr;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.Timeline;
import pt.lsts.neptus.gui.TimelineChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.replay.MraVehiclePosHud;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.mraplots.PhotoToolbar;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.VideoCreator;
import pt.lsts.neptus.util.llf.LsfReportProperties;

@PluginDescription(name="Photos", icon="pt/lsts/neptus/plugins/mraplots/camera.png")
public class MraPhotosVisualization
extends JComponent
implements MRAVisualization,
LogMarkerListener {
    private static final long serialVersionUID = 1L;
    protected PriorityBlockingQueue<File> files = new PriorityBlockingQueue(3);
    protected PriorityBlockingQueue<LoadedImage> imgs = new PriorityBlockingQueue(3);
    protected int loadingThreads = 2;
    protected File photosDir;
    protected LsfIndex index;
    protected Image imageToDisplay = null;
    protected double curTime = 0.0;
    protected Vector<Thread> running = new Vector();
    protected File curFile = null;
    protected PhotoToolbar toolbar = null;
    protected double speedMultiplier = 1.0;
    protected boolean brighten = false;
    protected boolean grayscale = false;
    protected boolean contrast = false;
    protected boolean sharpen = false;
    protected boolean showLegend = true;
    protected BufferedImageOp contrastOp = ImageUtils.contrastOp();
    protected BufferedImageOp sharpenOp = ImageUtils.sharpenOp();
    protected BufferedImageOp brightenOp = ImageUtils.brightenOp((float)1.2f, (int)0);
    protected BufferedImageOp grayscaleOp = ImageUtils.grayscaleOp();
    protected BufferedImageOp whiteBalanceOp = null;
    protected LinkedHashMap<File, SystemPositionAndAttitude> states = null;
    protected MRAPanel panel;
    protected MraVehiclePosHud hud;
    protected Point2D zoomPoint = null;
    protected boolean fullRes = false;
    protected Vector<LogMarker> markers = new Vector();
    private File[] allFiles;
    long startTime;
    long endTime;
    Timeline timeline;
    protected SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected Integer legendWidth;

    public MraPhotosVisualization(MRAPanel panel) {
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.legendWidth = null;
        this.panel = panel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 3) {
                    MraPhotosVisualization.this.showPopup(MraPhotosVisualization.this.curFile, e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.getButton() == 3) {
                    return;
                }
                if (MraPhotosVisualization.this.imageToDisplay == null) {
                    return;
                }
                MraPhotosVisualization.this.zoomPoint = e.getPoint();
                MraPhotosVisualization.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.getButton() == 3) {
                    return;
                }
                MraPhotosVisualization.this.zoomPoint = null;
                MraPhotosVisualization.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (e.getButton() == 3) {
                    return;
                }
                if (MraPhotosVisualization.this.imageToDisplay == null) {
                    return;
                }
                MraPhotosVisualization.this.zoomPoint = e.getPoint();
                MraPhotosVisualization.this.repaint();
            }
        });
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getFile("Photos") != null && source.getFile("Photos").isDirectory();
    }

    public void onCleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogMarker(LogMarker marker) {
        this.repaint();
        Vector<LogMarker> vector = this.markers;
        synchronized (vector) {
            this.markers.clear();
            this.markers.addAll(this.panel.getMarkers());
            Collections.sort(this.markers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogMarker(LogMarker marker) {
        this.repaint();
        Vector<LogMarker> vector = this.markers;
        synchronized (vector) {
            this.markers.clear();
            this.markers.addAll(this.panel.getMarkers());
            Collections.sort(this.markers);
        }
    }

    public void GotoMarker(LogMarker marker) {
        if (this.photosDir == null) {
            return;
        }
        Object[] allFiles = this.photosDir.listFiles();
        Arrays.sort(allFiles);
        for (int i = 0; i < allFiles.length; ++i) {
            if (!(this.timestampOf((File)allFiles[i]) >= marker.getTimestamp() / 1000.0)) continue;
            this.setCurFile((File)allFiles[i]);
            return;
        }
    }

    public File getCurFile() {
        return this.curFile;
    }

    public void setCurFile(File curFile) {
        this.curFile = curFile;
        try {
            this.imageToDisplay = this.loadImage(curFile, false);
            this.curTime = this.timestampOf(curFile);
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File[] listPhotos(File photosDir) {
        Object[] allFiles = photosDir.listFiles();
        Vector<File> allF = new Vector<File>();
        for (File file : allFiles) {
            if (!file.isDirectory()) {
                allF.add(file);
                continue;
            }
            allF.addAll(Arrays.asList(file.listFiles()));
        }
        for (int i = 0; i < allF.size(); ++i) {
            if (((File)allF.get(i)).getName().endsWith(".jpg")) continue;
            allF.remove(i--);
        }
        allFiles = allF.toArray(new File[0]);
        Arrays.sort(allFiles);
        return allFiles;
    }

    public double getCurTime() {
        return this.curTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(IMraLogGroup source, double timestep) {
        this.photosDir = source.getFile("Photos");
        this.index = source.getLsfIndex();
        this.hud = new MraVehiclePosHud(source, 150, 150);
        this.allFiles = MraPhotosVisualization.listPhotos(this.getPhotosDir());
        this.startTime = (long)(this.timestampOf(this.allFiles[0]) * 1000.0);
        this.endTime = (long)(this.timestampOf(this.allFiles[this.allFiles.length - 1]) * 1000.0);
        this.timeline = new Timeline(0, (int)(this.endTime - this.startTime), 7, 1000, false);
        this.timeline.addTimelineChangeListener(new TimelineChangeListener(){

            public void timelineChanged(int value) {
                MraPhotosVisualization.this.setTime((double)(MraPhotosVisualization.this.startTime + (long)value) / 1000.0);
            }
        });
        this.timeline.getSlider().setValue(0);
        this.timeline.getSlider().setUI(new BasicSliderUI(this.timeline.getSlider()){

            @Override
            public void paintTicks(Graphics g) {
                super.paintTicks(g);
                for (LogMarker m : MraPhotosVisualization.this.markers) {
                    long mtime = new Double(m.getTimestamp()).longValue();
                    g.drawLine(this.xPositionForValue((int)(mtime - MraPhotosVisualization.this.startTime)), 0, this.xPositionForValue((int)(mtime - MraPhotosVisualization.this.startTime)), MraPhotosVisualization.this.timeline.getSlider().getHeight() / 2);
                }
            }
        });
        this.toolbar = new PhotoToolbar(this);
        this.loadStates();
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.add((Component)this, "w 100%, h 100%, wrap");
        panel.add((Component)this.timeline, "split");
        panel.add((Component)this.toolbar, "wrap");
        Vector<LogMarker> vector = this.markers;
        synchronized (vector) {
            this.markers.clear();
            this.markers.addAll(this.panel.getMarkers());
            Collections.sort(this.markers);
        }
        return panel;
    }

    protected void loadStates() {
        File[] files = MraPhotosVisualization.listPhotos(this.getPhotosDir());
        int lastIndex = 0;
        int stateId = this.index.getDefinitions().getMessageId("EstimatedState");
        int lastBDistanceIndex = 0;
        int bdistId = this.index.getDefinitions().getMessageId("BottomDistance");
        int dvlId = this.index.getEntityId("DVL");
        this.states = new LinkedHashMap();
        for (int i = 0; i < files.length; ++i) {
            int msgIndex = this.index.getMessageAtOrAfer(stateId, 255, lastIndex, this.timestampOf(files[i]));
            if (msgIndex == -1) {
                this.states.put(files[i], null);
                continue;
            }
            lastIndex = msgIndex;
            IMCMessage m = this.index.getMessage(msgIndex);
            LocationType loc = new LocationType(Math.toDegrees(m.getDouble("lat")), Math.toDegrees(m.getDouble("lon")));
            loc.setDepth(m.getDouble("depth"));
            loc.translatePosition(m.getDouble("x"), m.getDouble("y"), 0.0);
            loc.convertToAbsoluteLatLonDepth();
            SystemPositionAndAttitude state = new SystemPositionAndAttitude(loc, m.getDouble("phi"), m.getDouble("theta"), m.getDouble("psi"));
            if (m.getTypeOf("alt") == null) {
                state.setW(Double.NaN);
                int bdIndex = this.index.getMessageAtOrAfer(bdistId, dvlId, lastBDistanceIndex, this.timestampOf(files[i]));
                if (bdIndex != -1) {
                    state.setW(this.index.getMessage(bdIndex).getDouble("value"));
                    lastBDistanceIndex = bdIndex;
                }
            } else {
                state.setW(m.getDouble("alt"));
            }
            state.setU(m.getDouble("u"));
            this.states.put(files[i], state);
        }
    }

    public Double getDefaultTimeStep() {
        return 0.25;
    }

    public ImageIcon getIcon() {
        return ImageUtils.getScaledIcon((String)PluginUtils.getPluginIcon(this.getClass()), (int)16, (int)16);
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public boolean supportsVariableTimeSteps() {
        return false;
    }

    protected void showPopup(final File f, MouseEvent evt) {
        JPopupMenu popup = new JPopupMenu();
        popup.add("Add marker").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LsfReportProperties.generatingReport) {
                    GuiUtils.infoMessage((Component)MraPhotosVisualization.this.panel.getRootPane(), (String)I18n.text((String)"Can not add Marks"), (String)I18n.text((String)"Can not add Marks - Generating Report."));
                    return;
                }
                String resp = JOptionPane.showInputDialog((Component)MraPhotosVisualization.this.panel, "Enter marker name", "Add marker", 3);
                if (resp == null) {
                    return;
                }
                SystemPositionAndAttitude state = MraPhotosVisualization.this.states.get(f);
                LogMarker marker = new LogMarker(resp, MraPhotosVisualization.this.timestampOf(f) * 1000.0, state.getPosition().getLatitudeRads(), state.getPosition().getLongitudeRads());
                MraPhotosVisualization.this.panel.addMarker(marker);
            }
        });
        popup.add(I18n.text((String)"Save image")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File output = new File(MraPhotosVisualization.this.photosDir.getParentFile(), FileUtil.getFileNameWithoutExtension((File)f) + ".png");
                try {
                    boolean prevFullRes = MraPhotosVisualization.this.fullRes;
                    MraPhotosVisualization.this.fullRes = true;
                    Image m = MraPhotosVisualization.this.loadImage(f, true);
                    MraPhotosVisualization.this.fullRes = prevFullRes;
                    BufferedImage tmp = new BufferedImage(m.getWidth(null), m.getHeight(null), 2);
                    Graphics2D g = (Graphics2D)tmp.getGraphics();
                    Image watermark = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/mraplots/lsts-watermark.png");
                    g.drawImage(m, 0, 0, tmp.getWidth(), tmp.getHeight(), 0, 0, m.getWidth(null), m.getHeight(null), null);
                    if (MraPhotosVisualization.this.showLegend) {
                        MraPhotosVisualization.this.drawLegend(g, f);
                        g.drawImage((Image)MraPhotosVisualization.this.hud.getImage(MraPhotosVisualization.this.timestampOf(f)), 10, tmp.getHeight() - 160, null);
                        g.drawImage(watermark, tmp.getWidth() - 55, tmp.getHeight() - 55, null);
                    }
                    ImageIO.write((RenderedImage)tmp, "PNG", output);
                    GuiUtils.infoMessage((Component)MraPhotosVisualization.this.panel, (String)I18n.text((String)"Image saved"), (String)I18n.textf((String)"Image saved in %filename", (Object[])new Object[]{output.getAbsolutePath()}));
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)MraPhotosVisualization.this, (Exception)ex);
                }
            }
        });
        JMenuItem exportVideo = new JMenuItem(I18n.text((String)"Export video"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/mraplots/film.png"));
        popup.add(exportVideo);
        exportVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final File[] allFiles = MraPhotosVisualization.listPhotos(MraPhotosVisualization.this.getPhotosDir());
                final double startTime = MraPhotosVisualization.this.timestampOf(allFiles[0]);
                try {
                    final VideoCreator creator = new VideoCreator(new File(MraPhotosVisualization.this.photosDir.getParentFile(), "Video.mp4"), 800, 600);
                    final ProgressMonitor monitor = new ProgressMonitor((Component)MraPhotosVisualization.this.panel, I18n.text((String)"Creating video"), I18n.text((String)"Starting up"), 0, allFiles.length);
                    Thread videoMaker = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MraPhotosVisualization.this.fullRes = true;
                            Image watermark = null;
                            if (new File("conf/mra-watermark.png").canRead()) {
                                watermark = ImageUtils.getImage((String)new File("conf/mra-watermark.png").getPath());
                            }
                            BufferedImage tmp = new BufferedImage(800, 600, 2);
                            Graphics2D g = tmp.createGraphics();
                            int count = 0;
                            double speedMult = MraPhotosVisualization.this.speedMultiplier;
                            for (File f : allFiles) {
                                if (monitor.isCanceled()) break;
                                try {
                                    Image m = MraPhotosVisualization.this.loadImage(f, false);
                                    g.drawImage(m, 0, 0, tmp.getWidth(), tmp.getHeight(), 0, 0, m.getWidth(null), m.getHeight(null), null);
                                    if (MraPhotosVisualization.this.showLegend) {
                                        MraPhotosVisualization.this.drawLegend(g, f);
                                        g.drawImage((Image)MraPhotosVisualization.this.hud.getImage(MraPhotosVisualization.this.timestampOf(f)), 10, tmp.getHeight() - 160, null);
                                        if (watermark != null) {
                                            g.drawImage(watermark, tmp.getWidth() - 55, tmp.getHeight() - 55, null);
                                        }
                                    }
                                    monitor.setNote("Processing " + f.getName());
                                    monitor.setProgress(count++);
                                    creator.addFrame(tmp, (long)((MraPhotosVisualization.this.timestampOf(f) - startTime) * 1000.0 / speedMult));
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                }
                            }
                            creator.closeStreams();
                            monitor.close();
                            MraPhotosVisualization.this.fullRes = false;
                            GuiUtils.infoMessage((Component)MraPhotosVisualization.this.panel, (String)I18n.text((String)"Production completed"), (String)I18n.textf((String)"Video saved in %filename", (Object[])new Object[]{new File(MraPhotosVisualization.this.photosDir.getParentFile(), "Video.mp4").getAbsolutePath()}));
                        }
                    });
                    videoMaker.setName("Video maker thread");
                    videoMaker.start();
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)MraPhotosVisualization.this.panel, (Exception)ex);
                }
            }
        });
        popup.show(this, evt.getX(), evt.getY());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Image copy = this.imageToDisplay;
        if (copy != null) {
            g.drawImage(copy, 0, 0, this.getWidth(), this.getHeight(), 0, 0, copy.getWidth(this), copy.getHeight(this), this);
        }
        int countMarkers = 0;
        for (int i = 0; i < this.markers.size() && !(this.markers.get(i).getTimestamp() / 1000.0 > this.curTime + 2.0); ++i) {
            if (this.markers.get(i).getTimestamp() / 1000.0 < this.curTime - 2.0) continue;
            int alpha = (int)(127.5 * Math.abs(this.markers.get(i).getTimestamp() / 1000.0 - this.curTime));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(255, 255, 128, 255 - alpha));
            g.drawString(this.markers.get(i).getLabel(), 10, 150 + ++countMarkers * 15);
        }
        if (this.showLegend) {
            this.drawLegend((Graphics2D)g, this.curFile);
            g.drawImage(this.hud.getImage(this.curTime), 10, this.getHeight() - 160, null);
        }
        if (this.zoomPoint != null && this.imageToDisplay != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            int imgX = (int)(this.zoomPoint.getX() / (double)this.getWidth() * (double)this.imageToDisplay.getWidth(null));
            int imgY = (int)(this.zoomPoint.getY() / (double)this.getHeight() * (double)this.imageToDisplay.getHeight(null));
            ((Graphics2D)g).drawImage(this.imageToDisplay, this.getWidth() - 210, this.getHeight() - 210, this.getWidth() - 10, this.getHeight() - 10, imgX - 25, imgY - 25, imgX + 25, imgY + 25, null);
        }
    }

    public double timestampOf(File f) {
        return Double.parseDouble(f.getName().substring(0, f.getName().lastIndexOf(46)));
    }

    protected Image loadImage(File f, boolean useFullResolution) throws IOException {
        Vector<BufferedImageOp> ops = new Vector<BufferedImageOp>();
        if (this.whiteBalanceOp != null) {
            ops.add(this.whiteBalanceOp);
        }
        if (this.contrast) {
            ops.add(this.contrastOp);
        }
        if (this.sharpen) {
            ops.add(this.sharpenOp);
        }
        if (this.brighten) {
            ops.add(this.brightenOp);
        }
        if (this.grayscale) {
            ops.add(this.grayscaleOp);
        }
        BufferedImageOp[] operations = ops.toArray(new BufferedImageOp[0]);
        BufferedImage original = ImageIO.read(f);
        if (this.fullRes || useFullResolution) {
            if (!ops.isEmpty()) {
                original = Scalr.apply((BufferedImage)original, (BufferedImageOp[])operations);
            }
        } else {
            original = Scalr.resize((BufferedImage)original, (int)this.getWidth(), (int)this.getHeight(), (BufferedImageOp[])operations);
        }
        return original;
    }

    protected int getLegendWidth(Vector<String> strs, Graphics2D g) {
        if (this.legendWidth == null) {
            int maxSize = 0;
            for (String s : strs) {
                Rectangle2D r = g.getFontMetrics(g.getFont()).getStringBounds(s, g);
                if (!(r.getWidth() > (double)maxSize)) continue;
                maxSize = (int)Math.ceil(r.getWidth());
            }
            this.legendWidth = maxSize;
        }
        return this.legendWidth;
    }

    protected void drawLegend(Graphics2D g, File f) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font("Arial", 1, 14));
        SystemPositionAndAttitude state = this.states.get(f);
        if (state == null) {
            return;
        }
        long timeUTC = (long)(this.timestampOf(f) * 1000.0);
        String depth = GuiUtils.getNeptusDecimalFormat((int)1).format(state.getPosition().getDepth());
        String alt = Double.isNaN(state.getW()) ? "N/A" : GuiUtils.getNeptusDecimalFormat((int)1).format(state.getW());
        String speed = GuiUtils.getNeptusDecimalFormat((int)1).format(state.getU());
        int roll = (int)Math.toDegrees(state.getRoll());
        int pitch = (int)Math.toDegrees(state.getPitch());
        int yaw = (int)Math.toDegrees(state.getYaw());
        String lat = CoordinateUtil.latitudeAsString((double)state.getPosition().getLatitudeDegs(), (boolean)false, (int)2);
        String lon = CoordinateUtil.longitudeAsString((double)state.getPosition().getLongitudeDegs(), (boolean)false, (int)2);
        Vector<String> details = new Vector<String>();
        details.add(lat);
        details.add(lon);
        details.add(I18n.text((String)"Time") + ": " + this.sdf.format(new Date(timeUTC)));
        details.add(I18n.text((String)"Depth") + ": " + depth);
        details.add(I18n.text((String)"Altitude") + ": " + alt);
        details.add(I18n.text((String)"Roll") + ": " + roll);
        details.add(I18n.text((String)"Pitch") + ": " + pitch);
        details.add(I18n.text((String)"Yaw") + ": " + yaw);
        details.add(I18n.text((String)"Speed") + ": " + speed);
        double width = this.getLegendWidth(details, g) + 20;
        g.setColor(new Color(0, 0, 0, 128));
        g.fill(new RoundRectangle2D.Double(10.0, 10.0, width, 155.0, 20.0, 20.0));
        g.setColor(Color.white);
        int y = 30;
        while (!details.isEmpty()) {
            g.drawString(details.firstElement(), 20, y);
            details.remove(0);
            y += 15;
        }
    }

    protected Thread loadingThread(final String name) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector<BufferedImageOp> ops = new Vector<BufferedImageOp>();
                    if (MraPhotosVisualization.this.whiteBalanceOp != null) {
                        ops.add(MraPhotosVisualization.this.whiteBalanceOp);
                    }
                    if (MraPhotosVisualization.this.contrast) {
                        ops.add(MraPhotosVisualization.this.contrastOp);
                    }
                    if (MraPhotosVisualization.this.sharpen) {
                        ops.add(MraPhotosVisualization.this.sharpenOp);
                    }
                    if (MraPhotosVisualization.this.brighten) {
                        ops.add(MraPhotosVisualization.this.brightenOp);
                    }
                    if (MraPhotosVisualization.this.grayscale) {
                        ops.add(MraPhotosVisualization.this.grayscaleOp);
                    }
                    BufferedImageOp[] operations = ops.toArray(new BufferedImageOp[0]);
                    while (!MraPhotosVisualization.this.files.isEmpty()) {
                        File nextFile = MraPhotosVisualization.this.files.take();
                        LoadedImage img = new LoadedImage();
                        BufferedImage original = ImageIO.read(nextFile);
                        img.image = MraPhotosVisualization.this.fullRes ? (!ops.isEmpty() ? Scalr.apply((BufferedImage)original, (BufferedImageOp[])operations) : original) : Scalr.resize((BufferedImage)original, (int)MraPhotosVisualization.this.getWidth(), (int)MraPhotosVisualization.this.getHeight(), (BufferedImageOp[])operations);
                        img.timestamp = MraPhotosVisualization.this.timestampOf(nextFile);
                        img.file = nextFile;
                        while (MraPhotosVisualization.this.imgs.size() > 5) {
                            System.out.println("waiting..." + MraPhotosVisualization.this.imgs.size());
                            Thread.sleep(10L);
                        }
                        MraPhotosVisualization.this.addImage(img);
                    }
                    MraPhotosVisualization.this.running.remove(this);
                }
                catch (Exception e) {
                    NeptusLog.pub().info((Object)("Thread '" + name + "' stopped"));
                    MraPhotosVisualization.this.running.remove(this);
                }
            }
        }, name);
        t.setDaemon(true);
        return t;
    }

    protected synchronized boolean addImage(LoadedImage img) {
        try {
            return this.imgs.offer(img, 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    public final double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public final void setSpeedMultiplier(double speedMultiplier) {
        this.speedMultiplier = speedMultiplier;
    }

    public File getPhotosDir() {
        return this.photosDir;
    }

    protected synchronized void setTime(double time) {
        for (int i = 0; i < this.allFiles.length; ++i) {
            if (!(this.timestampOf(this.allFiles[i]) >= time)) continue;
            this.setCurFile(this.allFiles[i]);
            return;
        }
    }

    public void onHide() {
    }

    public void onShow() {
    }

    class LoadedImage
    implements Comparable<LoadedImage> {
        public double timestamp;
        public Image image;
        public File file;

        LoadedImage() {
        }

        @Override
        public int compareTo(LoadedImage o) {
            if (this.timestamp == o.timestamp) {
                return 0;
            }
            if (this.timestamp > o.timestamp) {
                return 1;
            }
            return -1;
        }
    }
}

